/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.ManaBatteryBlock;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.menus.ManaBatteryMenu;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ManaBatteryTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainer {
    protected static final int FONT_RANGE = 5;
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int CHARGE_INV_INDEX = 1;
    protected int chargeTime;
    protected int chargeTimeTotal;
    protected int fontSiphonTime;
    protected ManaStorage manaStorage;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    protected final Set<BlockPos> fontLocations = new HashSet<BlockPos>();
    protected final ContainerData chargerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ManaBatteryTileEntity.this.chargeTime;
                case 1 -> ManaBatteryTileEntity.this.chargeTimeTotal;
                case 2 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.EARTH);
                case 3 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.EARTH);
                case 4 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.SEA);
                case 5 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.SEA);
                case 6 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.SKY);
                case 7 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.SKY);
                case 8 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.SUN);
                case 9 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.SUN);
                case 10 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.MOON);
                case 11 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.MOON);
                case 12 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.BLOOD);
                case 13 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.BLOOD);
                case 14 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.INFERNAL);
                case 15 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.INFERNAL);
                case 16 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.VOID);
                case 17 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.VOID);
                case 18 -> ManaBatteryTileEntity.this.manaStorage.getManaStored(Source.HALLOWED);
                case 19 -> ManaBatteryTileEntity.this.manaStorage.getMaxManaStored(Source.HALLOWED);
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ManaBatteryTileEntity.this.chargeTime = value;
                    break;
                }
                case 1: {
                    ManaBatteryTileEntity.this.chargeTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 20;
        }
    };

    public ManaBatteryTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.MANA_BATTERY.get(), pos, state);
        this.manaStorage = new ManaStorage(this.getBatteryCapacity(), this.getBatteryTransferCap(), Source.SORTED_SOURCES.toArray(new Source[0]));
    }

    protected int getBatteryCapacity() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ManaBatteryBlock) {
            ManaBatteryBlock batteryBlock = (ManaBatteryBlock)block;
            return switch (batteryBlock.getDeviceTier()) {
                case DeviceTier.FORBIDDEN -> 400 * WandGem.WIZARD.getCapacity();
                case DeviceTier.HEAVENLY -> 400 * WandGem.ARCHMAGE.getCapacity();
                case DeviceTier.CREATIVE -> -1;
                default -> 0;
            };
        }
        return 0;
    }

    protected int getBatteryTransferCap() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ManaBatteryBlock) {
            ManaBatteryBlock batteryBlock = (ManaBatteryBlock)block;
            return switch (batteryBlock.getDeviceTier()) {
                case DeviceTier.FORBIDDEN -> 100 * WandCap.HEXIUM.getSiphonAmount();
                case DeviceTier.HEAVENLY, DeviceTier.CREATIVE -> 100 * WandCap.HALLOWSTEEL.getSiphonAmount();
                default -> 0;
            };
        }
        return 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ManaBatteryTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack chargeStack = entity.getItem(1, 0);
            if (entity.fontSiphonTime % 20 == 0) {
                entity.scanSurroundings();
            }
            Vec3 chargerCenter = Vec3.m_82512_((Vec3i)pos);
            for (BlockPos fontPos : entity.fontLocations) {
                BlockEntity blockEntity;
                if (entity.fontSiphonTime % 5 != 0 || !((blockEntity = level.m_7702_(fontPos)) instanceof AbstractManaFontTileEntity)) continue;
                AbstractManaFontTileEntity fontEntity = (AbstractManaFontTileEntity)blockEntity;
                blockEntity = level.m_8055_(fontPos).m_60734_();
                if (!(blockEntity instanceof AbstractManaFontBlock)) continue;
                AbstractManaFontBlock fontBlock = (AbstractManaFontBlock)blockEntity;
                fontEntity.doSiphon(entity.manaStorage, level, null, chargerCenter, entity.getBatteryTransferCap());
            }
            ++entity.fontSiphonTime;
            if (!inputStack.m_41619_()) {
                if (entity.canBreakDownEssence(inputStack)) {
                    ++entity.chargeTime;
                    if (entity.chargeTime >= entity.chargeTimeTotal) {
                        entity.chargeTime = 0;
                        entity.chargeTimeTotal = entity.getChargeTimeTotal();
                        entity.breakDownEssence(inputStack);
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.chargeTime = 0;
                }
                for (Source source : Source.SORTED_SOURCES) {
                    if (!entity.canSiphonWand(inputStack, source) || !entity.doWandSiphon(inputStack, source)) continue;
                    shouldMarkDirty = true;
                }
            }
            if (!chargeStack.m_41619_()) {
                for (Source source : Source.SORTED_SOURCES) {
                    if (!entity.canOutputToWand(chargeStack, source)) continue;
                    entity.doOutput(chargeStack, source);
                    shouldMarkDirty = true;
                }
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected int getChargeTimeTotal() {
        return 100;
    }

    protected boolean canBreakDownEssence(ItemStack inputStack) {
        Item item;
        if (!inputStack.m_41619_() && (item = inputStack.m_41720_()) instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            return this.manaStorage.getManaStored(essenceItem.getSource()) < this.manaStorage.getMaxManaStored(essenceItem.getSource());
        }
        return false;
    }

    protected void breakDownEssence(ItemStack inputStack) {
        Item item;
        if (this.canBreakDownEssence(inputStack) && (item = inputStack.m_41720_()) instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            this.manaStorage.setMana(essenceItem.getSource(), this.manaStorage.getManaStored(essenceItem.getSource()) + essenceItem.getEssenceType().getManaEquivalent() * 100);
            inputStack.m_41774_(1);
        }
    }

    protected boolean canSiphonWand(ItemStack inputStack, Source source) {
        IWand wand;
        Item item;
        return !inputStack.m_41619_() && (item = inputStack.m_41720_()) instanceof IWand && (wand = (IWand)item).containsManaRaw(inputStack, source, 1) && this.manaStorage.getManaStored(source) < this.manaStorage.getMaxManaStored(source);
    }

    protected boolean doWandSiphon(ItemStack inputStack, Source source) {
        Item item;
        if (this.canSiphonWand(inputStack, source) && (item = inputStack.m_41720_()) instanceof IWand) {
            int centimanaToTransfer;
            IWand wand = (IWand)item;
            int maxTransferRate = Math.min(this.getBatteryTransferCap(), 100 * wand.getSiphonAmount(inputStack));
            int centimanaMissingInBattery = this.manaStorage.getMaxManaStored(source) - this.manaStorage.getManaStored(source);
            int centimanaPresentInWand = wand.getMana(inputStack, source);
            if (centimanaPresentInWand == -1) {
                centimanaPresentInWand = centimanaMissingInBattery;
            }
            if (wand.removeManaRaw(inputStack, source, centimanaToTransfer = Mth.m_14045_((int)Math.min(centimanaPresentInWand, centimanaMissingInBattery), (int)0, (int)maxTransferRate))) {
                this.manaStorage.receiveMana(source, centimanaToTransfer, false);
                return true;
            }
        }
        return false;
    }

    protected void scanSurroundings() {
        BlockPos pos = this.m_58899_();
        if (this.f_58857_.isAreaLoaded(pos, 5)) {
            this.fontLocations.clear();
            Iterable positions = BlockPos.m_121940_((BlockPos)pos.m_7918_(-5, -5, -5), (BlockPos)pos.m_7918_(5, 5, 5));
            for (BlockPos searchPos : positions) {
                if (!(this.f_58857_.m_8055_(searchPos).m_60734_() instanceof AbstractManaFontBlock)) continue;
                this.fontLocations.add(searchPos.m_7949_());
            }
        }
    }

    protected boolean canOutputToWand(ItemStack outputStack, Source source) {
        if (!(outputStack.m_41619_() || this.manaStorage.getMaxManaStored(source) != -1 && this.manaStorage.getManaStored(source) <= 0)) {
            Item item = outputStack.m_41720_();
            if (item instanceof IWand) {
                IWand wand = (IWand)item;
                return wand.getMana(outputStack, source) < wand.getMaxMana(outputStack);
            }
            return outputStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent();
        }
        return false;
    }

    protected void doOutput(ItemStack outputStack, Source source) {
        if (this.canOutputToWand(outputStack, source)) {
            Item item = outputStack.m_41720_();
            if (item instanceof IWand) {
                IWand wand = (IWand)item;
                int realMaxTransferRate = Math.min(this.getBatteryTransferCap() / 100, wand.getSiphonAmount(outputStack));
                int realManaToTransfer = Mth.m_14045_((int)(this.manaStorage.getManaStored(source) / 100), (int)0, (int)realMaxTransferRate);
                int leftoverRealMana = wand.addRealMana(outputStack, source, realManaToTransfer);
                int transferedCentimana = 100 * (realManaToTransfer - leftoverRealMana);
                this.manaStorage.extractMana(source, transferedCentimana, false);
            } else {
                outputStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).ifPresent(stackManaStorage -> {
                    int centimanaToTransfer = Math.min(this.getBatteryTransferCap(), this.manaStorage.getManaStored(source));
                    int transferedCentimana = stackManaStorage.receiveMana(source, centimanaToTransfer, false);
                    this.manaStorage.extractMana(source, transferedCentimana, false);
                });
                outputStack.m_41784_().m_128365_("LastUpdated", (Tag)LongTag.m_128882_((long)System.currentTimeMillis()));
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.chargeTime = compound.m_128451_("ChargeTime");
        this.chargeTimeTotal = compound.m_128451_("ChargeTimeTotal");
        this.fontSiphonTime = compound.m_128451_("FontSiphonTime");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ChargeTime", this.chargeTime);
        compound.m_128405_("ChargeTimeTotal", this.chargeTimeTotal);
        compound.m_128405_("FontSiphonTime", this.fontSiphonTime);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ManaBatteryMenu(pContainerId, pPlayerInventory, this.m_58899_(), this, this.chargerData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.EARTH);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTimeTotal = this.getChargeTimeTotal();
            this.chargeTime = 0;
            this.m_6596_();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 2;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.empty();
            default -> OptionalInt.of(1);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand || stack.m_41720_() instanceof EssenceItem;
            }
        });
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand || stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent();
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(1, 0, (ItemStack)legacyItems.get(1));
    }
}

