/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.menus.WandChargerMenu;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class WandChargerTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider {
    public static final int INPUT_INV_INDEX = 0;
    public static final int CHARGE_INV_INDEX = 1;
    protected int chargeTime;
    protected int chargeTimeTotal;
    protected final ContainerData chargerData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return WandChargerTileEntity.this.chargeTime;
                }
                case 1: {
                    return WandChargerTileEntity.this.chargeTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    WandChargerTileEntity.this.chargeTime = value;
                    break;
                }
                case 1: {
                    WandChargerTileEntity.this.chargeTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public WandChargerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.WAND_CHARGER.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 1 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.chargeTime = compound.m_128451_("ChargeTime");
        this.chargeTimeTotal = compound.m_128451_("ChargeTimeTotal");
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ChargeTime", this.chargeTime);
        compound.m_128405_("ChargeTimeTotal", this.chargeTimeTotal);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new WandChargerMenu(windowId, playerInv, this.m_58899_(), this, this.chargerData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WandChargerTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack chargeStack = entity.getItem(1, 0);
            if (!inputStack.m_41619_() && !chargeStack.m_41619_()) {
                if (entity.canCharge()) {
                    ++entity.chargeTime;
                    if (entity.chargeTime >= entity.chargeTimeTotal) {
                        entity.chargeTime = 0;
                        entity.chargeTimeTotal = entity.getChargeTimeTotal();
                        entity.doCharge();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.chargeTime = 0;
                }
            } else if (entity.chargeTime > 0) {
                entity.chargeTime = Mth.m_14045_((int)(entity.chargeTime - 2), (int)0, (int)entity.chargeTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected int getChargeTimeTotal() {
        return 200;
    }

    protected boolean canCharge() {
        Item item;
        ItemStack inputStack = this.getItem(0, 0);
        ItemStack chargeStack = this.getItem(1, 0);
        if (inputStack != null && !inputStack.m_41619_() && (item = inputStack.m_41720_()) instanceof EssenceItem) {
            EssenceItem essence = (EssenceItem)item;
            if (chargeStack != null && !chargeStack.m_41619_()) {
                Item item2 = chargeStack.m_41720_();
                if (item2 instanceof IWand) {
                    IWand wand = (IWand)item2;
                    return wand.getMana(chargeStack, essence.getSource()) < wand.getMaxMana(chargeStack);
                }
                if (chargeStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent()) {
                    IManaStorage manaCap = (IManaStorage)chargeStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).orElseThrow(IllegalArgumentException::new);
                    return manaCap.getManaStored(essence.getSource()) < manaCap.getMaxManaStored(essence.getSource());
                }
            }
        }
        return false;
    }

    protected void doCharge() {
        ItemStack inputStack = this.getItem(0, 0);
        ItemStack chargeStack = this.getItem(1, 0);
        if (this.canCharge()) {
            EssenceItem essence = (EssenceItem)inputStack.m_41720_();
            Item item = chargeStack.m_41720_();
            if (item instanceof IWand) {
                IWand wand = (IWand)item;
                wand.addRealMana(chargeStack, essence.getSource(), essence.getEssenceType().getManaEquivalent());
            } else {
                IManaStorage manaCap = (IManaStorage)chargeStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).orElseThrow(IllegalArgumentException::new);
                manaCap.receiveMana(essence.getSource(), 100 * essence.getEssenceType().getManaEquivalent(), false);
                chargeStack.m_41784_().m_128365_("LastUpdated", (Tag)LongTag.m_128882_((long)System.currentTimeMillis()));
            }
            inputStack.m_41774_(1);
        }
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTimeTotal = this.getChargeTimeTotal();
            this.chargeTime = 0;
            this.m_6596_();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 2;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.empty();
            default -> OptionalInt.of(1);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof EssenceItem;
            }
        });
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand || stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent();
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(1, 0, (ItemStack)legacyItems.get(1));
    }
}

