/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.rituals;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.rituals.OfferingPedestalBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.RitualAltarBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.SaltTrailBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.SaltSide;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.FakeMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.OfferingChannelPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.rituals.AbstractRitualStep;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.rituals.Mishap;
import com.verdantartifice.primalmagick.common.rituals.RecipeRitualStep;
import com.verdantartifice.primalmagick.common.rituals.RitualStepFactory;
import com.verdantartifice.primalmagick.common.rituals.RitualStepType;
import com.verdantartifice.primalmagick.common.rituals.UniversalRitualStep;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RitualAltarTileEntity
extends AbstractTileSidedInventoryPM
implements IInteractWithWand {
    protected static final int OUTPUT_INV_INDEX = 0;
    protected static final float MIN_STABILITY = -100.0f;
    protected static final float MAX_STABILITY = 25.0f;
    protected static final int RITUAL_SOUND_LENGTH = 58;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    protected final WeightedRandomBag<Mishap> mishaps;
    protected int ticksExisted = 0;
    protected boolean active = false;
    protected boolean currentStepComplete = false;
    protected int activeCount = 0;
    protected int nextCheckCount = 0;
    protected float stability = 0.0f;
    protected UUID activePlayerId = null;
    protected ResourceLocation activeRecipeId = null;
    protected AbstractRitualStep currentStep = null;
    protected Queue<AbstractRitualStep> remainingSteps = new LinkedList<AbstractRitualStep>();
    protected BlockPos awaitedPropPos = null;
    protected BlockPos channeledOfferingPos = null;
    protected boolean scanDirty = false;
    protected boolean skipWarningMessage = false;
    protected float symmetryDelta = 0.0f;
    protected List<BlockPos> saltPositions = new ArrayList<BlockPos>();
    protected List<BlockPos> pedestalPositions = new ArrayList<BlockPos>();
    protected List<BlockPos> propPositions = new ArrayList<BlockPos>();
    protected Map<Block, Integer> blockCounts = new HashMap<Block, Integer>();

    public RitualAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.RITUAL_ALTAR.get(), pos, state);
        this.mishaps = (WeightedRandomBag)Util.m_137469_(new WeightedRandomBag(), bag -> {
            bag.add(new Mishap(this::mishapOffering, false, 0.0f), 6.0);
            bag.add(new Mishap(this::mishapSalt, false, 10.0f), 3.0);
            bag.add(new Mishap(this::mishapDamage, false, 25.0f), 3.0);
            bag.add(new Mishap(this::mishapSalt, true, 35.0f), 2.0);
            bag.add(new Mishap(this::mishapDamage, true, 45.0f), 2.0);
            bag.add(new Mishap(this::mishapOffering, true, 50.0f), 1.0);
            bag.add(new Mishap(this::mishapDetonate, false, 75.0f), 2.0);
            bag.add(new Mishap(this::mishapDetonate, true, 90.0f), 1.0);
        });
    }

    public boolean isActive() {
        return this.active;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    @Nullable
    public Player getActivePlayer() {
        Level level;
        if (this.activePlayerId != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7654_().m_6846_().m_11259_(this.activePlayerId);
        }
        return null;
    }

    public void setActivePlayer(@Nullable Player player) {
        this.activePlayerId = player == null ? null : player.m_20148_();
    }

    @Nullable
    protected IRitualRecipe getActiveRecipe() {
        Optional recipeOpt;
        if (this.activeRecipeId != null && (recipeOpt = this.f_58857_.m_7654_().m_129894_().m_44043_(this.activeRecipeId)).isPresent() && recipeOpt.get() instanceof IRitualRecipe) {
            return (IRitualRecipe)recipeOpt.get();
        }
        return null;
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    public Color getOrbColor() {
        float saturation;
        float hue;
        if (this.stability >= 0.0f) {
            hue = 0.33333334f;
            saturation = Mth.m_14036_((float)(this.stability / 25.0f), (float)0.0f, (float)1.0f);
        } else {
            hue = 0.0f;
            saturation = Mth.m_14036_((float)(this.stability / -100.0f), (float)0.0f, (float)1.0f);
        }
        return Color.getHSBColor(hue, saturation, 1.0f);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.active = compound.m_128471_("Active");
        this.currentStepComplete = compound.m_128471_("CurrentStepComplete");
        this.activeCount = compound.m_128451_("ActiveCount");
        this.nextCheckCount = compound.m_128451_("NextCheckCount");
        this.stability = Mth.m_14036_((float)compound.m_128457_("Stability"), (float)-100.0f, (float)25.0f);
        this.activePlayerId = compound.m_128425_("ActivePlayer", 10) ? NbtUtils.m_129233_((Tag)compound.m_128469_("ActivePlayer")) : null;
        this.activeRecipeId = compound.m_128425_("ActiveRecipeId", 8) ? new ResourceLocation(compound.m_128461_("ActiveRecipeId")) : null;
        this.currentStep = null;
        if (compound.m_128425_("CurrentStep", 10)) {
            this.currentStep = RitualStepFactory.deserializeNBT(compound.m_128469_("CurrentStep"));
        }
        this.remainingSteps.clear();
        if (compound.m_128425_("RemainingSteps", 9)) {
            ListTag stepList = compound.m_128437_("RemainingSteps", 10);
            for (int index = 0; index < stepList.size(); ++index) {
                this.remainingSteps.offer(RitualStepFactory.deserializeNBT(stepList.m_128728_(index)));
            }
        }
        this.awaitedPropPos = compound.m_128425_("AwaitedPropPos", 4) ? BlockPos.m_122022_((long)compound.m_128454_("AwaitedPropPos")) : null;
        this.channeledOfferingPos = compound.m_128425_("ChanneledOfferingPos", 4) ? BlockPos.m_122022_((long)compound.m_128454_("ChanneledOfferingPos")) : null;
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128379_("CurrentStepComplete", this.currentStepComplete);
        compound.m_128405_("ActiveCount", this.activeCount);
        compound.m_128405_("NextCheckCount", this.nextCheckCount);
        compound.m_128350_("Stability", this.stability);
        if (this.activePlayerId != null) {
            compound.m_128362_("ActivePlayer", this.activePlayerId);
        }
        if (this.activeRecipeId != null) {
            compound.m_128359_("ActiveRecipeId", this.activeRecipeId.toString());
        }
        if (this.currentStep != null) {
            compound.m_128365_("CurrentStep", (Tag)this.currentStep.serializeNBT());
        }
        if (this.remainingSteps != null && !this.remainingSteps.isEmpty()) {
            ListTag stepList = new ListTag();
            for (AbstractRitualStep step : this.remainingSteps) {
                stepList.add((Object)step.serializeNBT());
            }
            compound.m_128365_("RemainingSteps", (Tag)stepList);
        }
        if (this.awaitedPropPos != null) {
            compound.m_128356_("AwaitedPropPos", this.awaitedPropPos.m_121878_());
        }
        if (this.channeledOfferingPos != null) {
            compound.m_128356_("ChanneledOfferingPos", this.channeledOfferingPos.m_121878_());
        }
    }

    protected void reset() {
        BlockState state;
        Block block;
        if (this.awaitedPropPos != null && (block = (state = this.f_58857_.m_8055_(this.awaitedPropPos)).m_60734_()) instanceof IRitualPropBlock) {
            ((IRitualPropBlock)block).closeProp(state, this.f_58857_, this.awaitedPropPos);
        }
        this.active = false;
        this.currentStepComplete = false;
        this.activeCount = 0;
        this.nextCheckCount = 0;
        this.stability = 0.0f;
        this.setActivePlayer(null);
        this.activeRecipeId = null;
        this.currentStep = null;
        this.remainingSteps.clear();
        this.awaitedPropPos = null;
        this.channeledOfferingPos = null;
        this.scanDirty = false;
        this.skipWarningMessage = false;
        this.symmetryDelta = 0.0f;
        this.pedestalPositions.clear();
        this.propPositions.clear();
        this.saltPositions.clear();
        this.blockCounts.clear();
        this.m_6596_();
        this.syncTile(false);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RitualAltarTileEntity entity) {
        if (entity.active) {
            entity.doEffects();
        }
        if (entity.ticksExisted % (entity.active ? 10 : 20) == 0 && !level.f_46443_) {
            entity.scanDirty = true;
        }
        if (entity.scanDirty && !level.f_46443_) {
            entity.scanSurroundings();
            entity.scanDirty = false;
        }
        if (!level.f_46443_ && entity.active) {
            if (entity.currentStep == null || entity.currentStepComplete) {
                if (entity.remainingSteps.isEmpty()) {
                    if (entity.activeCount >= entity.nextCheckCount) {
                        entity.finishCraft();
                        entity.m_6596_();
                        entity.syncTile(false);
                    }
                    return;
                }
                entity.currentStep = entity.remainingSteps.poll();
                entity.currentStepComplete = false;
                entity.skipWarningMessage = false;
            }
            float delta = entity.calculateStabilityDelta();
            entity.addStability(delta);
            if (entity.currentStep != null && !entity.doStep(entity.currentStep)) {
                entity.addStability(Math.min(0.0f, delta));
            }
            if (entity.activeCount % 10 == 0 && entity.stability < 0.0f && (float)level.f_46441_.m_188503_(1500) < Math.abs(entity.stability)) {
                entity.doMishap();
            }
            entity.m_6596_();
            entity.syncTile(false);
        }
        ++entity.ticksExisted;
        if (entity.active) {
            ++entity.activeCount;
        }
    }

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level level, Player player, BlockPos pos, Direction direction) {
        if (!this.f_58857_.f_46443_ && wandStack.m_41720_() instanceof IWand) {
            if (this.active) {
                player.m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.info.canceled"), false);
                this.doMishap();
                this.reset();
            } else if (!level.m_8055_(pos.m_7494_()).m_60795_() || !level.m_8055_(pos.m_6630_(2)).m_60795_()) {
                player.m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.obstructed"), false);
                this.reset();
            } else if (this.startCraft(wandStack, player)) {
                this.active = true;
                this.activeCount = 0;
                player.m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.info.started"), false);
                this.setActivePlayer(player);
                this.m_6596_();
                this.syncTile(false);
            } else {
                this.reset();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
    }

    protected void doEffects() {
        if (!this.f_58857_.f_46443_ && this.activeCount % 58 == 0) {
            PacketHandler.sendToAllAround(new PlayClientSoundPacket((SoundEvent)SoundsPM.RITUAL.get(), 1.0f, 1.0f), (ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_(), 16.0);
        }
    }

    protected boolean startCraft(ItemStack wandStack, Player player) {
        this.scanSurroundings();
        ArrayList<ItemStack> offerings = new ArrayList<ItemStack>();
        for (BlockPos offeringPos : this.pedestalPositions) {
            OfferingPedestalTileEntity pedestalTile;
            ItemStack stack;
            BlockEntity tile = this.f_58857_.m_7702_(offeringPos);
            if (!(tile instanceof OfferingPedestalTileEntity) || (stack = (pedestalTile = (OfferingPedestalTileEntity)tile).getItem()) == null || stack.m_41619_()) continue;
            offerings.add(stack);
        }
        TransientCraftingContainer inv = new TransientCraftingContainer((AbstractContainerMenu)new FakeMenu(), offerings.size(), 1);
        int offeringIndex = 0;
        for (ItemStack offering : offerings) {
            inv.m_6836_(offeringIndex++, offering);
        }
        Optional recipeOpt = this.f_58857_.m_7654_().m_129894_().m_44015_((RecipeType)RecipeTypesPM.RITUAL.get(), (Container)inv, this.f_58857_);
        if (recipeOpt.isPresent()) {
            IRitualRecipe recipe = (IRitualRecipe)recipeOpt.get();
            if (this.canUseRitualRecipe(wandStack, player, recipe) && this.generateRitualSteps(recipe)) {
                this.activeRecipeId = recipe.m_6423_();
                this.currentStep = null;
                this.currentStepComplete = false;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean generateRitualSteps(@Nonnull IRitualRecipe recipe) {
        int index;
        LinkedList<RecipeRitualStep> offeringSteps = new LinkedList<RecipeRitualStep>();
        LinkedList<AbstractRitualStep> propSteps = new LinkedList<AbstractRitualStep>();
        LinkedList<AbstractRitualStep> newSteps = new LinkedList<AbstractRitualStep>();
        for (index = 0; index < recipe.m_7527_().size(); ++index) {
            offeringSteps.add(new RecipeRitualStep(RitualStepType.OFFERING, index));
        }
        for (index = 0; index < recipe.getProps().size(); ++index) {
            propSteps.add(new RecipeRitualStep(RitualStepType.PROP, index));
        }
        for (BlockPos propPos : this.propPositions) {
            IRitualPropBlock propBlock;
            BlockState propState = this.f_58857_.m_8055_(propPos);
            Block block = propState.m_60734_();
            if (!(block instanceof IRitualPropBlock) || !(propBlock = (IRitualPropBlock)block).isUniversal() || propBlock.isPropActivated(propState, this.f_58857_, propPos)) continue;
            propSteps.add(new UniversalRitualStep(propPos, ForgeRegistries.BLOCKS.getKey((Object)block)));
        }
        Collections.shuffle(offeringSteps, RNG);
        Collections.shuffle(propSteps, RNG);
        int numOfferings = offeringSteps.size();
        int numProps = propSteps.size();
        int[] offeringBuckets = new int[numProps + 1];
        Arrays.fill(offeringBuckets, numOfferings / (numProps + 1));
        int leftoverOfferings = numOfferings % (numProps + 1);
        if (leftoverOfferings > 0) {
            int index2;
            ArrayList<Integer> leftoverBuckets = new ArrayList<Integer>();
            for (index2 = 0; index2 < numProps + 1; ++index2) {
                leftoverBuckets.add(index2 < leftoverOfferings ? 1 : 0);
            }
            Collections.shuffle(leftoverBuckets, RNG);
            for (index2 = 0; index2 < offeringBuckets.length; ++index2) {
                int n = index2;
                offeringBuckets[n] = offeringBuckets[n] + (Integer)leftoverBuckets.get(index2);
            }
        }
        for (int index3 = 0; index3 < offeringBuckets.length; ++index3) {
            if (index3 > 0) {
                newSteps.add((AbstractRitualStep)propSteps.poll());
            }
            for (int bucketIndex = 0; bucketIndex < offeringBuckets[index3]; ++bucketIndex) {
                newSteps.add((AbstractRitualStep)offeringSteps.poll());
            }
        }
        this.remainingSteps = newSteps;
        return true;
    }

    protected void finishCraft() {
        IRitualRecipe recipe = this.getActiveRecipe();
        if (recipe != null) {
            this.setItem(0, 0, recipe.m_8043_(this.m_58904_().m_9598_()).m_41777_());
        }
        if (this.getActivePlayer() != null) {
            this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.info.complete"), false);
            StatsManager.incrementValue(this.getActivePlayer(), StatsPM.RITUALS_COMPLETED);
            StatsManager.incrementValue(this.getActivePlayer(), StatsPM.CRAFTED_RITUAL);
        }
        this.spawnSuccessParticles();
        this.reset();
    }

    protected boolean canUseRitualRecipe(ItemStack wandStack, Player player, IRitualRecipe recipe) {
        return !(recipe.getRequiredResearch() != null && !recipe.getRequiredResearch().isKnownByStrict(player) || !recipe.getManaCosts().isEmpty() && !this.consumeMana(wandStack, player, recipe));
    }

    protected boolean consumeMana(ItemStack wandStack, Player player, IRitualRecipe recipe) {
        if (wandStack == null || wandStack.m_41619_() || !(wandStack.m_41720_() instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)wandStack.m_41720_();
        return wand.consumeRealMana(wandStack, player, recipe.getManaCosts());
    }

    protected void scanSurroundings() {
        this.saltPositions.clear();
        this.pedestalPositions.clear();
        this.propPositions.clear();
        this.blockCounts.clear();
        HashSet<BlockPos> scanHistory = new HashSet<BlockPos>();
        scanHistory.add(this.f_58858_);
        LinkedList<BlockPos> toScan = new LinkedList<BlockPos>();
        toScan.offer(this.f_58858_.m_122012_());
        toScan.offer(this.f_58858_.m_122029_());
        toScan.offer(this.f_58858_.m_122019_());
        toScan.offer(this.f_58858_.m_122024_());
        while (!toScan.isEmpty()) {
            BlockPos pos = (BlockPos)toScan.poll();
            this.scanPosition(pos, toScan, scanHistory);
        }
        this.symmetryDelta = this.calculateSymmetryDelta();
        Collections.shuffle(this.pedestalPositions, RNG);
        Collections.shuffle(this.propPositions, RNG);
    }

    protected void scanPosition(BlockPos pos, Queue<BlockPos> toScan, Set<BlockPos> history) {
        IRitualPropBlock propBlock;
        if (history.contains(pos)) {
            return;
        }
        history.add(pos);
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        int dist = Math.abs(this.f_58858_.m_123341_() - pos.m_123341_()) + Math.abs(this.f_58858_.m_123343_() - pos.m_123343_());
        if (dist > ((RitualAltarBlock)this.m_58900_().m_60734_()).getMaxSaltPower()) {
            return;
        }
        if (block == BlocksPM.SALT_TRAIL.get()) {
            this.saltPositions.add(pos);
            for (Map.Entry<Direction, EnumProperty<SaltSide>> entry : SaltTrailBlock.FACING_PROPERTY_MAP.entrySet()) {
                BlockPos nextPos = pos.m_121945_(entry.getKey());
                SaltSide saltSide = (SaltSide)((Object)state.m_61143_((Property)entry.getValue()));
                if (saltSide == SaltSide.UP) {
                    toScan.add(nextPos.m_7494_());
                    continue;
                }
                if (saltSide != SaltSide.SIDE) continue;
                toScan.add(nextPos);
                toScan.add(nextPos.m_7495_());
            }
        } else if (block == BlocksPM.OFFERING_PEDESTAL.get()) {
            OfferingPedestalBlock pedestalBlock = (OfferingPedestalBlock)block;
            if (pedestalBlock.isBlockSaltPowered((BlockGetter)this.f_58857_, pos)) {
                this.pedestalPositions.add(pos);
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (blockEntity instanceof OfferingPedestalTileEntity) {
                    OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)blockEntity;
                    pedestalTile.setAltarPos(this.m_58899_());
                }
            }
        } else if (block instanceof IRitualPropBlock && (propBlock = (IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)this.f_58857_, pos)) {
            this.propPositions.add(pos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity instanceof IRitualPropTileEntity) {
                IRitualPropTileEntity propTile = (IRitualPropTileEntity)blockEntity;
                propTile.setAltarPos(this.m_58899_());
            }
        }
    }

    @Nullable
    public static BlockPos getSymmetricPosition(@Nullable BlockPos altarPos, @Nullable BlockPos propPos) {
        if (altarPos == null || propPos == null) {
            return null;
        }
        int dx = altarPos.m_123341_() - propPos.m_123341_();
        int dz = altarPos.m_123343_() - propPos.m_123343_();
        return new BlockPos(altarPos.m_123341_() + dx, propPos.m_123342_(), altarPos.m_123343_() + dz);
    }

    protected float calculateSymmetryDelta() {
        float delta = 0.0f;
        HashSet<BlockPos> toScan = new HashSet<BlockPos>();
        toScan.addAll(this.pedestalPositions);
        toScan.addAll(this.propPositions);
        for (BlockPos scanPos : toScan) {
            BlockPos symPos = RitualAltarTileEntity.getSymmetricPosition(this.f_58858_, scanPos);
            Block block = this.f_58857_.m_8055_(scanPos).m_60734_();
            if (!(block instanceof IRitualStabilizer)) continue;
            IRitualStabilizer stabilizer = (IRitualStabilizer)block;
            if (stabilizer.hasSymmetryPenalty(this.f_58857_, scanPos, symPos)) {
                delta -= stabilizer.getSymmetryPenalty(this.f_58857_, scanPos);
                continue;
            }
            delta += this.calculateDiminishingStabilityBonus(block, stabilizer.getStabilityBonus(this.f_58857_, scanPos));
        }
        return delta;
    }

    protected float calculateDiminishingStabilityBonus(Block block, float baseValue) {
        float retVal = baseValue;
        int count = this.blockCounts.getOrDefault(block, 0);
        if (count > 0) {
            retVal = baseValue * (float)Math.pow(0.75, count);
        }
        this.blockCounts.put(block, count + 1);
        return retVal;
    }

    protected boolean doStep(@Nonnull AbstractRitualStep step) {
        IRitualRecipe recipe = this.getActiveRecipe();
        if (recipe == null) {
            LOGGER.warn("No recipe found when trying to do ritual step");
            return false;
        }
        if (step.getType() == RitualStepType.OFFERING) {
            return this.doOfferingStep(recipe, ((RecipeRitualStep)step).getIndex());
        }
        if (step.getType() == RitualStepType.PROP) {
            return this.doPropStep(recipe, ((RecipeRitualStep)step).getIndex());
        }
        if (step.getType() == RitualStepType.UNIVERSAL_PROP) {
            UniversalRitualStep uStep = (UniversalRitualStep)step;
            return this.doUniversalPropStep(uStep.getPos(), uStep.getExpectedId());
        }
        LOGGER.warn("Invalid ritual step type {}", (Object)step.getType());
        return false;
    }

    protected boolean doOfferingStep(IRitualRecipe recipe, int offeringIndex) {
        Ingredient requiredOffering = (Ingredient)recipe.m_7527_().get(offeringIndex);
        if (this.activeCount >= this.nextCheckCount && this.channeledOfferingPos == null) {
            for (BlockPos pedestalPos : this.pedestalPositions) {
                BlockEntity tile = this.f_58857_.m_7702_(pedestalPos);
                Block block = this.f_58857_.m_8055_(pedestalPos).m_60734_();
                if (!(tile instanceof OfferingPedestalTileEntity)) continue;
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                if (!(block instanceof ISaltPowered)) continue;
                ISaltPowered saltBlock = (ISaltPowered)block;
                if (!requiredOffering.test(pedestalTile.getItem()) || !saltBlock.isBlockSaltPowered((BlockGetter)this.f_58857_, pedestalPos)) continue;
                this.channeledOfferingPos = pedestalPos;
                this.nextCheckCount = this.activeCount + 60;
                return true;
            }
            if (!this.skipWarningMessage && this.getActivePlayer() != null) {
                if (requiredOffering.m_43947_()) {
                    this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.missing_offering.empty"), false);
                } else {
                    this.getActivePlayer().m_5661_((Component)Component.m_237110_((String)"ritual.primalmagick.warning.missing_offering", (Object[])new Object[]{requiredOffering.m_43908_()[0].m_41786_()}), false);
                }
                this.skipWarningMessage = true;
            }
            this.nextCheckCount = this.activeCount + 20;
        }
        if (this.channeledOfferingPos != null) {
            BlockEntity tile = this.f_58857_.m_7702_(this.channeledOfferingPos);
            Block block = this.f_58857_.m_8055_(this.channeledOfferingPos).m_60734_();
            if (tile instanceof OfferingPedestalTileEntity) {
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                if (block instanceof ISaltPowered) {
                    ISaltPowered saltBlock = (ISaltPowered)block;
                    if (requiredOffering.test(pedestalTile.getItem()) && saltBlock.isBlockSaltPowered((BlockGetter)this.f_58857_, this.channeledOfferingPos)) {
                        if (this.activeCount >= this.nextCheckCount) {
                            pedestalTile.removeItem(1);
                            this.currentStepComplete = true;
                            this.channeledOfferingPos = null;
                        } else {
                            this.spawnOfferingParticles(this.channeledOfferingPos, pedestalTile.getItem());
                        }
                        return true;
                    }
                }
            }
            this.channeledOfferingPos = null;
            if (this.getActivePlayer() != null) {
                if (requiredOffering.m_43947_()) {
                    this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.channel_interrupt.empty"), false);
                } else {
                    this.getActivePlayer().m_5661_((Component)Component.m_237110_((String)"ritual.primalmagick.warning.channel_interrupt", (Object[])new Object[]{requiredOffering.m_43908_()[0].m_41786_()}), false);
                }
                this.skipWarningMessage = true;
            }
            this.addStability(Mth.m_14036_((float)(50.0f * Math.min(0.0f, this.calculateStabilityDelta())), (float)-25.0f, (float)-1.0f));
        }
        return false;
    }

    protected boolean doPropStep(IRitualRecipe recipe, int propIndex) {
        BlockIngredient requiredProp = (BlockIngredient)recipe.getProps().get(propIndex);
        if (this.activeCount >= this.nextCheckCount) {
            if (this.awaitedPropPos == null) {
                for (BlockPos propPos : this.propPositions) {
                    BlockState propState = this.f_58857_.m_8055_(propPos);
                    Block block = propState.m_60734_();
                    if (!requiredProp.test(block) || !this.openProp(propPos, b -> !b.isPropActivated(propState, this.f_58857_, propPos) && b.isBlockSaltPowered((BlockGetter)this.f_58857_, propPos))) continue;
                    return true;
                }
                if (!this.skipWarningMessage && this.getActivePlayer() != null) {
                    if (requiredProp.hasNoMatchingBlocks()) {
                        this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.missing_prop.empty"), false);
                    } else {
                        this.getActivePlayer().m_5661_((Component)Component.m_237110_((String)"ritual.primalmagick.warning.missing_prop", (Object[])new Object[]{requiredProp.getMatchingBlocks()[0].m_49954_()}), false);
                    }
                    this.skipWarningMessage = true;
                }
            } else {
                BlockState propState = this.f_58857_.m_8055_(this.awaitedPropPos);
                Block block = propState.m_60734_();
                if (!(block instanceof IRitualPropBlock && requiredProp.test(block) && ((IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)this.f_58857_, this.awaitedPropPos))) {
                    this.onPropInterrupted(block, propState, ForgeRegistries.BLOCKS.getKey((Object)requiredProp.getMatchingBlocks()[0]));
                }
            }
            this.nextCheckCount = this.activeCount + 20;
        }
        return false;
    }

    protected boolean doUniversalPropStep(BlockPos propPos, ResourceLocation expectedId) {
        if (this.activeCount >= this.nextCheckCount) {
            if (this.awaitedPropPos == null) {
                BlockState propState = this.f_58857_.m_8055_(propPos);
                if (this.openProp(propPos, b -> b.isUniversal() && !b.isPropActivated(propState, this.f_58857_, propPos) && b.isBlockSaltPowered((BlockGetter)this.f_58857_, propPos))) {
                    return true;
                }
                if (!this.skipWarningMessage && this.getActivePlayer() != null) {
                    Block stepBlock = (Block)ForgeRegistries.BLOCKS.getValue(expectedId);
                    if (stepBlock == null) {
                        this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.missing_prop.empty"), false);
                    } else {
                        this.getActivePlayer().m_5661_((Component)Component.m_237110_((String)"ritual.primalmagick.warning.missing_prop", (Object[])new Object[]{stepBlock.m_49954_()}), false);
                    }
                    this.skipWarningMessage = true;
                }
            } else {
                BlockState propState = this.f_58857_.m_8055_(this.awaitedPropPos);
                Block block = propState.m_60734_();
                if (!(block instanceof IRitualPropBlock && ((IRitualPropBlock)block).isUniversal() && ((IRitualPropBlock)block).isBlockSaltPowered((BlockGetter)this.f_58857_, this.awaitedPropPos))) {
                    this.onPropInterrupted(block, propState, expectedId);
                }
            }
            this.nextCheckCount = this.activeCount + 20;
        }
        return false;
    }

    protected boolean openProp(BlockPos propPos, Predicate<IRitualPropBlock> isPropValid) {
        IRitualPropBlock propBlock;
        BlockState propState = this.f_58857_.m_8055_(propPos);
        Block block = propState.m_60734_();
        if (block instanceof IRitualPropBlock && isPropValid.test(propBlock = (IRitualPropBlock)block)) {
            propBlock.openProp(propState, this.f_58857_, propPos, this.getActivePlayer(), this.f_58858_);
            this.awaitedPropPos = propPos;
            this.nextCheckCount = this.activeCount + 20;
            return true;
        }
        return false;
    }

    protected void onPropInterrupted(Block block, BlockState propState, ResourceLocation expectedId) {
        Block expectedProp = (Block)ForgeRegistries.BLOCKS.getValue(expectedId);
        if (this.getActivePlayer() != null) {
            if (expectedProp == null) {
                this.getActivePlayer().m_5661_((Component)Component.m_237115_((String)"ritual.primalmagick.warning.prop_interrupt.empty"), false);
            } else {
                this.getActivePlayer().m_5661_((Component)Component.m_237110_((String)"ritual.primalmagick.warning.prop_interrupt", (Object[])new Object[]{expectedProp.m_49954_()}), false);
            }
            this.skipWarningMessage = true;
        }
        if (block instanceof IRitualPropBlock) {
            ((IRitualPropBlock)block).closeProp(propState, this.f_58857_, this.awaitedPropPos);
        }
        this.awaitedPropPos = null;
        this.addStability(Mth.m_14036_((float)(50.0f * Math.min(0.0f, this.calculateStabilityDelta())), (float)-25.0f, (float)-1.0f));
    }

    public void onPropActivation(BlockPos propPos, float stabilityBonus) {
        if (this.awaitedPropPos != null && this.awaitedPropPos.equals((Object)propPos)) {
            BlockState propState = this.f_58857_.m_8055_(propPos);
            Block block = propState.m_60734_();
            if (block instanceof IRitualPropBlock) {
                IRitualPropBlock propBlock = (IRitualPropBlock)block;
                propBlock.closeProp(propState, this.f_58857_, propPos);
                this.addStability(stabilityBonus);
            }
            this.currentStepComplete = true;
            this.nextCheckCount = this.activeCount;
            this.awaitedPropPos = null;
            this.m_6596_();
            this.syncTile(false);
        }
    }

    protected void addStability(float delta) {
        this.stability = Mth.m_14036_((float)(this.stability + delta), (float)-100.0f, (float)25.0f);
    }

    public float calculateStabilityDelta() {
        Block block;
        float delta = 0.0f;
        IRitualRecipe recipe = this.getActiveRecipe();
        if (recipe != null) {
            delta -= 0.01f * (float)recipe.getInstability();
        }
        if ((block = this.m_58900_().m_60734_()) instanceof RitualAltarBlock) {
            int safeSaltCount = ((RitualAltarBlock)block).getMaxSafeSalt();
            if (this.saltPositions.size() > safeSaltCount) {
                delta -= 0.001f * (float)(this.saltPositions.size() - safeSaltCount);
            }
        }
        return delta += this.symmetryDelta;
    }

    protected void spawnOfferingParticles(BlockPos startPos, ItemStack stack) {
        if (!this.f_58857_.f_46443_) {
            double sx = (double)startPos.m_123341_() + 0.4 + this.f_58857_.f_46441_.m_188500_() * 0.2;
            double sy = (double)startPos.m_123342_() + 1.4 + this.f_58857_.f_46441_.m_188500_() * 0.2;
            double sz = (double)startPos.m_123343_() + 0.4 + this.f_58857_.f_46441_.m_188500_() * 0.2;
            PacketHandler.sendToAllAround(new OfferingChannelPacket(sx, sy, sz, this.f_58858_.m_6630_(2), stack), (ResourceKey<Level>)this.f_58857_.m_46472_(), startPos, 32.0);
        }
    }

    protected void spawnSuccessParticles() {
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.2, (double)this.f_58858_.m_123343_() + 0.5, 15, 0.0, 0.0, 0.0, 0.1);
        }
    }

    protected void doMishap() {
        int attempts = 0;
        while (attempts++ < 25) {
            Mishap mishap = this.mishaps.getRandom(this.f_58857_.f_46441_);
            if (mishap == null || !mishap.execute(this.stability)) continue;
            this.addStability(5.0f + 5.0f * this.f_58857_.f_46441_.m_188501_());
            StatsManager.incrementValue(this.getActivePlayer(), StatsPM.RITUAL_MISHAPS);
            break;
        }
    }

    protected void doMishapEffects(BlockPos target, boolean playSound) {
        if (!this.f_58857_.f_46443_) {
            BlockPos source = this.f_58858_.m_6630_(2);
            PacketHandler.sendToAllAround(new SpellBoltPacket(source, target, this.getOrbColor().getRGB()), (ResourceKey<Level>)this.f_58857_.m_46472_(), source, 32.0);
            if (playSound) {
                this.f_58857_.m_5594_(null, source, (SoundEvent)SoundsPM.ELECTRIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(this.f_58857_.f_46441_.m_188583_() * 0.05));
            }
        }
    }

    protected void mishapOffering(boolean destroy) {
        int attempts = 0;
        while (attempts++ < 25 && !this.pedestalPositions.isEmpty()) {
            OfferingPedestalTileEntity pedestalTile;
            BlockPos pedestalPos = this.pedestalPositions.get(this.f_58857_.f_46441_.m_188503_(this.pedestalPositions.size()));
            BlockEntity tile = this.f_58857_.m_7702_(pedestalPos);
            if (!(tile instanceof OfferingPedestalTileEntity) || (pedestalTile = (OfferingPedestalTileEntity)tile).getItem().m_41619_()) continue;
            if (destroy) {
                pedestalTile.setItem(ItemStack.f_41583_);
            } else {
                pedestalTile.dropContents(this.f_58857_, pedestalPos);
            }
            pedestalTile.m_6596_();
            pedestalTile.syncTile(false);
            this.doMishapEffects(pedestalPos, true);
            break;
        }
    }

    protected void mishapSalt(boolean multiple) {
        int breakCount = multiple ? 2 + this.f_58857_.f_46441_.m_188503_(4) : 1;
        block0: for (int breakIndex = 0; breakIndex < breakCount; ++breakIndex) {
            int attempts = 0;
            while (attempts++ < 25 && !this.saltPositions.isEmpty()) {
                BlockPos saltPos = this.saltPositions.get(this.f_58857_.f_46441_.m_188503_(this.saltPositions.size()));
                Block block = this.f_58857_.m_8055_(saltPos).m_60734_();
                if (block != BlocksPM.SALT_TRAIL.get()) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)((double)saltPos.m_123341_() + 0.5), (double)((double)saltPos.m_123342_() + 0.5), (double)((double)saltPos.m_123343_() + 0.5), (ItemStack)new ItemStack((ItemLike)ItemsPM.REFINED_SALT.get()));
                this.f_58857_.m_7471_(saltPos, false);
                this.doMishapEffects(saltPos, breakIndex == 0);
                continue block0;
            }
        }
        this.scanDirty = true;
    }

    protected void mishapDamage(boolean allTargets) {
        List<LivingEntity> targets = EntityUtils.getEntitiesInRange(this.f_58857_, this.f_58858_, null, LivingEntity.class, 10.0);
        if (targets != null && !targets.isEmpty()) {
            for (int index = 0; index < targets.size(); ++index) {
                LivingEntity target = targets.get(index);
                int damage = 5 + Mth.m_14107_((double)(Math.sqrt(Math.abs(Math.min(0.0f, this.stability))) / 2.0));
                int amp = Math.max(0, damage - 6);
                target.m_6469_(target.m_269291_().m_269425_(), (float)damage);
                target.m_7292_(new MobEffectInstance((MobEffect)EffectsPM.MANA_IMPEDANCE.get(), 12000, amp));
                this.doMishapEffects(target.m_20183_(), index == 0);
                if (!allTargets) break;
            }
        }
    }

    protected void mishapDetonate(boolean central) {
        BlockPos target = null;
        if (central) {
            target = this.f_58858_;
        } else {
            int attempts = 0;
            while (attempts++ < 25 && !this.pedestalPositions.isEmpty()) {
                OfferingPedestalTileEntity pedestalTile;
                BlockPos pedestalPos = this.pedestalPositions.get(this.f_58857_.f_46441_.m_188503_(this.pedestalPositions.size()));
                BlockEntity tile = this.f_58857_.m_7702_(pedestalPos);
                if (!(tile instanceof OfferingPedestalTileEntity) || (pedestalTile = (OfferingPedestalTileEntity)tile).getItem().m_41619_()) continue;
                target = pedestalPos;
                break;
            }
            if (target == null && !this.pedestalPositions.isEmpty()) {
                target = this.pedestalPositions.get(this.f_58857_.f_46441_.m_188503_(this.pedestalPositions.size()));
            }
        }
        if (target != null) {
            BlockState state;
            Block block;
            if (central && this.awaitedPropPos != null && (block = (state = this.f_58857_.m_8055_(this.awaitedPropPos)).m_60734_()) instanceof IRitualPropBlock) {
                ((IRitualPropBlock)block).closeProp(state, this.f_58857_, this.awaitedPropPos);
            }
            if (!central) {
                this.doMishapEffects(target, true);
                this.scanDirty = true;
            }
            float force = central ? 3.0f + this.f_58857_.f_46441_.m_188501_() : 2.0f;
            this.f_58857_.m_254849_(null, (double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5, force, Level.ExplosionInteraction.TNT);
        }
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public ItemStack getSyncedStack() {
        return (ItemStack)((NonNullList)this.syncedInventories.get(0)).get(0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return OptionalInt.of(0);
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
    }
}

