/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class DataPackUtils {
    static String itemFilePrefix = "data/primalmagick/affinities/items/";
    static String entityFilePrefix = "data/primalmagick/affinities/entity_types/";
    static String packMCMetaFilename = "pack.mcmeta";
    static String packMCMeta = "    {\n        \"pack\": {\n          \"description\": \"Primal Magick ModPack Base Item Affinities\",\n          \"pack_format\": %d\n        }\n    }\n".formatted(SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
    static String itemTemplate = "    { \"type\": \"item\",\n      \"set\": {\n        \"earth\": 0,\n        \"sun\": 0,\n        \"moon\": 0,\n        \"sky\": 0,\n        \"sea\": 0,\n        \"blood\": 0,\n        \"infernal\": 0,\n        \"void\": 0,\n        \"hallowed\": 0\n      },\n      \"target\": \"%s\"\n    }\n";
    static String entityTemplate = "    { \"type\": \"entity_type\",\n      \"values\": {\n        \"earth\": 0,\n        \"sun\": 0,\n        \"moon\": 0,\n        \"sky\": 0,\n        \"sea\": 0,\n        \"blood\": 0,\n        \"infernal\": 0,\n        \"void\": 0,\n        \"hallowed\": 0\n      },\n      \"target\": \"%s\"\n    }\n";

    public static byte[] ItemsToDataPackTemplate(List<Item> sourceItems, List<EntityType<?>> sourceEntities) throws IOException {
        String filename;
        String target;
        ResourceLocation resourceLocation;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        ZipEntry z = new ZipEntry(packMCMetaFilename);
        zos.putNextEntry(z);
        zos.write(packMCMeta.getBytes());
        zos.closeEntry();
        for (Item item : sourceItems) {
            resourceLocation = ForgeRegistries.ITEMS.getKey((Object)item);
            if (resourceLocation == null) continue;
            target = resourceLocation.toString();
            filename = target.replace(":", "_") + ".json";
            z = new ZipEntry(itemFilePrefix + filename);
            zos.putNextEntry(z);
            zos.write(String.format(itemTemplate, target).getBytes());
            zos.closeEntry();
        }
        for (EntityType entityType : sourceEntities) {
            resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            if (resourceLocation == null) continue;
            target = resourceLocation.toString();
            filename = target.replace(":", "_") + ".json";
            z = new ZipEntry(entityFilePrefix + filename);
            zos.putNextEntry(z);
            zos.write(String.format(entityTemplate, target).getBytes());
            zos.closeEntry();
        }
        zos.close();
        return bos.toByteArray();
    }
}

