/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.TeleportArrivalPacket;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityUtils {
    @Nonnull
    public static ItemStack getEntityItemStack(Entity entity) {
        ItemStack stack = ItemStack.f_41583_;
        if (entity instanceof ItemEntity) {
            stack = ((ItemEntity)entity).m_32055_();
        } else if (entity instanceof Boat) {
            stack = new ItemStack((ItemLike)((Boat)entity).m_38369_());
        } else if (entity.m_6095_().equals(EntityType.f_20462_)) {
            stack = new ItemStack((ItemLike)Items.f_42617_);
        } else if (entity.m_6095_().equals(EntityType.f_20529_)) {
            stack = new ItemStack((ItemLike)Items.f_42650_);
        } else if (entity.m_6095_().equals(EntityType.f_20469_)) {
            stack = new ItemStack((ItemLike)Items.f_42449_);
        } else if (entity.m_6095_().equals(EntityType.f_20470_)) {
            stack = new ItemStack((ItemLike)Items.f_42519_);
        } else if (entity.m_6095_().equals(EntityType.f_20472_)) {
            stack = new ItemStack((ItemLike)Items.f_42520_);
        } else if (entity.m_6095_().equals(EntityType.f_20473_)) {
            stack = new ItemStack((ItemLike)Items.f_42694_);
        } else if (entity.m_6095_().equals(EntityType.f_20475_)) {
            stack = new ItemStack((ItemLike)Items.f_42693_);
        } else if (entity.m_6095_().equals(EntityType.f_20471_)) {
            stack = new ItemStack((ItemLike)Items.f_42657_);
        } else if (entity.m_6095_().equals(EntityType.f_20564_)) {
            stack = new ItemStack((ItemLike)Items.f_42729_);
        } else if (entity.m_6095_().equals(EntityType.f_20506_)) {
            stack = new ItemStack((ItemLike)Items.f_42487_);
        }
        return stack;
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull BlockPos center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, (double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, center.m_7096_(), center.m_7098_(), center.m_7094_(), exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        return EntityUtils.getEntitiesInRange(world, center.m_7096_(), center.m_7098_(), center.m_7094_(), exclude, entityClass, range, selector);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRange(world, x, y, z, exclude, entityClass, range, EntitySelector.f_20408_);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        List retVal = world.m_6443_(entityClass, new AABB(x, y, z, x, y, z).m_82377_(range, range, range), selector);
        if (exclude != null) {
            List excludeIds = exclude.stream().map(e -> e.m_19879_()).collect(Collectors.toList());
            retVal = retVal.stream().filter(e -> !excludeIds.contains(e.m_19879_())).collect(Collectors.toList());
        }
        return retVal;
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull BlockPos center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, (double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, exclude, entityClass, range);
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, center, exclude, entityClass, range, EntitySelector.f_20408_);
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, @Nonnull Vec3 center, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range, Predicate<Entity> selector) {
        List<T> entities = EntityUtils.getEntitiesInRange(world, center, exclude, entityClass, range, selector);
        return entities.stream().sorted(new EntityDistanceComparator(center)).collect(Collectors.toList());
    }

    public static <T extends Entity> List<T> getEntitiesInRangeSorted(@Nonnull Level world, double x, double y, double z, @Nullable List<Entity> exclude, @Nonnull Class<T> entityClass, double range) {
        return EntityUtils.getEntitiesInRangeSorted(world, new Vec3(x, y, z), exclude, entityClass, range);
    }

    public static void teleportEntity(LivingEntity player, Level world, Vec3 destination) {
        EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(player, destination.f_82479_, destination.f_82480_, destination.f_82481_);
        if (!MinecraftForge.EVENT_BUS.post((Event)event) && !world.f_46443_) {
            PacketHandler.sendToAllAround(new TeleportArrivalPacket(event.getTargetX(), event.getTargetY(), event.getTargetZ()), (ResourceKey<Level>)world.m_46472_(), BlockPos.m_274446_((Position)event.getTarget()), 64.0);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.f_8906_.f_9742_.m_129536_() && player.m_9236_() == world && !player.m_5803_()) {
                    if (player.m_20159_()) {
                        player.m_8127_();
                    }
                    StatsManager.incrementValue((Player)serverPlayer, StatsPM.DISTANCE_TELEPORTED_CM, (int)(100.0 * event.getPrev().m_82554_(event.getTarget())));
                    player.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    player.f_19789_ = 0.0f;
                }
            }
        }
    }

    protected static class EntityDistanceComparator
    implements Comparator<Entity> {
        protected final Vec3 center;

        public EntityDistanceComparator(@Nonnull Vec3 center) {
            this.center = center;
        }

        @Override
        public int compare(Entity a, Entity b) {
            double distB;
            if (a.equals((Object)b)) {
                return 0;
            }
            double distA = this.center.m_82557_(a.m_20182_());
            return distA > (distB = this.center.m_82557_(b.m_20182_())) ? 1 : (distA < distB ? -1 : 0);
        }
    }
}

