/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtils {
    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable ItemStack stack, boolean matchNBT) {
        if (player == null) {
            return false;
        }
        if (stack == null || stack.m_41619_()) {
            return true;
        }
        int count = stack.m_41613_();
        for (ItemStack searchStack : player.m_150109_().f_35974_) {
            boolean areEqual = matchNBT ? ItemStack.m_41728_((ItemStack)stack, (ItemStack)searchStack) : ItemStack.m_41656_((ItemStack)stack, (ItemStack)searchStack);
            if (!areEqual || (count -= searchStack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable ItemStack stack) {
        return InventoryUtils.isPlayerCarrying(player, stack, false);
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nonnull Item item) {
        return InventoryUtils.isPlayerCarrying(player, new ItemStack((ItemLike)item));
    }

    public static boolean isPlayerCarrying(@Nullable Player player, @Nullable ResourceLocation tagName, int amount) {
        if (player == null) {
            return false;
        }
        if (tagName == null) {
            return true;
        }
        TagKey tag = ItemTags.create((ResourceLocation)tagName);
        for (ItemStack searchStack : player.m_150109_().f_35974_) {
            if (searchStack.m_41619_() || !searchStack.m_204117_(tag) || (amount -= searchStack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable ItemStack stack, boolean matchNBT) {
        if (player == null) {
            return false;
        }
        if (stack == null || stack.m_41619_()) {
            return true;
        }
        if (!InventoryUtils.isPlayerCarrying(player, stack)) {
            return false;
        }
        int count = stack.m_41613_();
        for (int index = 0; index < player.m_150109_().f_35974_.size(); ++index) {
            boolean areEqual;
            ItemStack searchStack = (ItemStack)player.m_150109_().f_35974_.get(index);
            boolean bl = areEqual = matchNBT ? ItemStack.m_41728_((ItemStack)stack, (ItemStack)searchStack) : ItemStack.m_41656_((ItemStack)stack, (ItemStack)searchStack);
            if (!areEqual) continue;
            if (searchStack.m_41613_() > count) {
                searchStack.m_41774_(count);
                count = 0;
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, searchStack));
                }
            } else {
                count -= searchStack.m_41613_();
                player.m_150109_().f_35974_.set(index, (Object)ItemStack.f_41583_);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, ItemStack.f_41583_));
                }
            }
            if (count > 0) continue;
            InventoryUtils.addRefundItem(stack, stack.m_41613_(), player);
            return true;
        }
        return false;
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable ItemStack stack) {
        return InventoryUtils.consumeItem(player, stack, false);
    }

    public static boolean consumeItem(@Nullable Player player, @Nullable ResourceLocation tagName, int amount) {
        if (player == null) {
            return false;
        }
        if (tagName == null || amount <= 0) {
            return true;
        }
        if (!InventoryUtils.isPlayerCarrying(player, tagName, amount)) {
            return false;
        }
        TagKey tag = ItemTags.create((ResourceLocation)tagName);
        for (int index = 0; index < player.m_150109_().f_35974_.size(); ++index) {
            ItemStack searchStack = (ItemStack)player.m_150109_().f_35974_.get(index);
            if (searchStack.m_41619_() || !searchStack.m_204117_(tag)) continue;
            if (searchStack.m_41613_() > amount) {
                InventoryUtils.addRefundItem(searchStack, amount, player);
                searchStack.m_41774_(amount);
                amount = 0;
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, searchStack));
                }
            } else {
                InventoryUtils.addRefundItem(searchStack, searchStack.m_41613_(), player);
                amount -= searchStack.m_41613_();
                player.m_150109_().f_35974_.set(index, (Object)ItemStack.f_41583_);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, index, ItemStack.f_41583_));
                }
            }
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    private static void addRefundItem(ItemStack stack, int refundCount, Player player) {
        ItemEntity entity;
        ItemStack refundStack = ItemStack.f_41583_;
        if (stack.hasCraftingRemainingItem()) {
            refundStack = stack.getCraftingRemainingItem().m_255036_(refundCount);
        } else if (stack.m_150930_(Items.f_42589_)) {
            refundStack = new ItemStack((ItemLike)Items.f_42590_, refundCount);
        } else if (stack.m_150930_((Item)ItemsPM.CONCOCTION.get())) {
            refundStack = new ItemStack((ItemLike)ItemsPM.SKYGLASS_FLASK.get(), refundCount);
        }
        if (!refundStack.m_41619_() && !player.m_36356_(refundStack) && (entity = player.m_36176_(refundStack, false)) != null) {
            entity.m_32061_();
            entity.m_266426_(player.m_20148_());
        }
    }

    @Nullable
    public static IItemHandler getItemHandler(@Nonnull Level world, @Nonnull BlockPos pos, @Nullable Direction side) {
        Optional optional = VanillaInventoryCodeHooks.getItemHandler((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (Direction)side);
        Pair pair = optional.orElse(null);
        if (pair != null && pair.getLeft() != null) {
            return (IItemHandler)pair.getLeft();
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && tile instanceof Container) {
            return InventoryUtils.wrapInventory((Container)tile, side);
        }
        return null;
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable ItemStack toFind, boolean matchNBT) {
        NonNullList retVal = NonNullList.m_122779_();
        if (player != null && toFind != null && !toFind.m_41619_()) {
            for (ItemStack searchStack : player.m_150109_().f_35974_) {
                boolean areEqual = matchNBT ? ItemStack.m_41728_((ItemStack)toFind, (ItemStack)searchStack) : ItemStack.m_41656_((ItemStack)toFind, (ItemStack)searchStack);
                if (!areEqual) continue;
                retVal.add((Object)searchStack);
            }
        }
        return retVal;
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable ItemStack toFind) {
        return InventoryUtils.find(player, toFind, false);
    }

    @Nonnull
    public static NonNullList<ItemStack> find(@Nullable Player player, @Nullable ResourceLocation tagName) {
        NonNullList retVal = NonNullList.m_122779_();
        if (player != null && tagName != null) {
            TagKey tag = ItemTags.create((ResourceLocation)tagName);
            for (ItemStack searchStack : player.m_150109_().f_35974_) {
                if (searchStack.m_41619_() || !searchStack.m_204117_(tag)) continue;
                retVal.add((Object)searchStack);
            }
        }
        return retVal;
    }

    @Nonnull
    public static IItemHandler wrapInventory(@Nonnull Container inv, @Nullable Direction side) {
        if (inv instanceof WorldlyContainer) {
            return new SidedInvWrapper((WorldlyContainer)inv, side);
        }
        return new InvWrapper(inv);
    }
}

