/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemUtils {
    protected static final Logger LOGGER = LogManager.getLogger();

    public static int getHashCode(@Nullable ItemStack stack) {
        return ItemUtils.getHashCode(stack, false);
    }

    public static int getHashCode(@Nullable ItemStack stack, boolean stripNBT) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        ItemStack temp = stack.m_41777_();
        temp.m_41764_(1);
        if (stripNBT) {
            temp.m_41751_(null);
        }
        return temp.m_41739_(new CompoundTag()).toString().hashCode();
    }

    @Nonnull
    public static ItemStack parseItemStack(@Nullable String str) {
        if (str == null) {
            return ItemStack.f_41583_;
        }
        String[] tokens = str.split(";");
        String name = tokens[0];
        int count = -1;
        String nbt = null;
        if (tokens.length >= 2) {
            try {
                count = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tokens.length >= 3 && tokens[2].startsWith("{")) {
            nbt = tokens[2];
            nbt.replaceAll("\\\"", "\"");
        }
        if (count < 1) {
            count = 1;
        }
        ItemStack stack = ItemStack.f_41583_;
        try {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
            if (item != null) {
                stack = new ItemStack((ItemLike)item, count);
                if (nbt != null) {
                    stack.m_41751_(TagParser.m_129359_((String)nbt));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while parsing item stack string " + str, (Throwable)e);
        }
        return stack;
    }

    @Nonnull
    public static String serializeItemStack(@Nonnull ItemStack stack) {
        StringBuilder sb = new StringBuilder(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1 || stack.m_41782_()) {
            sb.append(';');
            sb.append(stack.m_41613_());
        }
        if (stack.m_41782_()) {
            sb.append(';');
            sb.append(stack.m_41783_().toString().replaceAll("\"", "\\\""));
        }
        return sb.toString();
    }

    @Nonnull
    public static List<ItemStack> copyItemStackList(List<ItemStack> list) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            output.add(stack.m_41777_());
        }
        return output;
    }

    @Nonnull
    public static List<ItemStack> mergeItemStackIntoList(@Nonnull List<ItemStack> list, @Nonnull ItemStack stackToCopy) {
        List<ItemStack> output = ItemUtils.copyItemStackList(list);
        ItemStack stack = stackToCopy.m_41777_();
        for (ItemStack outStack : output) {
            if (!ItemStack.m_41656_((ItemStack)outStack, (ItemStack)stack)) continue;
            if (stack.m_41613_() + outStack.m_41613_() <= outStack.m_41741_()) {
                outStack.m_41769_(stack.m_41613_());
                return output;
            }
            int toGrow = outStack.m_41741_() - outStack.m_41613_();
            outStack.m_41769_(toGrow);
            stack.m_41774_(toGrow);
        }
        for (int index = 0; index < output.size(); ++index) {
            if (!output.get(index).m_41619_()) continue;
            output.set(index, stack);
            return output;
        }
        output.add(stack);
        return output;
    }

    @Nonnull
    public static List<ItemStack> mergeItemStackLists(@Nonnull List<ItemStack> list1, @Nonnull List<ItemStack> list2) {
        List<ItemStack> output = ItemUtils.copyItemStackList(list1);
        for (ItemStack stack : list2) {
            output = ItemUtils.mergeItemStackIntoList(output, stack);
        }
        return output;
    }
}

