/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class JsonUtils {
    @Nonnull
    public static List<String> toStrings(@Nonnull JsonArray jsonArray) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            try {
                retVal.add(element.getAsString());
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    @Nonnull
    public static List<ResourceLocation> toResourceLocations(@Nonnull JsonArray jsonArray) {
        ArrayList<ResourceLocation> retVal = new ArrayList<ResourceLocation>();
        for (JsonElement element : jsonArray) {
            try {
                retVal.add(new ResourceLocation(element.getAsString()));
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    @Nonnull
    public static List<SimpleResearchKey> toSimpleResearchKeys(@Nonnull JsonArray jsonArray) {
        ArrayList<SimpleResearchKey> retVal = new ArrayList<SimpleResearchKey>();
        for (JsonElement element : jsonArray) {
            SimpleResearchKey key = SimpleResearchKey.parse(element.getAsString());
            if (key == null) continue;
            retVal.add(key);
        }
        return retVal;
    }

    @Nonnull
    public static List<Object> toOres(@Nonnull JsonArray jsonArray) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (JsonElement element : jsonArray) {
            try {
                String str = element.getAsString();
                str = str.replace("'", "\"");
                if (str.startsWith("tag:")) {
                    String[] tokens = str.split(":", 2);
                    if (tokens.length <= 1 || tokens[1].isEmpty()) continue;
                    retVal.add(new ResourceLocation(tokens[1]));
                    continue;
                }
                ItemStack stack = ItemUtils.parseItemStack(str);
                if (stack == null || stack.m_41619_()) continue;
                retVal.add(stack);
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    @Nonnull
    public static SourceList toSourceList(@Nonnull JsonObject jsonObject) {
        SourceList.Builder retVal = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            retVal.with(source, GsonHelper.m_13824_((JsonObject)jsonObject, (String)source.getTag(), (int)0));
        }
        return retVal.build();
    }
}

