/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTraceUtils {
    @Nullable
    public static HitResult getMouseOver(Level level) {
        AABB aabb;
        Minecraft mc = Minecraft.m_91087_();
        Entity viewEntity = mc.m_91288_();
        double reachDistance = mc.f_91072_.m_105291_() ? 6.0 : (double)mc.f_91072_.m_105286_();
        Vec3 eyePos = viewEntity.m_20299_(1.0f);
        double sqReachDistance = mc.f_91077_ != null ? mc.f_91077_.m_82450_().m_82557_(eyePos) : reachDistance * reachDistance;
        Vec3 lookVector = viewEntity.m_20252_(1.0f);
        Vec3 reachPos = eyePos.m_82549_(lookVector.m_82490_(reachDistance));
        EntityHitResult entityResult = RayTraceUtils.rayTraceEntities(level, viewEntity, eyePos, reachPos, aabb = viewEntity.m_20191_().m_82369_(lookVector.m_82490_(reachDistance)).m_82377_(1.0, 1.0, 1.0), testEntity -> !testEntity.m_5833_(), sqReachDistance);
        if (entityResult != null) {
            return entityResult;
        }
        return mc.f_91077_;
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(@Nonnull Level world, @Nullable Entity excludeEntity, @Nonnull Vec3 startVec, @Nonnull Vec3 endVec, @Nonnull AABB aabb, @Nullable Predicate<Entity> selector, double maxSqDistance) {
        double sqDistThreshold = maxSqDistance;
        Entity hitEntity = null;
        Vec3 hitVec = null;
        for (Entity entity : world.m_6249_(excludeEntity, aabb, selector)) {
            double sqDist;
            AABB entityAABB = entity.m_20191_().m_82400_(0.3);
            Optional optionalHitVec = entityAABB.m_82371_(startVec, endVec);
            if (!optionalHitVec.isPresent() || !((sqDist = startVec.m_82557_((Vec3)optionalHitVec.get())) < sqDistThreshold)) continue;
            hitEntity = entity;
            hitVec = (Vec3)optionalHitVec.get();
        }
        if (hitEntity == null || hitVec == null) {
            return null;
        }
        return new EntityHitResult(hitEntity, hitVec);
    }

    @Nullable
    public static BlockHitResult getBlockResultFromEntityResult(@Nullable EntityHitResult entityResult) {
        if (entityResult == null) {
            return null;
        }
        BlockPos targetPos = BlockPos.m_274446_((Position)entityResult.m_82450_());
        Vec3 entityVec = entityResult.m_82443_().m_20182_();
        BlockPos entityPos = BlockPos.m_274446_((Position)entityVec);
        Vec3 targetVec = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        Vec3 dirVec = entityVec.m_82546_(targetVec);
        Direction dir = Direction.m_122366_((double)dirVec.f_82479_, (double)dirVec.f_82480_, (double)dirVec.f_82481_);
        return new BlockHitResult(entityResult.m_82450_(), dir, entityPos, false);
    }

    public static boolean hasLineOfSight(@Nullable Entity source, @Nullable BlockPos target) {
        if (source == null || target == null) {
            return false;
        }
        Vec3 sourceVec = source.m_146892_();
        Vec3 targetVec = Vec3.m_82512_((Vec3i)target);
        ClipContext context = new ClipContext(sourceVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, source);
        BlockHitResult result = source.m_9236_().m_45547_(context);
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return target.equals((Object)result.m_82425_());
        }
        return false;
    }

    public static boolean hasLineOfSight(@Nullable Level world, @Nullable BlockPos source, @Nullable BlockPos target) {
        Vec3 endVec;
        if (world == null || source == null || target == null) {
            return false;
        }
        Vec3 startVec = new Vec3((double)source.m_123341_() + 0.5, (double)source.m_123342_() + 0.5, (double)source.m_123343_() + 0.5);
        EntitylessRayTraceContext context = new EntitylessRayTraceContext((BlockGetter)world, startVec, endVec = new Vec3((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        BlockHitResult result = RayTraceUtils.rayTraceBlocksIgnoringSource(context);
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return target.equals((Object)result.m_82425_());
        }
        return false;
    }

    protected static BlockHitResult rayTraceBlocksIgnoringSource(EntitylessRayTraceContext context) {
        return RayTraceUtils.iterateRayTrace(context, RayTraceUtils::doRayTraceCheck, RayTraceUtils::createMiss);
    }

    protected static BlockHitResult doRayTraceCheck(EntitylessRayTraceContext context, BlockPos pos) {
        BlockGetter world = context.getWorld();
        BlockState blockState = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        Vec3 startVec = context.getStartVec();
        Vec3 endVec = context.getEndVec();
        VoxelShape blockShape = context.getBlockShape(blockState, world, pos);
        BlockHitResult blockResult = RayTraceUtils.doCollisionCheck(world, startVec, endVec, pos, blockShape, blockState);
        VoxelShape fluidShape = context.getFluidShape(fluidState, world, pos);
        BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, pos);
        double blockDistanceSq = blockResult == null ? Double.MAX_VALUE : startVec.m_82557_(blockResult.m_82450_());
        double fluidDistanceSq = fluidResult == null ? Double.MAX_VALUE : startVec.m_82557_(fluidResult.m_82450_());
        return blockDistanceSq <= fluidDistanceSq ? blockResult : fluidResult;
    }

    protected static BlockHitResult createMiss(EntitylessRayTraceContext context) {
        Vec3 endVec = context.getEndVec();
        Vec3 delta = context.getStartVec().m_82546_(endVec);
        return BlockHitResult.m_82426_((Vec3)endVec, (Direction)Direction.m_122366_((double)delta.f_82479_, (double)delta.f_82480_, (double)delta.f_82481_), (BlockPos)BlockPos.m_274446_((Position)endVec));
    }

    @Nullable
    protected static BlockHitResult doCollisionCheck(BlockGetter world, Vec3 startVec, Vec3 endVec, BlockPos iteratedPos, VoxelShape iteratedShape, BlockState iteratedState) {
        BlockHitResult faceResult;
        BlockHitResult result = iteratedShape.m_83220_(startVec, endVec, iteratedPos);
        if (result != null && (faceResult = iteratedState.m_60820_(world, iteratedPos).m_83220_(startVec, endVec, iteratedPos)) != null && faceResult.m_82450_().m_82546_(startVec).m_82556_() < result.m_82450_().m_82546_(startVec).m_82556_()) {
            return result.m_82432_(faceResult.m_82434_());
        }
        return result;
    }

    protected static BlockHitResult iterateRayTrace(EntitylessRayTraceContext context, BiFunction<EntitylessRayTraceContext, BlockPos, BlockHitResult> checkFunc, Function<EntitylessRayTraceContext, BlockHitResult> missFunc) {
        Vec3 endVec;
        Vec3 startVec = context.getStartVec();
        if (startVec.equals((Object)(endVec = context.getEndVec()))) {
            return missFunc.apply(context);
        }
        double adjEndX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double adjEndY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double adjEndZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double adjStartX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double adjStartY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double adjStartZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int adjStartXFloor = Mth.m_14107_((double)adjStartX);
        int adjStartYFloor = Mth.m_14107_((double)adjStartY);
        int adjStartZFloor = Mth.m_14107_((double)adjStartZ);
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos(adjStartXFloor, adjStartYFloor, adjStartZFloor);
        double deltaX = adjEndX - adjStartX;
        double deltaY = adjEndY - adjStartY;
        double deltaZ = adjEndZ - adjStartZ;
        int signDeltaX = Mth.m_14205_((double)deltaX);
        int signDeltaY = Mth.m_14205_((double)deltaY);
        int signDeltaZ = Mth.m_14205_((double)deltaZ);
        double d9 = signDeltaX == 0 ? Double.MAX_VALUE : (double)signDeltaX / deltaX;
        double d10 = signDeltaY == 0 ? Double.MAX_VALUE : (double)signDeltaY / deltaY;
        double d11 = signDeltaZ == 0 ? Double.MAX_VALUE : (double)signDeltaZ / deltaZ;
        double d12 = d9 * (signDeltaX > 0 ? 1.0 - Mth.m_14185_((double)adjStartX) : Mth.m_14185_((double)adjStartX));
        double d13 = d10 * (signDeltaY > 0 ? 1.0 - Mth.m_14185_((double)adjStartY) : Mth.m_14185_((double)adjStartY));
        double d14 = d11 * (signDeltaZ > 0 ? 1.0 - Mth.m_14185_((double)adjStartZ) : Mth.m_14185_((double)adjStartZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            BlockHitResult result;
            if (d12 < d13) {
                if (d12 < d14) {
                    adjStartXFloor += signDeltaX;
                    d12 += d9;
                } else {
                    adjStartZFloor += signDeltaZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                adjStartYFloor += signDeltaY;
                d13 += d10;
            } else {
                adjStartZFloor += signDeltaZ;
                d14 += d11;
            }
            if ((result = checkFunc.apply(context, (BlockPos)mbp.m_122178_(adjStartXFloor, adjStartYFloor, adjStartZFloor))) == null) continue;
            return result;
        }
        return missFunc.apply(context);
    }

    protected static class EntitylessRayTraceContext {
        private final BlockGetter world;
        private final Vec3 startVec;
        private final Vec3 endVec;
        private final ClipContext.Block blockMode;
        private final ClipContext.Fluid fluidMode;

        public EntitylessRayTraceContext(BlockGetter world, Vec3 startVec, Vec3 endVec, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
            this.world = world;
            this.startVec = startVec;
            this.endVec = endVec;
            this.blockMode = blockMode;
            this.fluidMode = fluidMode;
        }

        public BlockGetter getWorld() {
            return this.world;
        }

        public Vec3 getStartVec() {
            return this.startVec;
        }

        public Vec3 getEndVec() {
            return this.endVec;
        }

        public VoxelShape getBlockShape(BlockState state, BlockGetter world, BlockPos pos) {
            return this.blockMode.m_7544_(state, world, pos, CollisionContext.m_82749_());
        }

        public VoxelShape getFluidShape(FluidState state, BlockGetter world, BlockPos pos) {
            return this.fluidMode.m_45731_(state) ? state.m_76183_(world, pos) : Shapes.m_83040_();
        }
    }
}

