/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelShapeUtils {
    private static final int HISTORY_LIMIT = 100;
    private static final Logger LOGGER = LogManager.getLogger();

    @Nonnull
    public static VoxelShape fromModel(@Nullable ResourceLocation location) {
        return VoxelShapeUtils.fromModel(location, new ArrayList<ResourceLocation>());
    }

    @Nonnull
    protected static VoxelShape fromModel(@Nullable ResourceLocation location, @Nonnull List<ResourceLocation> history) {
        InputStream stream;
        if (location == null) {
            return Shapes.m_83040_();
        }
        if (history.contains(location)) {
            LOGGER.warn("Cycle detected while getting VoxelShape from model file: {}", (Object)location.toString());
            return Shapes.m_83040_();
        }
        history.add(location);
        if (history.size() >= 100) {
            LOGGER.warn("History limit exceeded while getting VoxelShape from model file: {}", (Object)location.toString());
            return Shapes.m_83040_();
        }
        String locStr = "/assets/" + location.m_135827_() + "/models/" + location.m_135815_();
        if (!locStr.endsWith(".json")) {
            locStr = locStr + ".json";
        }
        if ((stream = VoxelShapeUtils.class.getResourceAsStream(locStr)) != null) {
            try {
                JsonObject obj = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                if (obj.has("elements")) {
                    ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
                    JsonArray elements = obj.getAsJsonArray("elements");
                    for (JsonElement element : elements) {
                        shapes.add(VoxelShapeUtils.fromModelElement(location, element.getAsJsonObject()));
                    }
                    if (shapes.isEmpty()) {
                        return Shapes.m_83040_();
                    }
                    if (shapes.size() == 1) {
                        return (VoxelShape)shapes.get(0);
                    }
                    VoxelShape firstShape = (VoxelShape)shapes.remove(0);
                    return Shapes.m_83124_((VoxelShape)firstShape, (VoxelShape[])shapes.toArray(new VoxelShape[shapes.size()]));
                }
                if (obj.has("parent")) {
                    return VoxelShapeUtils.fromModel(new ResourceLocation(obj.getAsJsonPrimitive("parent").getAsString()), history);
                }
                LOGGER.warn("No elements or parent found in VoxelShape model file: {}", (Object)location.toString());
                return Shapes.m_83040_();
            }
            catch (Exception e) {
                LOGGER.warn("Invalid VoxelShape model file: {}", (Object)location.toString());
                return Shapes.m_83040_();
            }
        }
        LOGGER.warn("VoxelShape model file not found: {}", (Object)location.toString());
        return Shapes.m_83040_();
    }

    @Nonnull
    protected static VoxelShape fromModelElement(@Nonnull ResourceLocation location, @Nonnull JsonObject obj) {
        try {
            JsonArray fromArray = obj.getAsJsonArray("from");
            JsonArray toArray = obj.getAsJsonArray("to");
            return Block.m_49796_((double)fromArray.get(0).getAsDouble(), (double)fromArray.get(1).getAsDouble(), (double)fromArray.get(2).getAsDouble(), (double)toArray.get(0).getAsDouble(), (double)toArray.get(1).getAsDouble(), (double)toArray.get(2).getAsDouble());
        }
        catch (Exception e) {
            LOGGER.warn("Invalid element in VoxelShape model file: {}", (Object)location.toString());
            return Shapes.m_83040_();
        }
    }

    @Nonnull
    public static VoxelShape rotate(@Nullable VoxelShape shape, @Nullable Direction.Axis axis, @Nullable Rotation rot) {
        if (shape == null) {
            return Shapes.m_83040_();
        }
        if (axis == null || rot == null) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int ccwRotations = (4 - rot.ordinal()) % 4;
        for (int index = 0; index < ccwRotations; ++index) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)(switch (axis) {
                    case Direction.Axis.X -> Shapes.m_83048_((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                    case Direction.Axis.Y -> Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                    case Direction.Axis.Z -> Shapes.m_83048_((double)minY, (double)(1.0 - maxX), (double)minZ, (double)maxY, (double)(1.0 - minX), (double)maxZ);
                    default -> throw new Error("Invalid axis in voxel shape rotation!");
                }));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

