/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;

public class WeightedRandomBag<T> {
    protected List<Item> items = new ArrayList<Item>();
    protected double totalWeight = 0.0;

    public boolean add(@Nullable T object, double weight) {
        Item item = new Item();
        item.obj = object;
        item.weight = weight;
        boolean success = this.items.add(item);
        if (success) {
            this.totalWeight += weight;
        }
        return success;
    }

    @Nullable
    public T getRandom(@Nonnull RandomSource rng) {
        double threshold = rng.m_188500_() * this.totalWeight;
        double accumulatedWeight = 0.0;
        for (Item item : this.items) {
            if (!((accumulatedWeight += item.weight) >= threshold)) continue;
            return item.obj;
        }
        return null;
    }

    protected class Item {
        public double weight;
        public T obj;

        protected Item() {
        }
    }
}

