/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public class WandCap
implements IWandComponent {
    protected static final Map<String, WandCap> REGISTRY = new HashMap<String, WandCap>();
    public static final WandCap IRON = new WandCap("iron", Rarity.COMMON, 1.1, 1);
    public static final WandCap GOLD = new WandCap("gold", Rarity.COMMON, 1.0, 2);
    public static final WandCap PRIMALITE = new WandCap("primalite", Rarity.UNCOMMON, 0.95, 4);
    public static final WandCap HEXIUM = new WandCap("hexium", Rarity.RARE, 0.9, 8);
    public static final WandCap HALLOWSTEEL = new WandCap("hallowsteel", Rarity.EPIC, 0.85, 16);
    protected final String tag;
    protected final Rarity rarity;
    protected final double baseCostModifier;
    protected final int siphonAmount;
    protected final ResourceLocation wandMrlNamespace;
    protected final ResourceLocation staffMrlNamespace;

    public WandCap(@Nonnull String tag, @Nonnull Rarity rarity, double costModifier, int siphon) {
        this(tag, rarity, costModifier, siphon, PrimalMagick.resource(tag + "_wand_cap"), PrimalMagick.resource(tag + "_staff_cap"));
    }

    public WandCap(@Nonnull String tag, @Nonnull Rarity rarity, double costModifier, int siphon, @Nonnull ResourceLocation wmrln, @Nonnull ResourceLocation smrln) {
        if (REGISTRY.containsKey(tag)) {
            throw new IllegalArgumentException("Wand cap " + tag + " already registered!");
        }
        this.tag = tag;
        this.rarity = rarity;
        this.baseCostModifier = costModifier;
        this.siphonAmount = siphon;
        this.wandMrlNamespace = wmrln;
        this.staffMrlNamespace = smrln;
        REGISTRY.put(tag, this);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public IWandComponent.Type getComponentType() {
        return IWandComponent.Type.CAP;
    }

    public double getBaseCostModifier() {
        return this.baseCostModifier;
    }

    public int getSiphonAmount() {
        return this.siphonAmount;
    }

    @Nonnull
    public ResourceLocation getWandModelResourceLocationNamespace() {
        return this.wandMrlNamespace;
    }

    @Nonnull
    public ResourceLocation getStaffModelResourceLocationNamespace() {
        return this.staffMrlNamespace;
    }

    @Nonnull
    public static Collection<WandCap> getAllWandCaps() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    @Nullable
    public static WandCap getWandCap(@Nullable String tag) {
        return REGISTRY.get(tag);
    }
}

