/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.wands;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public class WandGem
implements IWandComponent {
    protected static final Map<String, WandGem> REGISTRY = new HashMap<String, WandGem>();
    public static final WandGem APPRENTICE = new WandGem("apprentice", Rarity.COMMON, 75);
    public static final WandGem ADEPT = new WandGem("adept", Rarity.UNCOMMON, 250);
    public static final WandGem WIZARD = new WandGem("wizard", Rarity.RARE, 750);
    public static final WandGem ARCHMAGE = new WandGem("archmage", Rarity.EPIC, 2500);
    public static final WandGem CREATIVE = new WandGem("creative", Rarity.EPIC, -1);
    protected final String tag;
    protected final int capacity;
    protected final Rarity rarity;
    protected final ResourceLocation mrlNamespace;

    public WandGem(@Nonnull String tag, @Nonnull Rarity rarity, int capacity) {
        this(tag, rarity, capacity, PrimalMagick.resource(tag + "_wand_gem"));
    }

    public WandGem(@Nonnull String tag, @Nonnull Rarity rarity, int capacity, @Nonnull ResourceLocation mrln) {
        if (REGISTRY.containsKey(tag)) {
            throw new IllegalArgumentException("Wand gem " + tag + " already registered!");
        }
        this.tag = tag;
        this.capacity = capacity;
        this.rarity = rarity;
        this.mrlNamespace = mrln;
        REGISTRY.put(tag, this);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public IWandComponent.Type getComponentType() {
        return IWandComponent.Type.GEM;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Nonnull
    public ResourceLocation getModelResourceLocationNamespace() {
        return this.mrlNamespace;
    }

    @Nonnull
    public static Collection<WandGem> getAllWandGems() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    @Nullable
    public static WandGem getWandGem(@Nullable String tag) {
        return REGISTRY.get(tag);
    }
}

