/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrineStructure;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructurePieceTypesPM;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ShrinePiece
extends TemplateStructurePiece {
    protected static final ResourceLocation TEMPLATE = PrimalMagick.resource("shrine");
    protected final ShrineStructure.Type type;

    public ShrinePiece(StructureTemplateManager templateManager, ShrineStructure.Type type, BlockPos pos) {
        super((StructurePieceType)StructurePieceTypesPM.SHRINE.get(), 0, templateManager, TEMPLATE, TEMPLATE.toString(), ShrinePiece.makePlaceSettings(), pos);
        this.type = type;
    }

    public ShrinePiece(StructureTemplateManager templateManager, CompoundTag nbt) {
        super((StructurePieceType)StructurePieceTypesPM.SHRINE.get(), nbt, templateManager, dummy -> ShrinePiece.makePlaceSettings());
        this.type = ShrineStructure.Type.byName(nbt.m_128461_("Source"));
    }

    public ShrinePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super((StructurePieceType)StructurePieceTypesPM.SHRINE.get(), nbt, context.f_226956_(), dummy -> ShrinePiece.makePlaceSettings());
        this.type = ShrineStructure.Type.byName(nbt.m_128461_("Source"));
    }

    protected static StructurePlaceSettings makePlaceSettings() {
        return new StructurePlaceSettings().m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        super.m_183620_(context, tagCompound);
        tagCompound.m_128359_("Source", this.type.m_7912_());
    }

    protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
        if ("font".equals(function)) {
            worldIn.m_7731_(pos, this.getFont().m_49966_(), 3);
        }
    }

    @Nonnull
    protected Block getFont() {
        if (this.type == null) {
            return Blocks.f_50016_;
        }
        if (this.type.equals((Object)ShrineStructure.Type.EARTH)) {
            return (Block)BlocksPM.ANCIENT_FONT_EARTH.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SEA)) {
            return (Block)BlocksPM.ANCIENT_FONT_SEA.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SKY)) {
            return (Block)BlocksPM.ANCIENT_FONT_SKY.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SUN)) {
            return (Block)BlocksPM.ANCIENT_FONT_SUN.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.MOON)) {
            return (Block)BlocksPM.ANCIENT_FONT_MOON.get();
        }
        return Blocks.f_50016_;
    }

    @Nonnull
    protected Block getInfusedStone() {
        if (this.type == null) {
            return Blocks.f_50016_;
        }
        if (this.type.equals((Object)ShrineStructure.Type.EARTH)) {
            return (Block)BlocksPM.INFUSED_STONE_EARTH.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SEA)) {
            return (Block)BlocksPM.INFUSED_STONE_SEA.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SKY)) {
            return (Block)BlocksPM.INFUSED_STONE_SKY.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.SUN)) {
            return (Block)BlocksPM.INFUSED_STONE_SUN.get();
        }
        if (this.type.equals((Object)ShrineStructure.Type.MOON)) {
            return (Block)BlocksPM.INFUSED_STONE_MOON.get();
        }
        return Blocks.f_50016_;
    }

    public void m_213694_(WorldGenLevel worldIn, StructureManager structureManager, ChunkGenerator generator, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos chunkPos, BlockPos blockPos) {
        int i = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_());
        this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), i, this.f_73658_.m_123343_());
        super.m_213694_(worldIn, structureManager, generator, randomIn, structureBoundingBoxIn, chunkPos, blockPos);
        BlockState bs = this.getInfusedStone().m_49966_();
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (int x = 2; x < 11; ++x) {
            for (int y = -3; y < 0; ++y) {
                for (int z = 2; z < 11; ++z) {
                    mbp.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z));
                    if (worldIn.m_46859_((BlockPos)mbp) || randomIn.m_188503_(10) >= 3) continue;
                    this.m_73434_(worldIn, bs, x, y, z, structureBoundingBoxIn);
                }
            }
        }
    }
}

