/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrinePiece;
import com.verdantartifice.primalmagick.common.worldgen.structures.StructureFeaturesPM;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ShrineStructure
extends Structure {
    public static final Codec<ShrineStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShrineStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Type.CODEC.fieldOf("shrine_type").forGetter(shrine -> shrine.shrineType)).apply((Applicative)instance, ShrineStructure::new)).codec();
    private final Type shrineType;

    public ShrineStructure(Structure.StructureSettings config, Type shrineType) {
        super(config);
        this.shrineType = shrineType;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return ShrineStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureFeaturesPM.SHRINE.get();
    }

    protected void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.f_226628_().m_151390_();
        int z = context.f_226628_().m_151393_();
        int surfaceY = context.f_226622_().m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        BlockPos pos = new BlockPos(x, surfaceY, z);
        builder.m_142679_((StructurePiece)new ShrinePiece(context.f_226625_(), this.shrineType, pos));
    }

    public static enum Type implements StringRepresentable
    {
        EARTH("earth"),
        SEA("sea"),
        SKY("sky"),
        SUN("sun"),
        MOON("moon");

        private final String name;
        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;

        private Type(String name) {
            this.name = name;
        }

        public static Type byName(String name) {
            return BY_NAME.get(name);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, type -> type));
        }
    }
}

