/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.worldgen.structures;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.tags.BiomeTagsPM;
import com.verdantartifice.primalmagick.common.worldgen.structures.ShrineStructure;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class StructuresPM {
    public static final ResourceKey<Structure> EARTH_SHRINE = StructuresPM.registryKey("earth_shrine");
    public static final ResourceKey<Structure> SEA_SHRINE = StructuresPM.registryKey("sea_shrine");
    public static final ResourceKey<Structure> SKY_SHRINE = StructuresPM.registryKey("sky_shrine");
    public static final ResourceKey<Structure> SUN_SHRINE = StructuresPM.registryKey("sun_shrine");
    public static final ResourceKey<Structure> MOON_SHRINE = StructuresPM.registryKey("moon_shrine");

    private static ResourceKey<Structure> registryKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)PrimalMagick.resource(name));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> pBiomes, Map<MobCategory, StructureSpawnOverride> pSpawnOverrides, GenerationStep.Decoration pStep, TerrainAdjustment pTerrainAdaptation) {
        return new Structure.StructureSettings(pBiomes, pSpawnOverrides, pStep, pTerrainAdaptation);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> pBiomes) {
        return StructuresPM.structure(pBiomes, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN);
    }

    private static void register(BootstapContext<Structure> context, ResourceKey<Structure> structureKey, HolderSet<Biome> biomes, ShrineStructure.Type shrineType) {
        context.m_255272_(structureKey, (Object)new ShrineStructure(StructuresPM.structure(biomes), shrineType));
    }

    public static void bootstrap(BootstapContext<Structure> context) {
        HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
        StructuresPM.register(context, EARTH_SHRINE, (HolderSet<Biome>)biomeGetter.m_254956_(BiomeTagsPM.HAS_EARTH_SHRINE), ShrineStructure.Type.EARTH);
        StructuresPM.register(context, SEA_SHRINE, (HolderSet<Biome>)biomeGetter.m_254956_(BiomeTagsPM.HAS_SEA_SHRINE), ShrineStructure.Type.SEA);
        StructuresPM.register(context, SKY_SHRINE, (HolderSet<Biome>)biomeGetter.m_254956_(BiomeTagsPM.HAS_SKY_SHRINE), ShrineStructure.Type.SKY);
        StructuresPM.register(context, SUN_SHRINE, (HolderSet<Biome>)biomeGetter.m_254956_(BiomeTagsPM.HAS_SUN_SHRINE), ShrineStructure.Type.SUN);
        StructuresPM.register(context, MOON_SHRINE, (HolderSet<Biome>)biomeGetter.m_254956_(BiomeTagsPM.HAS_MOON_SHRINE), ShrineStructure.Type.MOON);
    }
}

