/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.affinities;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.common.affinities.AffinityType;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.datagen.affinities.EnchantmentBonusAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.EntityTypeAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.IFinishedAffinity;
import com.verdantartifice.primalmagick.datagen.affinities.ItemAffinityBuilder;
import com.verdantartifice.primalmagick.datagen.affinities.PotionBonusAffinityBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AffinityProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput packOutput;

    public AffinityProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        HashMap map = new HashMap();
        this.registerAffinities(affinity -> {
            if (map.computeIfAbsent(affinity.getType(), type -> new HashMap()).put(affinity.getId(), affinity) != null) {
                LOGGER.debug("Duplicate affinity in data generation: " + affinity.getId().toString());
            }
        });
        map.entrySet().forEach(typeEntry -> ((Map)typeEntry.getValue()).entrySet().forEach(affinityEntry -> {
            IFinishedAffinity affinity = (IFinishedAffinity)affinityEntry.getValue();
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)affinity.getAffinityJson(), (Path)this.getPath(this.packOutput, affinity.getType(), (ResourceLocation)affinityEntry.getKey())));
        }));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private Path getPath(PackOutput output, AffinityType affinityType, ResourceLocation entryLoc) {
        return output.m_247566_(PackOutput.Target.DATA_PACK).resolve(entryLoc.m_135827_()).resolve("affinities").resolve(affinityType.getFolder()).resolve(entryLoc.m_135815_() + ".json");
    }

    protected void registerAffinities(Consumer<IFinishedAffinity> consumer) {
        SourceList auraUnit = SourceList.builder().withEarth(1).withSea(1).withSky(1).withSun(1).withMoon(1).build();
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41905_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41958_).base((ItemLike)Items.f_41905_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42011_).base((ItemLike)Items.f_41958_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42064_).base((ItemLike)Items.f_41905_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42117_).base((ItemLike)Items.f_42064_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42170_).base((ItemLike)Items.f_41905_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42223_).base((ItemLike)Items.f_42170_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151034_).base((ItemLike)Items.f_41905_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151035_).base((ItemLike)Items.f_151034_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151040_).base((ItemLike)Items.f_151034_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151047_).base((ItemLike)Items.f_41905_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151048_).base((ItemLike)Items.f_41999_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151054_).base((ItemLike)Items.f_41905_).add(Source.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42276_).base((ItemLike)Items.f_42329_).add(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42329_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42382_).base((ItemLike)Items.f_42329_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42435_).base((ItemLike)Items.f_42329_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151064_).base((ItemLike)Items.f_42329_).add(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42488_).base((ItemLike)Items.f_42048_).add(Source.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42541_).base((ItemLike)Items.f_42048_).add(Source.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42594_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42647_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42700_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42753_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42794_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42795_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42796_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220174_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271154_).base((ItemLike)Items.f_42647_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42797_).base((ItemLike)Items.f_42647_).add(Source.MOON, 2).add(Source.INFERNAL, 2).remove(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42798_).base((ItemLike)Items.f_42797_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_243813_).base((ItemLike)Items.f_243694_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42799_).set(Source.EARTH, 10).set(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42800_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42801_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41826_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41827_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41828_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220175_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271375_).base((ItemLike)Items.f_42799_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41829_).set(Source.EARTH, 20).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41830_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271327_).base((ItemLike)Items.f_41830_).add(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41831_).base((ItemLike)Items.f_41830_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41832_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_276672_).base((ItemLike)Items.f_41832_).add(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41833_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150967_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150965_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150966_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41834_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150964_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41835_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 5).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150963_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 5).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41977_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150968_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42107_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150969_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41853_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150993_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42010_).base((ItemLike)Items.f_41905_).add(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150994_).base((ItemLike)Items.f_151034_).add(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41836_).base((ItemLike)Items.f_42048_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42154_).base((ItemLike)Items.f_42048_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42792_).base((ItemLike)Items.f_42048_).add(Source.EARTH, 5).add(Source.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_150999_).base((ItemLike)Items.f_150998_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151001_).base((ItemLike)Items.f_151000_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151002_).base((ItemLike)Items.f_151000_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151003_).base((ItemLike)Items.f_151000_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41837_).set(Source.EARTH, 10).set(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41838_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41839_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41840_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41841_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41842_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220179_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271090_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220180_).base((ItemLike)Items.f_220179_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41843_).base((ItemLike)Items.f_41837_).add(Source.MOON, 10).add(Source.INFERNAL, 10).remove(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41844_).base((ItemLike)Items.f_41843_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41845_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41846_).base((ItemLike)Items.f_41838_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41847_).base((ItemLike)Items.f_41839_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41848_).base((ItemLike)Items.f_41840_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41849_).base((ItemLike)Items.f_41841_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41850_).base((ItemLike)Items.f_41842_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220182_).base((ItemLike)Items.f_220179_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271164_).base((ItemLike)Items.f_271090_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41851_).base((ItemLike)Items.f_41843_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41879_).base((ItemLike)Items.f_41844_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41880_).base((ItemLike)Items.f_41888_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41881_).base((ItemLike)Items.f_41889_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41882_).base((ItemLike)Items.f_41890_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41883_).base((ItemLike)Items.f_41891_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41884_).base((ItemLike)Items.f_41892_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41885_).base((ItemLike)Items.f_41893_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220176_).base((ItemLike)Items.f_220177_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271182_).base((ItemLike)Items.f_271302_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_256923_).base((ItemLike)Items.f_256933_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41886_).base((ItemLike)Items.f_41894_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41887_).base((ItemLike)Items.f_41895_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41888_).base((ItemLike)Items.f_41837_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41889_).base((ItemLike)Items.f_41838_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41890_).base((ItemLike)Items.f_41839_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41891_).base((ItemLike)Items.f_41840_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41892_).base((ItemLike)Items.f_41841_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41893_).base((ItemLike)Items.f_41842_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220177_).base((ItemLike)Items.f_220179_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271302_).base((ItemLike)Items.f_271090_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41894_).base((ItemLike)Items.f_41843_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41895_).base((ItemLike)Items.f_41844_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41896_).set(Source.EARTH, 5).set(Source.SKY, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41897_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41898_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41899_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41900_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41901_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220178_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271517_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151009_).base((ItemLike)Items.f_41896_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_186362_).base((ItemLike)Items.f_151009_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41902_).set(Source.SEA, 20).set(Source.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41903_).base((ItemLike)Items.f_41902_).add(Source.SEA, 10).remove(Source.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41856_).base((ItemLike)Items.f_41905_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41863_).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41864_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41865_).base((ItemLike)Items.f_41864_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151012_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151013_).base((ItemLike)Items.f_151012_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41866_).base((ItemLike)Items.f_41864_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41867_).base((ItemLike)Items.f_41864_).add(Source.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41868_).set(Source.EARTH, 5).set(Source.SEA, 20).set(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41870_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41871_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41872_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41873_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41874_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41875_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41876_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41877_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41878_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41932_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41933_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41934_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41935_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41936_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41937_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41938_).base((ItemLike)Items.f_41870_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41939_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41940_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41941_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41942_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41943_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41944_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41945_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41946_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41947_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41948_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41949_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41950_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41951_).base((ItemLike)Items.f_41939_).add(Source.INFERNAL, 5).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271471_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_276698_).base((ItemLike)Items.f_41939_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151014_).set(Source.EARTH, 5).set(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41952_).set(Source.EARTH, 5).set(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41953_).base((ItemLike)Items.f_41952_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41954_).base((ItemLike)Items.f_41952_).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41955_).base((ItemLike)Items.f_41954_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41956_).set(Source.EARTH, 2).set(Source.MOON, 2).set(Source.INFERNAL, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41957_).base((ItemLike)Items.f_41956_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41906_).base((ItemLike)Items.f_41956_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41907_).base((ItemLike)Items.f_42029_).add(Source.MOON, 5).add(Source.INFERNAL, 5).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41908_).base((ItemLike)Items.f_41907_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41909_).set(Source.EARTH, 5).set(Source.SEA, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41910_).set(Source.EARTH, 5).set(Source.SEA, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271209_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151016_).set(Source.EARTH, 5).set(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151017_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151018_).set(Source.EARTH, 5).set(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151019_).set(Source.EARTH, 2).set(Source.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41911_).set(Source.EARTH, 5).set(Source.SKY, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41914_).set(Source.EARTH, 1).set(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41915_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41916_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41917_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41918_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271349_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41919_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41920_).base((ItemLike)Items.f_41914_).add(Source.MOON, 1).add(Source.INFERNAL, 1).remove(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41921_).base((ItemLike)Items.f_41920_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41926_).base((ItemLike)Items.f_41914_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41998_).base((ItemLike)Items.f_42594_).add(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41999_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42000_).set(Source.EARTH, 2).set(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42002_).set(Source.EARTH, 5).set(Source.MOON, 5).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42003_).base((ItemLike)Items.f_42002_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42004_).set(Source.EARTH, 5).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42007_).set(Source.BLOOD, 20).set(Source.INFERNAL, 10).set(Source.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41961_).base((ItemLike)Items.f_42329_).add(Source.SEA, 2).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41962_).set(Source.EARTH, 30).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41979_).set(Source.SEA, 2).set(Source.SKY, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41980_).set(Source.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41981_).set(Source.SEA, 5).set(Source.SKY, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_41982_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42046_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42047_).base((ItemLike)Items.f_42046_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42048_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42049_).base((ItemLike)Items.f_42048_).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42050_).base((ItemLike)Items.f_42049_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42051_).base((ItemLike)Items.f_41905_).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42053_).base((ItemLike)Items.f_42000_).add(Source.INFERNAL, 5).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42012_).base((ItemLike)Items.f_41905_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42013_).base((ItemLike)Items.f_42594_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42014_).base((ItemLike)Items.f_42018_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42015_).base((ItemLike)Items.f_42019_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42016_).base((ItemLike)Items.f_42020_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42017_).base((ItemLike)Items.f_42021_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151027_).base((ItemLike)Items.f_151034_).add(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42018_).set(Source.EARTH, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42019_).base((ItemLike)Items.f_42018_).add(Source.MOON, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42020_).base((ItemLike)Items.f_42018_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42021_).base((ItemLike)Items.f_42018_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42022_).base((ItemLike)Items.f_42024_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42023_).base((ItemLike)Items.f_42024_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42024_).set(Source.EARTH, 5).set(Source.MOON, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42028_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42029_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151025_).set(Source.EARTH, 2).set(Source.SUN, 2).set(Source.MOON, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42093_).set(Source.EARTH, 5).set(Source.MOON, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42094_).set(Source.EARTH, 2).set(Source.SEA, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42101_).set(Source.EARTH, 5).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42102_).set(Source.EARTH, 5).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42104_).set(Source.BLOOD, 20).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42147_).base((ItemLike)Items.f_42146_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42148_).base((ItemLike)Items.f_42146_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151032_).base((ItemLike)Items.f_42276_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42206_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42207_).base((ItemLike)Items.f_42206_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42208_).base((ItemLike)Items.f_42206_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42209_).base((ItemLike)Items.f_42206_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42210_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42211_).base((ItemLike)Items.f_42210_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42251_).set(Source.EARTH, 24).set(Source.SEA, 52).set(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42252_).base((ItemLike)Items.f_41856_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42258_).set(Source.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42262_).set(Source.MOON, 10).set(Source.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42260_).base((ItemLike)Items.f_42259_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42266_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42267_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42268_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42269_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42270_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42271_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42272_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42273_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42274_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42275_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42224_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42225_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42226_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42227_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42228_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42229_).base((ItemLike)Items.f_42265_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42246_).base((ItemLike)Items.f_42315_).add(Source.SEA, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42247_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42248_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42249_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42303_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42304_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42305_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42306_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42307_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42308_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42309_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42310_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42311_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42312_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42313_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42314_).base((ItemLike)Items.f_42246_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42279_).set(Source.SEA, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_276468_).set(Source.EARTH, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42280_).base((ItemLike)Items.f_42299_).add(Source.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42281_).base((ItemLike)Items.f_42295_).add(Source.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42282_).base((ItemLike)Items.f_42296_).add(Source.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42283_).base((ItemLike)Items.f_42297_).add(Source.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42284_).base((ItemLike)Items.f_42298_).add(Source.SEA, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42285_).base((ItemLike)Items.f_42280_).add(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42286_).base((ItemLike)Items.f_42281_).add(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42287_).base((ItemLike)Items.f_42282_).add(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42288_).base((ItemLike)Items.f_42283_).add(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42289_).base((ItemLike)Items.f_42284_).add(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42290_).base((ItemLike)Items.f_42299_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42291_).base((ItemLike)Items.f_42295_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42292_).base((ItemLike)Items.f_42296_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42293_).base((ItemLike)Items.f_42297_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42294_).base((ItemLike)Items.f_42298_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42299_).set(Source.EARTH, 5).set(Source.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42295_).base((ItemLike)Items.f_42299_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42296_).base((ItemLike)Items.f_42299_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42297_).base((ItemLike)Items.f_42299_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42298_).base((ItemLike)Items.f_42299_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42300_).base((ItemLike)Items.f_42290_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42301_).base((ItemLike)Items.f_42291_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42302_).base((ItemLike)Items.f_42292_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42356_).base((ItemLike)Items.f_42293_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42357_).base((ItemLike)Items.f_42294_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42358_).base((ItemLike)Items.f_42299_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42359_).base((ItemLike)Items.f_42295_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42360_).base((ItemLike)Items.f_42296_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42361_).base((ItemLike)Items.f_42297_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42362_).base((ItemLike)Items.f_42298_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42364_).set(Source.SEA, 78).set(Source.SUN, 15).set(Source.BLOOD, 12).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42741_).set(Source.SKY, 25).set(Source.VOID, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42355_).set(Source.SEA, 2).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42410_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42413_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42414_).base((ItemLike)Items.f_42413_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42415_).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42616_).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42534_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42692_).set(Source.EARTH, 10).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151049_).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151050_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42416_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151051_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151052_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151053_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42417_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42419_).set(Source.EARTH, 5).set(Source.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42393_).set(Source.EARTH, 56).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42394_).set(Source.EARTH, 45).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42395_).set(Source.EARTH, 68).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42396_).set(Source.EARTH, 68).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42397_).set(Source.EARTH, 57).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42398_).set(Source.EARTH, 1).set(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42401_).set(Source.SKY, 5).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42402_).set(Source.SKY, 20).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42403_).set(Source.EARTH, 5).set(Source.INFERNAL, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42404_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42405_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42480_).set(Source.EARTH, 90).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42481_).set(Source.EARTH, 123).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42482_).set(Source.EARTH, 112).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42483_).set(Source.EARTH, 78).set(Source.INFERNAL, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42484_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42485_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42437_).base((ItemLike)Items.f_42436_).add(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42447_).base((ItemLike)Items.f_42446_).add(Source.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42448_).base((ItemLike)Items.f_42446_).add(Source.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151055_).base((ItemLike)Items.f_42446_).add(Source.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42450_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42451_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42452_).set(Source.SEA, 2).set(Source.SKY, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42454_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42455_).base((ItemLike)Items.f_42446_).add(Source.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42456_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42457_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42458_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42459_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151057_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220210_).base((ItemLike)Items.f_42446_).add(Source.SEA, 5).add(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42460_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42461_).set(Source.EARTH, 2).set(Source.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42518_).set(Source.SEA, 5).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42521_).set(Source.SKY, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42525_).set(Source.SUN, 10).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42526_).set(Source.SEA, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42527_).set(Source.SEA, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42528_).set(Source.SEA, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42529_).set(Source.SEA, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42532_).set(Source.SEA, 5).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151056_).base((ItemLike)Items.f_42532_).add(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42533_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42535_).set(Source.SEA, 1).set(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42536_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42537_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42538_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42539_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42540_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42489_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42490_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42491_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42492_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42493_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42494_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42495_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42496_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42497_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42498_).base((ItemLike)Items.f_42535_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42499_).set(Source.MOON, 1).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42500_).set(Source.MOON, 5).set(Source.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42503_).set(Source.EARTH, 4).set(Source.SUN, 4).set(Source.BLOOD, 11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42504_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42505_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42506_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42507_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42508_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42509_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42510_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42511_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42512_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42513_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42514_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42568_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42569_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42570_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42571_).base((ItemLike)Items.f_42503_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42573_).base((ItemLike)Items.f_42676_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42575_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42576_).base((ItemLike)Items.f_41910_).remove(Source.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42577_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42578_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42579_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42581_).set(Source.SKY, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42583_).set(Source.MOON, 5).set(Source.BLOOD, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42584_).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42585_).set(Source.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42586_).set(Source.SKY, 20).set(Source.BLOOD, 5).set(Source.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42588_).set(Source.EARTH, 5).set(Source.MOON, 5).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42589_).set(Source.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42591_).set(Source.MOON, 5).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42612_).set(auraUnit.multiply(5)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42615_).base((ItemLike)Items.f_42614_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42618_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42619_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42620_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42675_).base((ItemLike)Items.f_42620_).add(Source.MOON, 5).add(Source.VOID, 2).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42676_).set(Source.EARTH, 42).set(Source.SKY, 18).set(Source.SUN, 18).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42678_).set(Source.MOON, 5).set(Source.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42679_).base((ItemLike)Items.f_42678_).add(Source.INFERNAL, 10).remove(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42680_).set(Source.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42681_).set(Source.MOON, 5).set(Source.BLOOD, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42682_).set(Source.BLOOD, 20).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42683_).set(Source.BLOOD, 20).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_260451_).set(Source.BLOOD, 20).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42686_).set(Source.EARTH, 25).set(Source.SEA, 25).set(Source.SKY, 25).set(Source.SUN, 25).set(Source.MOON, 25).set(Source.BLOOD, 25).set(Source.INFERNAL, 25).set(Source.VOID, 25).set(Source.HALLOWED, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42688_).set(Source.EARTH, 5).set(Source.SKY, 20).set(Source.SUN, 15).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42689_).base((ItemLike)Items.f_42403_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42690_).set(auraUnit.multiply(5)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42691_).base((ItemLike)Items.f_42460_).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42695_).set(Source.EARTH, 2).set(Source.SEA, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42696_).set(Source.EARTH, 5).set(Source.SEA, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42697_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42648_).set(Source.MOON, 20).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42649_).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42651_).set(Source.EARTH, 52).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42652_).set(Source.EARTH, 52).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42653_).set(Source.EARTH, 105).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42656_).set(Source.MOON, 10).set(Source.BLOOD, 10).set(Source.INFERNAL, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42658_).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42730_).set(Source.EARTH, 5).set(Source.MOON, 5).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_271133_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_276594_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42732_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42733_).set(Source.EARTH, 2).set(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42735_).set(Source.SKY, 20).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42736_).base((ItemLike)Items.f_42589_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42738_).base((ItemLike)Items.f_42412_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42739_).base((ItemLike)Items.f_42589_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42747_).set(Source.HALLOWED, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42748_).set(Source.BLOOD, 5).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42710_).set(Source.SKY, 20).set(Source.MOON, 20).set(Source.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42752_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42702_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42701_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42703_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42704_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42705_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42706_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_186363_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_283830_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42712_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42707_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42708_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42711_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42709_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220218_).set(Source.SKY, 2).set(Source.MOON, 2).set(Source.HALLOWED, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220217_).base((ItemLike)Items.f_42710_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42713_).set(Source.EARTH, 15).set(Source.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42714_).set(Source.SKY, 20).set(Source.MOON, 20).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42715_).set(Source.SEA, 20).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42716_).set(Source.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42718_).set(Source.EARTH, 12).set(Source.SUN, 4).set(Source.MOON, 7).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_186364_).base((ItemLike)Items.f_42516_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42725_).base((ItemLike)Items.f_42516_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42777_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42778_).set(Source.EARTH, 7).set(Source.SUN, 22).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42779_).set(Source.EARTH, 7).set(Source.SUN, 18).set(Source.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42780_).set(Source.EARTH, 5).set(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151079_).set(Source.EARTH, 5).set(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42783_).set(Source.EARTH, 5).set(Source.SUN, 15).set(Source.MOON, 10).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42784_).set(Source.SEA, 5).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42785_).base((ItemLike)Items.f_42786_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42787_).base((ItemLike)Items.f_42590_).add(Source.SEA, 5).add(Source.BLOOD, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42754_).base((ItemLike)Items.f_41999_).add(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42755_).base((ItemLike)Items.f_42594_).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42758_).base((ItemLike)Items.f_42755_).add(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151066_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151067_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151068_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151069_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151070_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151071_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151072_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151073_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151074_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151075_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151076_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151077_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151078_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151080_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151081_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151082_).base((ItemLike)Items.f_151065_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151083_).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151084_).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151085_).set(Source.EARTH, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151086_).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151087_).set(Source.EARTH, 2).set(Source.SEA, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220192_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220193_).set(Source.EARTH, 2).set(Source.INFERNAL, 2).set(Source.VOID, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_151042_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220194_).set(Source.EARTH, 5).set(Source.INFERNAL, 20).set(Source.VOID, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220195_).set(Source.EARTH, 5).set(Source.INFERNAL, 20).set(Source.VOID, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220216_).set(Source.EARTH, 5).set(Source.SEA, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220220_).set(Source.EARTH, 20).set(Source.SEA, 50).set(Source.SUN, 15).set(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220222_).base((ItemLike)Items.f_220220_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220221_).base((ItemLike)Items.f_220220_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220224_).set(Source.EARTH, 5).set(Source.INFERNAL, 5).set(Source.VOID, 5).set(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_220219_).set(Source.EARTH, 5).set(Source.SKY, 20).set(Source.BLOOD, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279633_).set(Source.EARTH, 20).set(Source.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279642_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279634_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279567_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279583_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279650_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279619_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279616_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279584_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279623_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279606_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279598_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279559_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279560_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279647_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279528_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279545_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279529_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279570_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_279636_).base((ItemLike)Items.f_279633_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_220863_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50375_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_152480_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50272_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50447_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50448_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50677_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50454_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_50678_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Blocks.f_220862_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42464_).set(SourceList.builder().withEarth(24).withSky(24).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42465_).set(SourceList.builder().withEarth(40).withSky(40).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42466_).set(SourceList.builder().withEarth(34).withSky(34).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)Items.f_42467_).set(SourceList.builder().withEarth(20).withSky(20).build()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.f_42657_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.f_42750_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)Items.f_42751_).build(consumer);
        SpawnEggItem.m_43233_().forEach(egg -> ItemAffinityBuilder.emptyAffinity((ItemLike)egg).build(consumer));
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.GRIMOIRE.get()).base((ItemLike)Items.f_42690_).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.CREATIVE_GRIMOIRE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_RAW.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_SLAB.get()).base((ItemLike)ItemsPM.MARBLE_SLAB.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_STAIRS.get()).base((ItemLike)ItemsPM.MARBLE_STAIRS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_WALL.get()).base((ItemLike)ItemsPM.MARBLE_WALL.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICKS.get()).base((ItemLike)ItemsPM.MARBLE_BRICKS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_SLAB.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_SLAB.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_STAIRS.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_STAIRS.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_BRICK_WALL.get()).base((ItemLike)ItemsPM.MARBLE_BRICK_WALL.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_PILLAR.get()).base((ItemLike)ItemsPM.MARBLE_PILLAR.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_CHISELED.get()).base((ItemLike)ItemsPM.MARBLE_CHISELED.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_ENCHANTED_RUNED.get()).base((ItemLike)ItemsPM.MARBLE_RUNED.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_SMOKED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(Source.MOON, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MARBLE_HALLOWED.get()).base((ItemLike)ItemsPM.MARBLE_RAW.get()).add(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_LOG.get()).base((ItemLike)Items.f_41837_).add(Source.MOON, 20).remove(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_MOONWOOD_LOG.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_WOOD.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_MOONWOOD_WOOD.get()).base((ItemLike)ItemsPM.MOONWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_LEAVES.get()).base((ItemLike)Items.f_41896_).add(Source.MOON, 10).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_SAPLING.get()).base((ItemLike)Items.f_42799_).add(Source.MOON, 20).remove(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_PLANKS.get()).base((ItemLike)Items.f_42647_).add(Source.MOON, 4).remove(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MOONWOOD_SLAB.get()).base((ItemLike)Items.f_41914_).add(Source.MOON, 2).remove(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_LOG.get()).base((ItemLike)Items.f_41837_).add(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_SUNWOOD_LOG.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_WOOD.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_SUNWOOD_WOOD.get()).base((ItemLike)ItemsPM.SUNWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_LEAVES.get()).base((ItemLike)Items.f_41896_).add(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_SAPLING.get()).base((ItemLike)Items.f_42799_).add(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_PLANKS.get()).base((ItemLike)Items.f_42647_).add(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SUNWOOD_SLAB.get()).base((ItemLike)Items.f_41914_).add(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).base((ItemLike)Items.f_41837_).add(Source.HALLOWED, 10).remove(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_HALLOWOOD_LOG.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_WOOD.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STRIPPED_HALLOWOOD_WOOD.get()).base((ItemLike)ItemsPM.HALLOWOOD_LOG.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_LEAVES.get()).base((ItemLike)Items.f_41896_).add(Source.HALLOWED, 5).remove(Source.SUN, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_SAPLING.get()).base((ItemLike)Items.f_42799_).add(Source.HALLOWED, 10).remove(Source.SUN, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_PLANKS.get()).base((ItemLike)Items.f_42647_).add(Source.HALLOWED, 2).remove(Source.SUN, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWOOD_SLAB.get()).base((ItemLike)Items.f_41914_).add(Source.HALLOWED, 1).remove(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HYDROMELON_SEEDS.get()).base((ItemLike)Items.f_42578_).add(Source.SEA, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HYDROMELON_SLICE.get()).base((ItemLike)Items.f_42575_).add(Source.SEA, 6).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOOD_ROSE.get()).set(SourceList.builder().withEarth(5).withMoon(5).withBlood(20).build()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.EMBERFLOWER.get()).base((ItemLike)Items.f_42206_).add(Source.SUN, 5).add(Source.INFERNAL, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_EARTH.get()).base((ItemLike)Items.f_41905_).add(Source.EARTH, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SEA.get()).base((ItemLike)Items.f_41905_).add(Source.SEA, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SKY.get()).base((ItemLike)Items.f_41905_).add(Source.SKY, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_SUN.get()).base((ItemLike)Items.f_41905_).add(Source.SUN, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INFUSED_STONE_MOON.get()).base((ItemLike)Items.f_41905_).add(Source.MOON, 1).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_AMETHYST_CLUSTER.get()).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_AMETHYST_BUD.get()).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_AMETHYST_BUD.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_AMETHYST_BUD.get()).set(Source.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.f_150998_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.f_150998_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_AMETHYST_BLOCK.get()).base((ItemLike)Items.f_150998_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_DIAMOND_CLUSTER.get()).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_DIAMOND_BUD.get()).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_DIAMOND_BUD.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_DIAMOND_BUD.get()).set(Source.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.f_41959_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.f_41959_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_DIAMOND_BLOCK.get()).base((ItemLike)Items.f_41959_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_EMERALD_CLUSTER.get()).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_EMERALD_BUD.get()).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_EMERALD_BUD.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_EMERALD_BUD.get()).set(Source.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.f_42110_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.f_42110_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_EMERALD_BLOCK.get()).base((ItemLike)Items.f_42110_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SYNTHETIC_QUARTZ_CLUSTER.get()).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LARGE_SYNTHETIC_QUARTZ_BUD.get()).set(Source.EARTH, 10).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MEDIUM_SYNTHETIC_QUARTZ_BUD.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SMALL_SYNTHETIC_QUARTZ_BUD.get()).set(Source.EARTH, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.f_42157_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.f_42157_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FLAWED_BUDDING_QUARTZ_BLOCK.get()).base((ItemLike)Items.f_42157_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BLACK.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_BROWN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_CYAN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_GREEN.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_LIME.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_MAGENTA.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_ORANGE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PINK.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PURPLE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_RED.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_WHITE.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_YELLOW.get()).base((ItemLike)ItemsPM.SKYGLASS.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SKYGLASS_PANE.get()).base((ItemLike)Items.f_42027_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLACK.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_BROWN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_CYAN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_GREEN.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_LIME.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_MAGENTA.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_ORANGE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PINK.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_PURPLE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_RED.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_WHITE.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STAINED_SKYGLASS_PANE_YELLOW.get()).base((ItemLike)ItemsPM.SKYGLASS_PANE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_EARTH.get()).set(Source.EARTH, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SEA.get()).set(Source.SEA, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SKY.get()).set(Source.SKY, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_SUN.get()).set(Source.SUN, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ANCIENT_FONT_MOON.get()).set(Source.MOON, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ROCK_SALT_ORE.get()).base((ItemLike)Items.f_41905_).add(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.QUARTZ_ORE.get()).base((ItemLike)Items.f_41905_).add(Source.EARTH, 10).add(Source.INFERNAL, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ARCANE_WORKBENCH.get()).base((ItemLike)Items.f_41960_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ESSENCE_FURNACE.get()).base((ItemLike)Items.f_41962_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CALCINATOR_BASIC.get()).set(auraUnit.multiply(5)).set(Source.EARTH, 46).set(Source.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CALCINATOR_ENCHANTED.get()).set(auraUnit.multiply(26)).set(Source.EARTH, 77).set(Source.INFERNAL, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).set(Source.SEA, 3).set(Source.SKY, 3).set(Source.SUN, 1).set(Source.BLOOD, 4).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_ORANGE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_MAGENTA.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_BLUE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_YELLOW.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIME.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_PINK.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_GRAY.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_LIGHT_GRAY.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_CYAN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_PURPLE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BLUE.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BROWN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_GREEN.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_RED.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.RITUAL_CANDLE_BLACK.get()).base((ItemLike)ItemsPM.RITUAL_CANDLE_WHITE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MUNDANE_WAND.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MODULAR_WAND.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MODULAR_STAFF.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOODY_FLESH.get()).set(Source.BLOOD, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BLOOD_NOTES.get()).set(Source.BLOOD, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWED_ORB.get()).set(Source.HALLOWED, 25).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ENCHANTED_INK.get()).set(Source.SEA, 3).set(Source.MOON, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ROCK_SALT.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.REFINED_SALT.get()).base((ItemLike)ItemsPM.ROCK_SALT.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MANA_PRISM.get()).set(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MANA_SALTS.get()).set(auraUnit.multiply(5)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.BEESWAX.get()).set(Source.SEA, 2).set(Source.BLOOD, 2).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.PRIMALITE_INGOT.get()).set(auraUnit.multiply(3)).set(Source.EARTH, 11).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEXIUM_INGOT.get()).set(auraUnit.multiply(2)).set(Source.EARTH, 8).set(Source.BLOOD, 15).set(Source.INFERNAL, 15).set(Source.VOID, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HALLOWSTEEL_INGOT.get()).set(auraUnit).set(Source.EARTH, 6).set(Source.BLOOD, 11).set(Source.INFERNAL, 11).set(Source.VOID, 11).set(Source.HALLOWED, 37).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SPELLCLOTH.get()).set(Source.EARTH, 4).set(Source.SEA, 4).set(Source.SKY, 19).set(Source.SUN, 4).set(Source.MOON, 4).set(Source.BLOOD, 9).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEXWEAVE.get()).set(Source.EARTH, 3).set(Source.SEA, 3).set(Source.SKY, 29).set(Source.SUN, 3).set(Source.MOON, 3).set(Source.BLOOD, 30).set(Source.INFERNAL, 27).set(Source.VOID, 27).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HEARTWOOD.get()).set(auraUnit.multiply(5)).set(Source.EARTH, 15).set(Source.SUN, 15).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.INCENSE_STICK.get()).set(Source.EARTH, 4).set(Source.SKY, 5).set(Source.SUN, 4).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.DOWSING_ROD.get()).set(Source.EARTH, 3).set(Source.SUN, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.FOUR_LEAF_CLOVER.get()).set(Source.EARTH, 5).set(Source.SUN, 5).set(Source.MOON, 20).set(Source.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).set(Source.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_EARTH.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SEA.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SKY.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_SUN.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_MOON.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_BLOOD.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_INFERNAL.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_VOID.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.HUMMING_ARTIFACT_HALLOWED.get()).base((ItemLike)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.TREEFOLK_SEED.get()).set(Source.EARTH, 20).set(Source.SUN, 20).set(Source.HALLOWED, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.APPRENTICE_WAND_GEM_ITEM.get()).base((ItemLike)Items.f_42415_).add(auraUnit.multiply(2)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ADEPT_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.APPRENTICE_WAND_GEM_ITEM.get()).add(auraUnit).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.WIZARD_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.ADEPT_WAND_GEM_ITEM.get()).add(auraUnit.multiply(2)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.ARCHMAGE_WAND_GEM_ITEM.get()).base((ItemLike)ItemsPM.WIZARD_WAND_GEM_ITEM.get()).add(auraUnit.multiply(2)).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.CREATIVE_WAND_GEM_ITEM.get()).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_EARTH.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_SEA.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_SKY.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_SUN.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_MOON.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_BLOOD.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_INFERNAL.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_VOID.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_DUST_HALLOWED.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_EARTH.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_SEA.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_SKY.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_SUN.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_MOON.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_BLOOD.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_INFERNAL.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_VOID.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_SHARD_HALLOWED.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_EARTH.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_SEA.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_SKY.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_SUN.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_MOON.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_VOID.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_EARTH.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_SEA.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_SKY.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_SUN.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_MOON.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_BLOOD.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_INFERNAL.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_VOID.get())).build(consumer);
        ItemAffinityBuilder.essenceAffinity((EssenceItem)((Object)ItemsPM.ESSENCE_CLUSTER_HALLOWED.get())).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SPELL_SCROLL_FILLED.get()).base((ItemLike)ItemsPM.SPELL_SCROLL_BLANK.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.MANA_SINGULARITY_CREATIVE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.ALCHEMICAL_WASTE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get()).set(Source.INFERNAL, 3).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.OBSERVATION_NOTES.get()).set(auraUnit.multiply(5).add(Source.HALLOWED, 5)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.THEORY_NOTES.get()).set(auraUnit.multiply(20).add(Source.HALLOWED, 20)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get()).set(auraUnit.multiply(3).add(Source.HALLOWED, 3)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.SHEEP_TOME.get()).set(auraUnit.multiply(5).add(Source.MOON, 15).add(Source.HALLOWED, 20)).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_BOOK.get()).base((ItemLike)Items.f_42615_).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.STATIC_TABLET.get()).set(Source.EARTH, 20).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.CODEX.get()).base((ItemLike)Items.f_42615_).add(Source.HALLOWED, 5).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.CODEX_CREATIVE.get()).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LORE_TABLET_FRAGMENT.get()).set(Source.EARTH, 5).build(consumer);
        ItemAffinityBuilder.itemAffinity((ItemLike)ItemsPM.LORE_TABLET_DIRTY.get()).base((ItemLike)ItemsPM.STATIC_TABLET.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_BASIC_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_GRAND_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_EARTH_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SEA_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SKY_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_SUN_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_MOON_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_BLOOD_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_INFERNAL_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_VOID_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.DRAINED_MAJESTIC_HALLOWED_PIXIE.get()).build(consumer);
        ItemAffinityBuilder.emptyAffinity((ItemLike)ItemsPM.TICK_STICK.get()).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_217014_).value(Source.SKY, 10).value(Source.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_147039_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20549_).value(Source.SKY, 10).value(Source.MOON, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20550_).value(Source.SKY, 10).value(Source.SUN, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20551_).value(Source.SKY, 10).value(Source.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_243976_).value(Source.SUN, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20553_).value(Source.MOON, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20554_).value(Source.EARTH, 10).value(Source.MOON, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20555_).value(Source.SKY, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20556_).value(Source.SEA, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20557_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20558_).value(Source.EARTH, 5).value(Source.SUN, 5).value(Source.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20559_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20560_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20562_).value(Source.SEA, 5).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20563_).value(Source.SEA, 20).value(Source.BLOOD, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20565_).value(Source.SKY, 20).value(Source.BLOOD, 50).value(Source.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20566_).value(Source.BLOOD, 10).value(Source.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20567_).value(Source.BLOOD, 5).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20568_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20452_).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_217012_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20453_).value(Source.SKY, 10).value(Source.BLOOD, 10).value(Source.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_147034_).value(Source.SEA, 10).value(Source.SUN, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_147035_).value(Source.SKY, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20455_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20456_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20457_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20458_).value(Source.SUN, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20459_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20460_).value(Source.EARTH, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20466_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20468_).value(Source.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20503_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20504_).value(Source.MOON, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20505_).value(Source.MOON, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20507_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20508_).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20509_).value(Source.SKY, 10).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20510_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20511_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20512_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20513_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20514_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20516_).value(Source.SEA, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20517_).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20518_).value(Source.BLOOD, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20519_).value(Source.SEA, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20520_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20521_).value(Source.BLOOD, 10).value(Source.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20523_).value(Source.EARTH, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20524_).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20525_).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20526_).value(Source.SEA, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_271264_).value(Source.EARTH, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20528_).value(Source.SEA, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20479_).value(Source.MOON, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20480_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20481_).value(Source.SEA, 5).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20482_).value(Source.BLOOD, 10).value(Source.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_217013_).value(Source.SEA, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20488_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20489_).value(Source.SEA, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20490_).value(Source.SEA, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20491_).value(Source.SKY, 10).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20492_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20493_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20494_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_217015_).value(Source.EARTH, 50).value(Source.INFERNAL, 20).value(Source.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20495_).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20496_).value(Source.SKY, 20).value(Source.INFERNAL, 50).value(Source.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20497_).value(Source.BLOOD, 10).value(Source.INFERNAL, 10).value(Source.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20499_).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20500_).value(Source.MOON, 10).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20501_).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20502_).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20530_).value(Source.MOON, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity(EntityType.f_20531_).value(Source.MOON, 10).value(Source.BLOOD, 10).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.TREEFOLK.get()).value(Source.EARTH, 10).value(Source.SUN, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.INNER_DEMON.get()).value(Source.BLOOD, 50).value(Source.INFERNAL, 50).value(Source.VOID, 50).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.PRIMALITE_GOLEM.get()).value(Source.EARTH, 30).value(Source.SEA, 10).value(Source.SKY, 10).value(Source.SUN, 10).value(Source.MOON, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.HEXIUM_GOLEM.get()).value(Source.EARTH, 20).value(Source.BLOOD, 10).value(Source.INFERNAL, 10).value(Source.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.HALLOWSTEEL_GOLEM.get()).value(Source.EARTH, 20).value(Source.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_EARTH_PIXIE.get()).value(Source.EARTH, 5).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_EARTH_PIXIE.get()).value(Source.EARTH, 10).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_EARTH_PIXIE.get()).value(Source.EARTH, 20).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_SEA_PIXIE.get()).value(Source.SEA, 5).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_SEA_PIXIE.get()).value(Source.SEA, 10).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_SEA_PIXIE.get()).value(Source.SEA, 20).value(Source.SKY, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_SKY_PIXIE.get()).value(Source.SKY, 15).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_SKY_PIXIE.get()).value(Source.SKY, 20).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_SKY_PIXIE.get()).value(Source.SKY, 30).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_SUN_PIXIE.get()).value(Source.SKY, 10).value(Source.SUN, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_SUN_PIXIE.get()).value(Source.SKY, 10).value(Source.SUN, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_SUN_PIXIE.get()).value(Source.SKY, 10).value(Source.SUN, 20).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_MOON_PIXIE.get()).value(Source.SKY, 10).value(Source.MOON, 5).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_MOON_PIXIE.get()).value(Source.SKY, 10).value(Source.MOON, 10).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_MOON_PIXIE.get()).value(Source.SKY, 10).value(Source.MOON, 20).value(Source.BLOOD, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_BLOOD_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_BLOOD_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 15).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_BLOOD_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 25).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_INFERNAL_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.INFERNAL, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_INFERNAL_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.INFERNAL, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_INFERNAL_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.INFERNAL, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_VOID_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.VOID, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_VOID_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.VOID, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_VOID_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.VOID, 20).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.BASIC_HALLOWED_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.HALLOWED, 5).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.GRAND_HALLOWED_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.HALLOWED, 10).build(consumer);
        EntityTypeAffinityBuilder.entityAffinity((EntityType)EntityTypesPM.MAJESTIC_HALLOWED_PIXIE.get()).value(Source.SKY, 10).value(Source.BLOOD, 5).value(Source.HALLOWED, 20).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43603_).bonus(Source.MOON, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43604_).bonus(Source.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43605_).bonus(Source.MOON, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43606_).bonus(Source.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43607_).bonus(Source.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43608_).bonus(Source.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43609_).bonus(Source.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43610_).bonus(Source.INFERNAL, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43611_).bonus(Source.INFERNAL, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43612_).bonus(Source.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43613_).bonus(Source.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43614_).bonus(Source.SKY, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43615_).bonus(Source.SKY, 1).bonus(Source.VOID, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43616_).bonus(Source.SKY, 2).bonus(Source.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43617_).bonus(Source.SKY, 2).bonus(Source.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43618_).bonus(Source.SEA, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43619_).bonus(Source.SEA, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43620_).bonus(Source.SEA, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43621_).bonus(Source.SEA, 1).bonus(Source.SKY, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43622_).bonus(Source.SEA, 2).bonus(Source.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43623_).bonus(Source.SUN, 1).bonus(Source.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43581_).bonus(Source.SUN, 2).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43582_).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43583_).bonus(Source.BLOOD, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43584_).bonus(Source.EARTH, 1).bonus(Source.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43585_).bonus(Source.EARTH, 2).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43586_).bonus(Source.EARTH, 2).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43587_).bonus(Source.SUN, 1).bonus(Source.BLOOD, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43588_).bonus(Source.SUN, 2).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43589_).bonus(Source.SUN, 2).bonus(Source.BLOOD, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43590_).bonus(Source.EARTH, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43591_).bonus(Source.EARTH, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43592_).bonus(Source.EARTH, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43593_).bonus(Source.EARTH, 1).bonus(Source.VOID, 1).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43594_).bonus(Source.EARTH, 2).bonus(Source.VOID, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43595_).bonus(Source.MOON, 5).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43596_).bonus(Source.SKY, 2).build(consumer);
        PotionBonusAffinityBuilder.potionBonusAffinity(Potions.f_43597_).bonus(Source.SKY, 5).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44965_).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44966_).multiplier(Source.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44967_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44968_).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44969_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44970_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44971_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44972_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44973_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44974_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44975_).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44977_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44978_).multiplier(Source.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44979_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44980_).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44981_).multiplier(Source.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44982_).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44983_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44984_).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44985_).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44986_).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44987_).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44988_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44989_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44990_).multiplier(Source.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44952_).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44953_).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44954_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44955_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44956_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44957_).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44958_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44959_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44960_).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44961_).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44962_).multiplier(Source.SUN).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity(Enchantments.f_44963_).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.LIFESTEAL.get()).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.ENDERLOCK.get()).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.JUDGMENT.get()).multiplier(Source.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.ENDERPORT.get()).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.REGROWTH.get()).multiplier(Source.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.AEGIS.get()).multiplier(Source.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.MANA_EFFICIENCY.get()).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.SPELL_POWER.get()).multiplier(Source.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.TREASURE.get()).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.BLUDGEONING.get()).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.REVERBERATION.get()).multiplier(Source.EARTH).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.BOUNTY.get()).multiplier(Source.SEA).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.DISINTEGRATION.get()).multiplier(Source.SKY).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.VERDANT.get()).multiplier(Source.SUN).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.LUCKY_STRIKE.get()).multiplier(Source.MOON).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.RENDING.get()).multiplier(Source.BLOOD).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.SOULPIERCING.get()).multiplier(Source.INFERNAL).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.ESSENCE_THIEF.get()).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.BULWARK.get()).multiplier(Source.HALLOWED).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.MAGICK_PROTECTION.get()).multiplier(Source.VOID).build(consumer);
        EnchantmentBonusAffinityBuilder.enchantmentBonusAffinity((Enchantment)EnchantmentsPM.GUILLOTINE.get()).multiplier(Source.BLOOD).build(consumer);
    }

    public String m_6055_() {
        return "Primal Magick Affinities";
    }
}

