/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.atlas;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.renderers.itemstack.HallowsteelShieldISTER;
import com.verdantartifice.primalmagick.client.renderers.itemstack.HexiumShieldISTER;
import com.verdantartifice.primalmagick.client.renderers.itemstack.PrimaliteShieldISTER;
import com.verdantartifice.primalmagick.client.renderers.tile.ManaFontTER;
import com.verdantartifice.primalmagick.client.renderers.tile.RitualBellTER;
import com.verdantartifice.primalmagick.client.renderers.tile.SpellcraftingAltarTER;
import com.verdantartifice.primalmagick.common.items.tools.SacredShieldItem;
import com.verdantartifice.primalmagick.common.menus.AbstractRunescribingAltarMenu;
import com.verdantartifice.primalmagick.common.menus.HoneyExtractorMenu;
import com.verdantartifice.primalmagick.common.menus.InfernalFurnaceMenu;
import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.menus.RunecarvingTableMenu;
import com.verdantartifice.primalmagick.common.menus.WandAssemblyTableMenu;
import com.verdantartifice.primalmagick.common.menus.slots.WandSlot;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SpriteSourceProvider;
import org.slf4j.Logger;

public class SpriteSourceProviderPM
extends SpriteSourceProvider {
    protected static final ResourceLocation ARMOR_TRIMS_ATLAS = new ResourceLocation("armor_trims");
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Set<ResourceLocation> trackedSingles = new HashSet<ResourceLocation>();

    public SpriteSourceProviderPM(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, helper, "primalmagick");
    }

    protected void addSingle(SpriteSourceProvider.SourceList atlas, ResourceLocation loc) {
        if (this.trackedSingles.add(loc)) {
            atlas.addSource((SpriteSource)new SingleFile(loc, Optional.empty()));
        } else {
            LOGGER.warn("Attempted to register duplicate single texture {} to atlas", (Object)loc.toString());
        }
    }

    protected void addSources() {
        SpriteSourceProvider.SourceList blockAtlas = this.atlas(BLOCKS_ATLAS);
        SpriteSourceProvider.SourceList armorTrimsAtlas = this.atlas(ARMOR_TRIMS_ATLAS);
        this.addSingle(blockAtlas, WandAssemblyTableMenu.CORE_SLOT_TEXTURE);
        this.addSingle(blockAtlas, WandAssemblyTableMenu.CAP_SLOT_TEXTURE);
        this.addSingle(blockAtlas, WandAssemblyTableMenu.GEM_SLOT_TEXTURE);
        this.addSingle(blockAtlas, WandSlot.TEXTURE);
        this.addSingle(blockAtlas, ResearchTableMenu.PAPER_SLOT_TEXTURE);
        this.addSingle(blockAtlas, ResearchTableMenu.PENCIL_SLOT_TEXTURE);
        this.addSingle(blockAtlas, AbstractRunescribingAltarMenu.RUNE_SLOT_TEXTURE);
        this.addSingle(blockAtlas, RunecarvingTableMenu.BASE_SLOT_TEXTURE);
        this.addSingle(blockAtlas, RunecarvingTableMenu.ETCHING_SLOT_TEXTURE);
        this.addSingle(blockAtlas, HoneyExtractorMenu.HONEYCOMB_SLOT_TEXTURE);
        this.addSingle(blockAtlas, HoneyExtractorMenu.BOTTLE_SLOT_TEXTURE);
        this.addSingle(blockAtlas, InfernalFurnaceMenu.IGNYX_SLOT_TEXTURE);
        this.addSingle(blockAtlas, ManaFontTER.TEXTURE);
        this.addSingle(blockAtlas, RitualBellTER.TEXTURE);
        this.addSingle(blockAtlas, SpellcraftingAltarTER.RING_TEXTURE);
        this.addSingle(blockAtlas, PrimaliteShieldISTER.TEXTURE_SHIELD_BASE);
        this.addSingle(blockAtlas, PrimaliteShieldISTER.TEXTURE_SHIELD_NO_PATTERN);
        this.addSingle(blockAtlas, HexiumShieldISTER.TEXTURE_SHIELD_BASE);
        this.addSingle(blockAtlas, HexiumShieldISTER.TEXTURE_SHIELD_NO_PATTERN);
        this.addSingle(blockAtlas, HallowsteelShieldISTER.TEXTURE_SHIELD_BASE);
        this.addSingle(blockAtlas, HallowsteelShieldISTER.TEXTURE_SHIELD_NO_PATTERN);
        this.addSingle(blockAtlas, SacredShieldItem.TEXTURE);
        this.addSingle(blockAtlas, Source.getUnknownAtlasLocation());
        for (Source source : Source.SORTED_SOURCES) {
            this.addSingle(blockAtlas, source.getAtlasLocation());
        }
        blockAtlas.addSource((SpriteSource)new PalettedPermutations(List.of(PrimalMagick.resource("trims/items/robe_chest_trim"), PrimalMagick.resource("trims/items/robe_feet_trim"), PrimalMagick.resource("trims/items/robe_head_trim"), PrimalMagick.resource("trims/items/robe_legs_trim")), new ResourceLocation("trims/color_palettes/trim_palette"), (Map)ImmutableMap.builder().put((Object)"quartz", (Object)new ResourceLocation("trims/color_palettes/quartz")).put((Object)"iron", (Object)new ResourceLocation("trims/color_palettes/iron")).put((Object)"gold", (Object)new ResourceLocation("trims/color_palettes/gold")).put((Object)"diamond", (Object)new ResourceLocation("trims/color_palettes/diamond")).put((Object)"netherite", (Object)new ResourceLocation("trims/color_palettes/netherite")).put((Object)"redstone", (Object)new ResourceLocation("trims/color_palettes/redstone")).put((Object)"copper", (Object)new ResourceLocation("trims/color_palettes/copper")).put((Object)"emerald", (Object)new ResourceLocation("trims/color_palettes/emerald")).put((Object)"lapis", (Object)new ResourceLocation("trims/color_palettes/lapis")).put((Object)"amethyst", (Object)new ResourceLocation("trims/color_palettes/amethyst")).build()));
        armorTrimsAtlas.addSource((SpriteSource)new PalettedPermutations(List.of(PrimalMagick.resource("trims/models/armor/runic"), PrimalMagick.resource("trims/models/armor/runic_leggings")), new ResourceLocation("trims/color_palettes/trim_palette"), (Map)ImmutableMap.builder().put((Object)"rune_earth", (Object)new ResourceLocation("trims/color_palettes/emerald")).put((Object)"rune_sea", (Object)new ResourceLocation("trims/color_palettes/lapis")).put((Object)"rune_sky", (Object)new ResourceLocation("trims/color_palettes/diamond")).put((Object)"rune_sun", (Object)new ResourceLocation("trims/color_palettes/gold")).put((Object)"rune_moon", (Object)new ResourceLocation("trims/color_palettes/iron")).put((Object)"rune_blood", (Object)new ResourceLocation("trims/color_palettes/redstone")).put((Object)"rune_infernal", (Object)new ResourceLocation("trims/color_palettes/copper")).put((Object)"rune_void", (Object)new ResourceLocation("trims/color_palettes/amethyst")).put((Object)"rune_hallowed", (Object)new ResourceLocation("trims/color_palettes/quartz")).build()));
    }
}

