/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.blocks;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.datagen.blocks.BlockModelProviderPM;
import com.verdantartifice.primalmagick.datagen.blocks.SpecialBlockStateBuilder;
import com.verdantartifice.primalmagick.datagen.items.ItemModelProviderPM;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AbstractSpecialBlockStateProvider
implements DataProvider {
    protected final Map<ResourceLocation, IGeneratedBlockState> registeredBlocks = new LinkedHashMap<ResourceLocation, IGeneratedBlockState>();
    private final PackOutput output;
    protected final String modid;
    private final BlockModelProviderPM blockModels;
    private final ItemModelProviderPM itemModels;
    protected final ExistingFileHelper existingFileHelper;

    public AbstractSpecialBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        this.output = output;
        this.modid = modid;
        this.existingFileHelper = exFileHelper;
        this.blockModels = new BlockModelProviderPM(output, modid, exFileHelper){

            public CompletableFuture<?> m_213708_(CachedOutput cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }

            protected void registerModels() {
            }
        };
        this.itemModels = new ItemModelProviderPM(output, CompletableFuture.completedFuture(null), this.blockModels.existingFileHelper){

            @Override
            protected void registerModels() {
            }

            @Override
            public CompletableFuture<?> m_213708_(CachedOutput cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }
        };
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.models().clear();
        this.itemModels().clear();
        this.registeredBlocks.clear();
        this.registerStatesAndModels();
        CompletableFuture[] futures = new CompletableFuture[2 + this.registeredBlocks.size()];
        int i = 0;
        futures[i++] = this.models().generateAll(cache);
        futures[i++] = this.itemModels().generateAll(cache);
        for (Map.Entry<ResourceLocation, IGeneratedBlockState> entry : this.registeredBlocks.entrySet()) {
            futures[i++] = this.saveBlockState(cache, entry.getValue().toJson(), entry.getKey());
        }
        return CompletableFuture.allOf(futures);
    }

    protected abstract void registerStatesAndModels();

    public BlockModelProviderPM models() {
        return this.blockModels;
    }

    public ItemModelProviderPM itemModels() {
        return this.itemModels;
    }

    public SpecialBlockStateBuilder getSpecialBuilder(ResourceLocation loc) {
        if (this.registeredBlocks.containsKey(loc)) {
            IGeneratedBlockState old = this.registeredBlocks.get(loc);
            Preconditions.checkState((boolean)(old instanceof SpecialBlockStateBuilder));
            return (SpecialBlockStateBuilder)old;
        }
        SpecialBlockStateBuilder ret = new SpecialBlockStateBuilder(loc);
        this.registeredBlocks.put(loc, ret);
        return ret;
    }

    private CompletableFuture<?> saveBlockState(CachedOutput cache, JsonObject stateJson, ResourceLocation owner) {
        Preconditions.checkNotNull((Object)owner);
        Path outputPath = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(owner.m_135827_()).resolve("blockstates").resolve(owner.m_135815_() + ".json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)stateJson, (Path)outputPath);
    }
}

