/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.blocks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.crafting.AbstractCalcinatorBlock;
import com.verdantartifice.primalmagick.common.blocks.crafting.ConcocterBlock;
import com.verdantartifice.primalmagick.common.blocks.crafting.RunescribingAltarBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.EssenceCaskBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.SanguineCrucibleBlock;
import com.verdantartifice.primalmagick.common.blocks.devices.SunlampBlock;
import com.verdantartifice.primalmagick.common.blocks.golems.AbstractEnchantedGolemControllerBlock;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.blocks.misc.PillarBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.BloodletterBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.IncenseBrazierBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.RitualCandleBlock;
import com.verdantartifice.primalmagick.common.blocks.rituals.SoulAnvilBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLeavesBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLogBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingPillarBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingSlabBlock;
import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingStairsBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateProviderPM
extends BlockStateProvider {
    protected static final ResourceLocation SOLID = new ResourceLocation("solid");
    protected static final ResourceLocation CUTOUT = new ResourceLocation("cutout");
    protected static final ResourceLocation CUTOUT_MIPPED = new ResourceLocation("cutout_mipped");
    protected static final ResourceLocation TRANSLUCENT = new ResourceLocation("translucent");

    public BlockStateProviderPM(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "primalmagick", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_RAW.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_SLAB.get(), (Block)BlocksPM.MARBLE_RAW.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_RAW.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_RAW.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_BRICKS.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_BRICK_SLAB.get(), (Block)BlocksPM.MARBLE_BRICKS.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_BRICK_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_BRICKS.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_BRICK_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_BRICKS.get()));
        this.pillarBlockWithItem((PillarBlock)((Object)BlocksPM.MARBLE_PILLAR.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_CHISELED.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.MARBLE_RUNED.get(), this.blockTexture((Block)BlocksPM.MARBLE_RAW.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_TILES.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_ENCHANTED.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_ENCHANTED_SLAB.get(), (Block)BlocksPM.MARBLE_ENCHANTED.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_ENCHANTED_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_ENCHANTED_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_ENCHANTED_BRICKS.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get(), (Block)BlocksPM.MARBLE_ENCHANTED_BRICKS.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED_BRICKS.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED_BRICKS.get()));
        this.pillarBlockWithItem((PillarBlock)((Object)BlocksPM.MARBLE_ENCHANTED_PILLAR.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_ENCHANTED_CHISELED.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.MARBLE_ENCHANTED_RUNED.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_SMOKED.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_SMOKED_SLAB.get(), (Block)BlocksPM.MARBLE_SMOKED.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_SMOKED_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_SMOKED_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_SMOKED_BRICKS.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get(), (Block)BlocksPM.MARBLE_SMOKED_BRICKS.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED_BRICKS.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_SMOKED_BRICK_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED_BRICKS.get()));
        this.pillarBlockWithItem((PillarBlock)((Object)BlocksPM.MARBLE_SMOKED_PILLAR.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_SMOKED_CHISELED.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.MARBLE_SMOKED_RUNED.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_HALLOWED.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_HALLOWED_SLAB.get(), (Block)BlocksPM.MARBLE_HALLOWED.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_HALLOWED_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_HALLOWED_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_HALLOWED_BRICKS.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get(), (Block)BlocksPM.MARBLE_HALLOWED_BRICKS.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED_BRICKS.get()));
        this.wallBlockWithItem((WallBlock)BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED_BRICKS.get()));
        this.pillarBlockWithItem((PillarBlock)((Object)BlocksPM.MARBLE_HALLOWED_PILLAR.get()));
        this.simpleCubeBlockWithItem((Block)BlocksPM.MARBLE_HALLOWED_CHISELED.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.MARBLE_HALLOWED_RUNED.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED.get()));
        this.phasingLogBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.SUNWOOD_LOG.get()));
        this.phasingLogBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.STRIPPED_SUNWOOD_LOG.get()));
        this.phasingWoodBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.SUNWOOD_WOOD.get()), this.blockTexture((Block)BlocksPM.SUNWOOD_LOG.get()));
        this.phasingWoodBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.STRIPPED_SUNWOOD_WOOD.get()), this.blockTexture((Block)BlocksPM.STRIPPED_SUNWOOD_LOG.get()));
        this.phasingLeavesBlockWithItem((AbstractPhasingLeavesBlock)((Object)BlocksPM.SUNWOOD_LEAVES.get()));
        this.saplingBlockWithItem((Block)BlocksPM.SUNWOOD_SAPLING.get());
        this.phasingCubeBlockWithItem((AbstractPhasingBlock)((Object)BlocksPM.SUNWOOD_PLANKS.get()));
        this.phasingSlabBlockWithItem((AbstractPhasingSlabBlock)((Object)BlocksPM.SUNWOOD_SLAB.get()), (AbstractPhasingBlock)((Object)BlocksPM.SUNWOOD_PLANKS.get()));
        this.phasingStairsBlockWithItem((AbstractPhasingStairsBlock)((Object)BlocksPM.SUNWOOD_STAIRS.get()), this.blockTexture((Block)BlocksPM.SUNWOOD_PLANKS.get()));
        this.phasingPillarBlockWithItem((AbstractPhasingPillarBlock)((Object)BlocksPM.SUNWOOD_PILLAR.get()));
        this.phasingLogBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.MOONWOOD_LOG.get()));
        this.phasingLogBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.STRIPPED_MOONWOOD_LOG.get()));
        this.phasingWoodBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.MOONWOOD_WOOD.get()), this.blockTexture((Block)BlocksPM.MOONWOOD_LOG.get()));
        this.phasingWoodBlockWithItem((AbstractPhasingLogBlock)((Object)BlocksPM.STRIPPED_MOONWOOD_WOOD.get()), this.blockTexture((Block)BlocksPM.STRIPPED_MOONWOOD_LOG.get()));
        this.phasingLeavesBlockWithItem((AbstractPhasingLeavesBlock)((Object)BlocksPM.MOONWOOD_LEAVES.get()));
        this.saplingBlockWithItem((Block)BlocksPM.MOONWOOD_SAPLING.get());
        this.phasingCubeBlockWithItem((AbstractPhasingBlock)((Object)BlocksPM.MOONWOOD_PLANKS.get()));
        this.phasingSlabBlockWithItem((AbstractPhasingSlabBlock)((Object)BlocksPM.MOONWOOD_SLAB.get()), (AbstractPhasingBlock)((Object)BlocksPM.MOONWOOD_PLANKS.get()));
        this.phasingStairsBlockWithItem((AbstractPhasingStairsBlock)((Object)BlocksPM.MOONWOOD_STAIRS.get()), this.blockTexture((Block)BlocksPM.MOONWOOD_PLANKS.get()));
        this.phasingPillarBlockWithItem((AbstractPhasingPillarBlock)((Object)BlocksPM.MOONWOOD_PILLAR.get()));
        this.logBlockWithItem((RotatedPillarBlock)BlocksPM.HALLOWOOD_LOG.get());
        this.logBlockWithItem((RotatedPillarBlock)BlocksPM.STRIPPED_HALLOWOOD_LOG.get());
        this.woodBlockWithItem((RotatedPillarBlock)BlocksPM.HALLOWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.HALLOWOOD_LOG.get()));
        this.woodBlockWithItem((RotatedPillarBlock)BlocksPM.STRIPPED_HALLOWOOD_WOOD.get(), this.blockTexture((Block)BlocksPM.STRIPPED_HALLOWOOD_LOG.get()));
        this.leavesBlockWithItem((LeavesBlock)BlocksPM.HALLOWOOD_LEAVES.get());
        this.saplingBlockWithItem((Block)BlocksPM.HALLOWOOD_SAPLING.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.HALLOWOOD_PLANKS.get());
        this.slabBlockWithItem((SlabBlock)BlocksPM.HALLOWOOD_SLAB.get(), (Block)BlocksPM.HALLOWOOD_PLANKS.get());
        this.stairsBlockWithItem((StairBlock)BlocksPM.HALLOWOOD_STAIRS.get(), this.blockTexture((Block)BlocksPM.HALLOWOOD_PLANKS.get()));
        this.pillarBlockWithItem((PillarBlock)((Object)BlocksPM.HALLOWOOD_PILLAR.get()));
        this.cubeColumnBlockWithItem((Block)BlocksPM.HYDROMELON.get());
        this.stemBlock((Block)BlocksPM.HYRDOMELON_STEM.get());
        this.attachedStemBlock((Block)BlocksPM.ATTACHED_HYDROMELON_STEM.get(), this.blockTexture((Block)BlocksPM.HYRDOMELON_STEM.get()));
        this.tallCrossBlockWithItem((Block)BlocksPM.BLOOD_ROSE.get());
        this.tallExistingBlockWithItem((Block)BlocksPM.EMBERFLOWER.get(), this.blockTexture((Block)BlocksPM.EMBERFLOWER.get()).m_266382_("_front"));
        this.simpleCubeBlockWithItem((Block)BlocksPM.INFUSED_STONE_EARTH.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.INFUSED_STONE_SEA.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.INFUSED_STONE_SKY.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.INFUSED_STONE_SUN.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.INFUSED_STONE_MOON.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SYNTHETIC_AMETHYST_CLUSTER.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.LARGE_SYNTHETIC_AMETHYST_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.MEDIUM_SYNTHETIC_AMETHYST_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SMALL_SYNTHETIC_AMETHYST_BUD.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.DAMAGED_BUDDING_AMETHYST_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.CHIPPED_BUDDING_AMETHYST_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.FLAWED_BUDDING_AMETHYST_BLOCK.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SYNTHETIC_DIAMOND_CLUSTER.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.LARGE_SYNTHETIC_DIAMOND_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.MEDIUM_SYNTHETIC_DIAMOND_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SMALL_SYNTHETIC_DIAMOND_BUD.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.DAMAGED_BUDDING_DIAMOND_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.CHIPPED_BUDDING_DIAMOND_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.FLAWED_BUDDING_DIAMOND_BLOCK.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SYNTHETIC_EMERALD_CLUSTER.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.LARGE_SYNTHETIC_EMERALD_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.MEDIUM_SYNTHETIC_EMERALD_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SMALL_SYNTHETIC_EMERALD_BUD.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.DAMAGED_BUDDING_EMERALD_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.CHIPPED_BUDDING_EMERALD_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.FLAWED_BUDDING_EMERALD_BLOCK.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SYNTHETIC_QUARTZ_CLUSTER.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.LARGE_SYNTHETIC_QUARTZ_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.MEDIUM_SYNTHETIC_QUARTZ_BUD.get());
        this.directionalCrossBlockWithItem((Block)BlocksPM.SMALL_SYNTHETIC_QUARTZ_BUD.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.DAMAGED_BUDDING_QUARTZ_BLOCK.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.CHIPPED_BUDDING_QUARTZ_BLOCK.get());
        this.cubeColumnBlockWithItem((Block)BlocksPM.FLAWED_BUDDING_QUARTZ_BLOCK.get());
        RitualCandleBlock.getAllCandles().forEach(this::ritualCandleBlockWithItem);
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.BASIC).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture((Block)BlocksPM.MARBLE_RAW.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.ENCHANTED).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.FORBIDDEN).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture((Block)BlocksPM.MARBLE_SMOKED.get())));
        AbstractManaFontBlock.getAllManaFontsForTier(DeviceTier.HEAVENLY).forEach(block -> this.manaFontBlockWithItem((AbstractManaFontBlock)block, this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED.get())));
        this.simpleExistingBlockWithItem((Block)BlocksPM.ARCANE_WORKBENCH.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.WAND_ASSEMBLY_TABLE.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.WOOD_TABLE.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.ANALYSIS_TABLE.get());
        this.calcinatorBlockWithItem((AbstractCalcinatorBlock)((Object)BlocksPM.ESSENCE_FURNACE.get()), state -> this.models().getExistingFile(PrimalMagick.resource("block/essence_furnace").m_266382_((Boolean)state.m_61143_((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : "")));
        this.calcinatorBlockWithItem((AbstractCalcinatorBlock)((Object)BlocksPM.CALCINATOR_BASIC.get()));
        this.calcinatorBlockWithItem((AbstractCalcinatorBlock)((Object)BlocksPM.CALCINATOR_ENCHANTED.get()));
        this.calcinatorBlockWithItem((AbstractCalcinatorBlock)((Object)BlocksPM.CALCINATOR_FORBIDDEN.get()));
        this.calcinatorBlockWithItem((AbstractCalcinatorBlock)((Object)BlocksPM.CALCINATOR_HEAVENLY.get()));
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.WAND_INSCRIPTION_TABLE.get());
        this.spellcraftingAltarBlockWithItem();
        this.simpleExistingBlockWithItem((Block)BlocksPM.WAND_CHARGER.get());
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.RESEARCH_TABLE.get());
        this.sunlampBlockWithItem((SunlampBlock)((Object)BlocksPM.SUNLAMP.get()));
        this.sunlampBlockWithItem((SunlampBlock)((Object)BlocksPM.SPIRIT_LANTERN.get()));
        this.simpleExistingBlockWithItem((Block)BlocksPM.RITUAL_ALTAR.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.OFFERING_PEDESTAL.get());
        this.incenseBrazierBlockWithItem();
        this.horizontalExistingBlockWithItem((Block)BlocksPM.RITUAL_LECTERN.get());
        this.ritualBellBlockWithItem();
        this.bloodletterBlockWithItem();
        this.horizontalBlockWithItem((Block)BlocksPM.SOUL_ANVIL.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.SOUL_ANVIL.get()).m_266382_((Boolean)state.m_61143_((Property)SoulAnvilBlock.DIRTY) != false ? "_dirty" : "")));
        this.runescribingAltarBlockWithItem((RunescribingAltarBlock)BlocksPM.RUNESCRIBING_ALTAR_BASIC.get(), this.blockTexture((Block)BlocksPM.MARBLE_RAW.get()));
        this.runescribingAltarBlockWithItem((RunescribingAltarBlock)BlocksPM.RUNESCRIBING_ALTAR_ENCHANTED.get(), this.blockTexture((Block)BlocksPM.MARBLE_ENCHANTED.get()));
        this.runescribingAltarBlockWithItem((RunescribingAltarBlock)BlocksPM.RUNESCRIBING_ALTAR_FORBIDDEN.get(), this.blockTexture((Block)BlocksPM.MARBLE_SMOKED.get()));
        this.runescribingAltarBlockWithItem((RunescribingAltarBlock)BlocksPM.RUNESCRIBING_ALTAR_HEAVENLY.get(), this.blockTexture((Block)BlocksPM.MARBLE_HALLOWED.get()));
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem((Block)BlocksPM.RUNECARVING_TABLE.get());
        this.horizontalFaceExistingBlockWithItem((Block)BlocksPM.RUNIC_GRINDSTONE.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.HONEY_EXTRACTOR.get());
        this.golemControllerBlockWithItem((AbstractEnchantedGolemControllerBlock)BlocksPM.PRIMALITE_GOLEM_CONTROLLER.get(), this.blockTexture((Block)BlocksPM.PRIMALITE_BLOCK.get()));
        this.golemControllerBlockWithItem((AbstractEnchantedGolemControllerBlock)BlocksPM.HEXIUM_GOLEM_CONTROLLER.get(), this.blockTexture((Block)BlocksPM.HEXIUM_BLOCK.get()));
        this.golemControllerBlockWithItem((AbstractEnchantedGolemControllerBlock)BlocksPM.HALLOWSTEEL_GOLEM_CONTROLLER.get(), this.blockTexture((Block)BlocksPM.HALLOWSTEEL_BLOCK.get()));
        this.horizontalBlockWithItem((Block)BlocksPM.SANGUINE_CRUCIBLE.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.SANGUINE_CRUCIBLE.get()).m_266382_((Boolean)state.m_61143_((Property)SanguineCrucibleBlock.LIT) != false ? "_lit" : "")));
        this.horizontalBlockWithItem((Block)BlocksPM.CONCOCTER.get(), (BlockState state) -> this.models().getExistingFile(this.defaultModel((Block)BlocksPM.CONCOCTER.get()).m_266382_((Boolean)state.m_61143_((Property)ConcocterBlock.HAS_BOTTLE) != false ? "_bottle" : "")));
        this.horizontalExistingBlockWithItem((Block)BlocksPM.CELESTIAL_HARP.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.ENTROPY_SINK.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.AUTO_CHARGER.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.ESSENCE_TRANSMUTER.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.DISSOLUTION_CHAMBER.get());
        this.directionalExistingBlockWithItem((Block)BlocksPM.ZEPHYR_ENGINE.get());
        this.directionalExistingBlockWithItem((Block)BlocksPM.VOID_TURBINE.get());
        this.essenceCaskBlockWithItem((EssenceCaskBlock)BlocksPM.ESSENCE_CASK_ENCHANTED.get());
        this.essenceCaskBlockWithItem((EssenceCaskBlock)BlocksPM.ESSENCE_CASK_FORBIDDEN.get());
        this.essenceCaskBlockWithItem((EssenceCaskBlock)BlocksPM.ESSENCE_CASK_HEAVENLY.get());
        this.horizontalExistingBlockWithItem((Block)BlocksPM.WAND_GLAMOUR_TABLE.get());
        this.infernalFurnaceBlockWithItem();
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_NEXUS.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_SINGULARITY.get());
        this.simpleExistingBlockWithItem((Block)BlocksPM.MANA_SINGULARITY_CREATIVE.get());
        this.emptyBlock((Block)BlocksPM.CONSECRATION_FIELD.get());
        this.emptyBlock((Block)BlocksPM.GLOW_FIELD.get());
        this.emptyBlock((Block)BlocksPM.SOUL_GLOW_FIELD.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.ROCK_SALT_ORE.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.QUARTZ_ORE.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.PRIMALITE_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.HEXIUM_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.HALLOWSTEEL_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.IGNYX_BLOCK.get());
        this.simpleCubeBlockWithItem((Block)BlocksPM.SALT_BLOCK.get());
        this.crossBlockWithItem((Block)BlocksPM.TREEFOLK_SPROUT.get(), this.key((Item)ItemsPM.TREEFOLK_SEED.get()));
        this.horizontalExistingBlockWithBasicItem((Block)BlocksPM.ENDERWARD.get());
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private ResourceLocation key(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation defaultModel(Block block) {
        return this.key(block).m_246208_("block/");
    }

    private void emptyBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(PrimalMagick.resource("block/empty")));
    }

    private void simpleCubeBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    private void simpleExistingBlockWithItem(Block block) {
        this.simpleExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void simpleExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void slabBlockWithItem(SlabBlock block, Block doubleSlabBlock) {
        this.slabBlockWithItem(block, doubleSlabBlock, this.blockTexture(doubleSlabBlock));
    }

    private void slabBlockWithItem(SlabBlock block, Block doubleSlabBlock, ResourceLocation texture) {
        String blockName = this.name((Block)block);
        ModelBuilder bottomModel = this.models().slab(blockName, texture, texture, texture);
        ModelBuilder topModel = this.models().slabTop(blockName + "_top", texture, texture, texture);
        this.slabBlock(block, (ModelFile)bottomModel, (ModelFile)topModel, (ModelFile)this.models().getExistingFile(this.key(doubleSlabBlock)));
        this.simpleBlockItem((Block)block, (ModelFile)bottomModel);
    }

    private void stairsBlockWithItem(StairBlock block, ResourceLocation texture) {
        String baseName = this.name((Block)block);
        ModelBuilder stairs = this.models().stairs(baseName, texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", texture, texture, texture);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)block, (ModelFile)stairs);
    }

    private void wallBlockWithItem(WallBlock block, ResourceLocation texture) {
        this.wallBlock(block, texture);
        ModelBuilder wallInv = this.models().wallInventory(this.name((Block)block) + "_inventory", texture);
        this.simpleBlockItem((Block)block, (ModelFile)wallInv);
    }

    private void cubeColumnBlockWithItem(Block block) {
        this.cubeColumnBlockWithItem(block, this.blockTexture(block).m_266382_("_side"), this.blockTexture(block).m_266382_("_end"));
    }

    private void cubeColumnBlockWithItem(Block block, ResourceLocation endTexture) {
        this.cubeColumnBlockWithItem(block, this.blockTexture(block), endTexture);
    }

    private void cubeColumnBlockWithItem(Block block, ResourceLocation sideTexture, ResourceLocation endTexture) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeColumn(this.name(block), sideTexture, endTexture));
    }

    private void pillarBlockWithItem(PillarBlock block) {
        this.pillarBlockWithItem(block, this.blockTexture(block));
    }

    private void pillarBlockWithItem(PillarBlock block, ResourceLocation texture) {
        this.pillarBlockWithItem(block, texture, texture.m_266382_("_inner"), texture.m_266382_("_top"), texture.m_266382_("_bottom"), texture.m_266382_("_base"));
    }

    private void pillarBlockWithItem(PillarBlock block, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation baseTexture) {
        ModelBuilder baseModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), PrimalMagick.resource("block/pillar"))).texture("side", sideTexture)).texture("inner", innerTexture);
        ModelBuilder topModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top", PrimalMagick.resource("block/pillar_top"))).texture("side", topTexture)).texture("inner", innerTexture)).texture("top", baseTexture);
        ModelBuilder bottomModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom", PrimalMagick.resource("block/pillar_bottom"))).texture("side", bottomTexture)).texture("inner", innerTexture)).texture("bottom", baseTexture);
        this.getVariantBuilder(block).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.BASE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)baseModel)}).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.TOP)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topModel)}).partialState().with(PillarBlock.PROPERTY_TYPE, (Comparable)((Object)PillarBlock.Type.BOTTOM)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomModel)});
        this.simpleBlockItem(block, (ModelFile)baseModel);
    }

    private void phasingLogBlockWithItem(AbstractPhasingLogBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation sideTexture = this.blockTexture((Block)block).m_266382_("_" + phaseName);
            ResourceLocation endTexture = this.blockTexture((Block)block).m_266382_("_top_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, sideTexture, endTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.axisBlockPhase(block, (ModelFile)model, (ModelFile)model, (TimePhase)((Object)phase));
        });
        String phaseName = TimePhase.FULL.m_7912_();
        ResourceLocation sideTexture = this.blockTexture((Block)block).m_266382_("_" + phaseName);
        ResourceLocation endTexture = this.blockTexture((Block)block).m_266382_("_top_" + phaseName);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, sideTexture, endTexture));
    }

    private void phasingWoodBlockWithItem(AbstractPhasingLogBlock block, ResourceLocation texture) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation phaseTexture = texture.m_266382_("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, phaseTexture, phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.axisBlockPhase(block, (ModelFile)model, (ModelFile)model, (TimePhase)((Object)phase));
        });
        String phaseName = TimePhase.FULL.m_7912_();
        ResourceLocation phaseTexture = texture.m_266382_("_" + phaseName);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().cubeColumn(this.name((Block)block) + "_" + phaseName, phaseTexture, phaseTexture));
    }

    private void axisBlockPhase(AbstractPhasingLogBlock block, ModelFile vertical, ModelFile horizontal, TimePhase phase) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile(vertical).addModel()).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile(horizontal).rotationX(90).addModel()).partialState().with(AbstractPhasingLogBlock.PHASE, (Comparable)((Object)phase)).with((Property)AbstractPhasingLogBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile(horizontal).rotationX(90).rotationY(90).addModel();
    }

    private void phasingLeavesBlockWithItem(AbstractPhasingLeavesBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation phaseTexture = this.blockTexture(block).m_266382_("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + phaseName, new ResourceLocation("block/leaves"))).texture("all", phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? CUTOUT : TRANSLUCENT);
            this.getVariantBuilder(block).partialState().with(AbstractPhasingLeavesBlock.PHASE, (Comparable)((Object)phase)).modelForState().modelFile((ModelFile)model).addModel();
        });
        String phaseName = TimePhase.FULL.m_7912_();
        ResourceLocation phaseTexture = this.blockTexture(block).m_266382_("_" + phaseName);
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + phaseName, new ResourceLocation("block/leaves"))).texture("all", phaseTexture));
    }

    private void saplingBlockWithItem(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType(CUTOUT));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture(block));
    }

    private void phasingCubeBlockWithItem(AbstractPhasingBlock block) {
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation phaseTexture = this.blockTexture(block).m_266382_("_" + phaseName);
            ModelBuilder model = ((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + phaseName, phaseTexture)).renderType(TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT);
            this.getVariantBuilder(block).partialState().with(AbstractPhasingBlock.PHASE, (Comparable)((Object)phase)).modelForState().modelFile((ModelFile)model).addModel();
        });
        String phaseName = TimePhase.FULL.m_7912_();
        ResourceLocation phaseTexture = this.blockTexture(block).m_266382_("_" + phaseName);
        this.simpleBlockItem(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block) + "_" + phaseName, phaseTexture)).renderType(SOLID));
    }

    private void phasingSlabBlockWithItem(AbstractPhasingSlabBlock block, AbstractPhasingBlock doubleSlabBlock) {
        String blockName = this.name((Block)block);
        ResourceLocation texture = this.blockTexture(doubleSlabBlock);
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation phaseTexture = texture.m_266382_("_" + phaseName);
            ResourceLocation renderType = TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT;
            ModelBuilder bottomModel = ((BlockModelBuilder)this.models().slab(blockName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType);
            ModelBuilder topModel = ((BlockModelBuilder)this.models().slabTop(blockName + "_top_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType);
            ModelFile.ExistingModelFile doubleModel = this.models().getExistingFile(this.key(doubleSlabBlock).m_266382_("_" + phaseName));
            this.getVariantBuilder((Block)block).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottomModel)}).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)topModel)}).partialState().with(AbstractPhasingSlabBlock.PHASE, (Comparable)((Object)phase)).with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleModel)});
        });
        String phaseName = TimePhase.FULL.m_7912_();
        ResourceLocation phaseTexture = texture.m_266382_("_" + phaseName);
        ModelBuilder bottomModel = this.models().slab(blockName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture);
        this.simpleBlockItem((Block)block, (ModelFile)bottomModel);
    }

    private void phasingStairsBlockWithItem(AbstractPhasingStairsBlock block, ResourceLocation texture) {
        String baseName = this.name((Block)block);
        HashMap baseModels = new HashMap();
        HashMap innerModels = new HashMap();
        HashMap outerModels = new HashMap();
        Stream.of(TimePhase.values()).forEach(phase -> {
            String phaseName = phase.m_7912_();
            ResourceLocation phaseTexture = texture.m_266382_("_" + phaseName);
            ResourceLocation renderType = TimePhase.FULL.equals(phase) ? SOLID : TRANSLUCENT;
            baseModels.put(phase, ((BlockModelBuilder)this.models().stairs(baseName + "_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
            innerModels.put(phase, ((BlockModelBuilder)this.models().stairsInner(baseName + "_inner_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
            outerModels.put(phase, ((BlockModelBuilder)this.models().stairsOuter(baseName + "_outer_" + phaseName, phaseTexture, phaseTexture, phaseTexture)).renderType(renderType));
        });
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            TimePhase phase = (TimePhase)((Object)((Object)state.m_61143_(AbstractPhasingStairsBlock.PHASE)));
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? (ModelFile)baseModels.get((Object)phase) : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? (ModelFile)innerModels.get((Object)phase) : (ModelFile)outerModels.get((Object)phase))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairBlock.f_56844_});
        this.simpleBlockItem((Block)block, (ModelFile)baseModels.get((Object)TimePhase.FULL));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block) {
        this.phasingPillarBlockWithItem(block, this.blockTexture(block));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block, ResourceLocation texture) {
        this.phasingPillarBlockWithItem(block, texture, texture.m_266382_("_inner"), texture.m_266382_("_top"), texture.m_266382_("_bottom"), texture.m_266382_("_base"));
    }

    private void phasingPillarBlockWithItem(AbstractPhasingPillarBlock block, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation baseTexture) {
        String baseName = this.name(block);
        HashBasedTable models = HashBasedTable.create();
        Stream.of(TimePhase.values()).forEach(arg_0 -> this.lambda$phasingPillarBlockWithItem$15((Table)models, baseName, sideTexture, innerTexture, topTexture, baseTexture, bottomTexture, arg_0));
        this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateProviderPM.lambda$phasingPillarBlockWithItem$16((Table)models, arg_0));
        this.simpleBlockItem(block, (ModelFile)models.get((Object)PillarBlock.Type.BASE, (Object)TimePhase.FULL));
    }

    private void logBlockWithItem(RotatedPillarBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        ModelBuilder model = this.models().cubeColumn(this.name((Block)block), texture, texture.m_266382_("_top"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void woodBlockWithItem(RotatedPillarBlock block, ResourceLocation texture) {
        ModelBuilder model = this.models().cubeColumn(this.name((Block)block), texture, texture);
        this.axisBlock(block, (ModelFile)model, (ModelFile)model);
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    private void leavesBlockWithItem(LeavesBlock block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), new ResourceLocation("block/leaves"))).texture("all", this.blockTexture((Block)block));
        this.simpleBlockWithItem((Block)block, (ModelFile)model);
    }

    private void ritualCandleBlockWithItem(RitualCandleBlock block) {
        this.simpleExistingBlockWithItem((Block)block, PrimalMagick.resource("block/ritual_candle"));
    }

    private void manaFontBlockWithItem(AbstractManaFontBlock block, ResourceLocation baseTexture) {
        this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), PrimalMagick.resource("block/template_mana_font"))).texture("base", baseTexture));
        this.itemModels().withExistingParent(this.name((Block)block), PrimalMagick.resource("item/template_mana_font"));
    }

    private void horizontalExistingBlockWithItem(Block block) {
        this.horizontalExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void horizontalBlockWithItem(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.m_49966_()));
    }

    private void horizontalExistingBlockWithBasicItem(Block block) {
        this.horizontalExistingBlockWithBasicItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithBasicItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithBasicItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithBasicItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        this.itemModels().basicItem(block.m_5456_());
    }

    private void horizontalExistingBlockWithRightHandAdjustmentsAndItem(Block block) {
        this.horizontalExistingBlockWithRightHandAdjustmentsAndItem(block, this.defaultModel(block));
    }

    private void horizontalExistingBlockWithRightHandAdjustmentsAndItem(Block block, ResourceLocation modelFile) {
        this.horizontalBlockWithRightHandAdjustmentsAndItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void horizontalBlockWithRightHandAdjustmentsAndItem(Block block, ModelFile model) {
        this.horizontalBlock(block, model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent(model)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 135.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void horizontalFaceExistingBlockWithItem(Block block) {
        this.horizontalFaceBlockWithItem(block, (ModelFile)this.models().getExistingFile(this.defaultModel(block)));
    }

    private void horizontalFaceBlockWithItem(Block block, ModelFile model) {
        this.horizontalFaceBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void directionalExistingBlockWithItem(Block block) {
        this.directionalExistingBlockWithItem(block, this.defaultModel(block));
    }

    private void directionalExistingBlockWithItem(Block block, ResourceLocation modelFile) {
        this.directionalBlockWithItem(block, (ModelFile)this.models().getExistingFile(modelFile));
    }

    private void directionalBlockWithItem(Block block, ModelFile model) {
        this.directionalBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    private void directionalBlockWithItem(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.m_49966_()));
    }

    private void calcinatorBlockWithItem(AbstractCalcinatorBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        this.calcinatorBlockWithItem(block, state -> this.models().orientableWithBottom(this.name((Block)block) + ((Boolean)state.m_61143_((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : ""), texture.m_266382_("_side"), texture.m_266382_("_front" + ((Boolean)state.m_61143_((Property)AbstractCalcinatorBlock.LIT) != false ? "_on" : "")), this.mcLoc("block/furnace_top"), texture.m_266382_("_top")));
    }

    private void calcinatorBlockWithItem(AbstractCalcinatorBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.horizontalBlock((Block)block, modelFunc);
        this.simpleBlockItem((Block)block, modelFunc.apply(block.m_49966_()));
    }

    private void infernalFurnaceBlockWithItem() {
        Block block = (Block)BlocksPM.INFERNAL_FURNACE.get();
        ResourceLocation texture = this.blockTexture(block);
        Function<BlockState, ModelFile> modelFunc = state -> this.models().orientableWithBottom(this.name(block) + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "_on" : ""), texture.m_266382_("_side"), texture.m_266382_("_front" + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "_on" : "")), texture.m_266382_("_top"), texture.m_266382_("_top"));
        this.horizontalBlock(block, modelFunc);
        this.simpleBlockItem(block, modelFunc.apply(block.m_49966_()));
    }

    private void spellcraftingAltarBlockWithItem() {
        Block block = (Block)BlocksPM.SPELLCRAFTING_ALTAR.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(PrimalMagick.resource("block/spellcrafting_altar"));
        this.horizontalBlock(block, (ModelFile)model);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end();
    }

    private void sunlampBlockWithItem(SunlampBlock block) {
        ResourceLocation modelLoc = this.defaultModel((Block)block);
        DirectionProperty prop = SunlampBlock.ATTACHMENT;
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_ground_base"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_ground_chain_stub"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_base"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_chain_stub"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_chain_full"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_arm"))).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_arm"))).rotationY(90).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_arm"))).rotationY(180).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_hanging_arm"))).rotationY(270).addModel()).condition((Property)prop, (Comparable[])new Direction[]{Direction.WEST}).end();
        this.itemModels().basicItem(block.m_5456_());
    }

    private void incenseBrazierBlockWithItem() {
        Block block = (Block)BlocksPM.INCENSE_BRAZIER.get();
        ResourceLocation modelLoc = this.defaultModel(block);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)IncenseBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc)).addModel()).partialState().with((Property)IncenseBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_lit"))).addModel();
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(modelLoc));
    }

    private void ritualBellBlockWithItem() {
        Block block = (Block)BlocksPM.RITUAL_BELL.get();
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.getRitualBellModel((BlockState)state)).rotationY(this.getRitualBellRotationY((BlockState)state)).build());
        this.itemModels().basicItem(block.m_5456_());
    }

    private ModelFile getRitualBellModel(BlockState state) {
        String suffix = switch ((BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_)) {
            case BellAttachType.FLOOR -> "_floor";
            case BellAttachType.CEILING -> "_ceiling";
            case BellAttachType.SINGLE_WALL -> "_wall";
            case BellAttachType.DOUBLE_WALL -> "_between_walls";
            default -> throw new IllegalArgumentException("Unknown bell attachment type");
        };
        return this.models().getExistingFile(this.defaultModel(state.m_60734_()).m_266382_(suffix));
    }

    private int getRitualBellRotationY(BlockState state) {
        int angleOffset = switch ((BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_)) {
            default -> throw new IncompatibleClassChangeError();
            case BellAttachType.FLOOR, BellAttachType.CEILING -> 180;
            case BellAttachType.SINGLE_WALL, BellAttachType.DOUBLE_WALL -> 90;
        };
        return ((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360;
    }

    private void bloodletterBlockWithItem() {
        Block block = (Block)BlocksPM.BLOODLETTER.get();
        ResourceLocation modelLoc = this.defaultModel(block);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BloodletterBlock.FILLED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc)).addModel()).partialState().with((Property)BloodletterBlock.FILLED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLoc.m_266382_("_full"))).addModel();
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(modelLoc));
    }

    private void runescribingAltarBlockWithItem(RunescribingAltarBlock block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), PrimalMagick.resource("block/runescribing_altar"))).texture("altar_bottom", texture)).texture("altar_side", this.blockTexture((Block)block).m_266382_("_side"));
        this.simpleBlockWithItem((Block)block, (ModelFile)model);
    }

    private void golemControllerBlockWithItem(AbstractEnchantedGolemControllerBlock<?> block, ResourceLocation topTexture) {
        ResourceLocation baseTexture = this.blockTexture(block);
        ModelBuilder model = this.models().orientable(this.name(block), baseTexture.m_266382_("_side"), baseTexture.m_266382_("_front"), topTexture);
        this.horizontalBlockWithItem(block, (ModelFile)model);
    }

    private void essenceCaskBlockWithItem(EssenceCaskBlock block) {
        ResourceLocation texture = this.blockTexture((Block)block);
        this.essenceCaskBlockWithItem(block, state -> this.models().cubeBottomTop(this.name((Block)block) + ((Boolean)state.m_61143_((Property)EssenceCaskBlock.OPEN) != false ? "_open" : ""), texture.m_266382_("_side"), texture.m_266382_("_bottom"), texture.m_266382_("_top" + ((Boolean)state.m_61143_((Property)EssenceCaskBlock.OPEN) != false ? "_open" : ""))));
    }

    private void essenceCaskBlockWithItem(EssenceCaskBlock block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalBlockWithItem((Block)block, modelFunc);
        this.simpleBlockItem((Block)block, modelFunc.apply(block.m_49966_()));
    }

    private ModelFile getCrossModel(Block block) {
        return ((BlockModelBuilder)this.models().cross(this.name(block), this.blockTexture(block))).renderType(CUTOUT);
    }

    private void crossBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.simpleBlock(block, this.getCrossModel(block));
        this.itemModels().basicItem(itemTexture);
    }

    private void stemBlock(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        StemBlock.f_57013_.m_6908_().forEach(stage -> builder.partialState().with((Property)StemBlock.f_57013_, (Comparable)stage).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_stage" + stage, new ResourceLocation("block/stem_growth" + stage))).texture("stem", this.blockTexture(block))).renderType(CUTOUT)).addModel());
    }

    private void attachedStemBlock(Block block, ResourceLocation lowerStemTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), new ResourceLocation("block/stem_fruit"))).texture("stem", lowerStemTexture)).texture("upperstem", this.blockTexture(block))).renderType(CUTOUT);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)AttachedStemBlock.f_48830_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)AttachedStemBlock.f_48830_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)AttachedStemBlock.f_48830_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)AttachedStemBlock.f_48830_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(180).addModel();
    }

    private void tallCrossBlockWithItem(Block block) {
        this.tallCrossBlockWithItem(block, this.blockTexture(block).m_266382_("_top"), this.blockTexture(block).m_266382_("_bottom"));
    }

    private void tallCrossBlockWithItem(Block block, ResourceLocation topTexture, ResourceLocation bottomTexture) {
        ModelBuilder topModel = ((BlockModelBuilder)this.models().cross(this.name(block) + "_top", topTexture)).renderType(CUTOUT);
        ModelBuilder bottomModel = ((BlockModelBuilder)this.models().cross(this.name(block) + "_bottom", bottomTexture)).renderType(CUTOUT);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottomModel).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.blockTexture(block).m_266382_("_top"));
    }

    private void tallExistingBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.tallExistingBlockWithItem(block, this.defaultModel(block).m_266382_("_top"), this.defaultModel(block).m_266382_("_bottom"), itemTexture);
    }

    private void tallExistingBlockWithItem(Block block, ResourceLocation topModel, ResourceLocation bottomModel, ResourceLocation itemTexture) {
        this.tallExistingBlockWithItem(block, (ModelFile)this.models().getExistingFile(topModel), (ModelFile)this.models().getExistingFile(bottomModel), itemTexture);
    }

    private void tallExistingBlockWithItem(Block block, ModelFile topModel, ModelFile bottomModel, ResourceLocation itemTexture) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile(topModel).addModel()).partialState().with((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile(bottomModel).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", itemTexture);
    }

    private void directionalCrossBlockWithItem(Block block) {
        this.directionalCrossBlockWithItem(block, this.blockTexture(block));
    }

    private void directionalCrossBlockWithItem(Block block, ResourceLocation itemTexture) {
        this.directionalBlock(block, this.getCrossModel(block));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", itemTexture);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$phasingPillarBlockWithItem$16(Table models, BlockState state) {
        PillarBlock.Type type = (PillarBlock.Type)((Object)state.m_61143_((Property)AbstractPhasingPillarBlock.PROPERTY_TYPE));
        TimePhase phase = (TimePhase)((Object)state.m_61143_(AbstractPhasingPillarBlock.PHASE));
        return ConfiguredModel.builder().modelFile((ModelFile)models.get((Object)type, (Object)phase)).build();
    }

    private /* synthetic */ void lambda$phasingPillarBlockWithItem$15(Table models, String baseName, ResourceLocation sideTexture, ResourceLocation innerTexture, ResourceLocation topTexture, ResourceLocation baseTexture, ResourceLocation bottomTexture, TimePhase phase) {
        String phaseName = phase.m_7912_();
        ResourceLocation renderType = TimePhase.FULL.equals((Object)phase) ? SOLID : TRANSLUCENT;
        models.put((Object)PillarBlock.Type.BASE, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_" + phaseName, PrimalMagick.resource("block/pillar"))).texture("side", sideTexture.m_266382_("_" + phaseName))).texture("inner", innerTexture.m_266382_("_" + phaseName))).renderType(renderType));
        models.put((Object)PillarBlock.Type.TOP, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_top_" + phaseName, PrimalMagick.resource("block/pillar_top"))).texture("side", topTexture.m_266382_("_" + phaseName))).texture("inner", innerTexture.m_266382_("_" + phaseName))).texture("top", baseTexture.m_266382_("_" + phaseName))).renderType(renderType));
        models.put((Object)PillarBlock.Type.BOTTOM, (Object)phase, (Object)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_bottom_" + phaseName, PrimalMagick.resource("block/pillar_bottom"))).texture("side", bottomTexture.m_266382_("_" + phaseName))).texture("inner", innerTexture.m_266382_("_" + phaseName))).texture("bottom", baseTexture.m_266382_("_" + phaseName))).renderType(renderType));
    }
}

