/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.blocks;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockState;

public class SpecialBlockStateBuilder
implements IGeneratedBlockState {
    private final ResourceLocation owner;
    private BlockStateProvider.ConfiguredModelList models = null;

    public SpecialBlockStateBuilder(ResourceLocation owner) {
        this.owner = owner;
    }

    public JsonObject toJson() {
        Preconditions.checkNotNull((Object)this.models, (String)"Blockstate for owner %s does not have a model specified", (Object)this.owner);
        JsonObject variants = new JsonObject();
        variants.add("", this.models.toJSON());
        JsonObject main = new JsonObject();
        main.add("variants", (JsonElement)variants);
        return main;
    }

    public SpecialBlockStateBuilder setModels(ConfiguredModel ... models) {
        Preconditions.checkArgument((this.models == null ? 1 : 0) != 0, (String)"Models have already been set in blockstate for owner %s", (Object)this.owner);
        Preconditions.checkArgument((models.length > 0 ? 1 : 0) != 0, (Object)"Cannot set models to empty array");
        this.models = new BlockStateProvider.ConfiguredModelList(models);
        return this;
    }
}

