/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.blocks;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.items.wands.StaffCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCapItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandGemItem;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import com.verdantartifice.primalmagick.datagen.blocks.AbstractSpecialBlockStateProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class WandComponentBlockStateProvider
extends AbstractSpecialBlockStateProvider {
    public WandComponentBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "primalmagick", exFileHelper);
    }

    public String m_6055_() {
        return "Wand Component Block States: " + this.modid;
    }

    @Override
    protected void registerStatesAndModels() {
        WandCoreItem.getAllCores().forEach(this::wandCoreWithItem);
        StaffCoreItem.getAllCores().forEach(this::staffCoreWithItem);
        WandCapItem.getAllCaps().forEach(this::wandCapWithItem);
        WandGemItem.getAllGems().forEach(this::wandGemWithItem);
    }

    private ResourceLocation itemTextureLoc(ResourceLocation key) {
        return key.m_246208_("item/");
    }

    private void wandCoreWithItem(WandCoreItem coreItem) {
        this.generatedComponentWithItem(coreItem, coreItem.getWandCore(), "wand_core", "core");
    }

    private void staffCoreWithItem(StaffCoreItem coreItem) {
        this.generatedComponentWithItem(coreItem, coreItem.getWandCore(), "staff_core", "core", "wand_core");
    }

    private void wandCapWithItem(WandCapItem capItem) {
        this.generatedComponentWithItem(capItem, capItem.getWandCap(), "wand_cap", "cap");
        this.generatedComponent(capItem.getWandCap(), "staff_cap", "cap", "wand_cap");
    }

    private void wandGemWithItem(WandGemItem gemItem) {
        this.existingComponentWithItem(gemItem, gemItem.getWandGem(), "wand_gem");
    }

    private void generatedComponentWithItem(Item item, IWandComponent component, String componentSuffix, String textureComponentName) {
        this.generatedComponentWithItem(item, component, componentSuffix, textureComponentName, componentSuffix);
    }

    private void generatedComponentWithItem(Item item, IWandComponent component, String modelComponentSuffix, String textureComponentName, String textureComponentSuffix) {
        this.generatedComponent(component, modelComponentSuffix, textureComponentName, textureComponentSuffix);
        this.itemModels().basicItem(item);
    }

    private void generatedComponent(IWandComponent component, String modelComponentSuffix, String textureComponentName, String textureComponentSuffix) {
        ResourceLocation modelParent = PrimalMagick.resource("item/" + modelComponentSuffix);
        ResourceLocation modelKey = PrimalMagick.resource(component.getTag() + "_" + modelComponentSuffix);
        ResourceLocation textureKey = PrimalMagick.resource(component.getTag() + "_" + textureComponentSuffix);
        String modelName = modelKey.m_135815_();
        ResourceLocation textureLoc = this.itemTextureLoc(textureKey);
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, modelParent)).texture(textureComponentName, textureLoc);
        this.getSpecialBuilder(modelKey).setModels(new ConfiguredModel((ModelFile)model));
    }

    private void existingComponentWithItem(Item item, IWandComponent component, String modelComponentSuffix) {
        ResourceLocation modelKey = PrimalMagick.resource(component.getTag() + "_" + modelComponentSuffix);
        String modelName = modelKey.m_135815_();
        ModelFile.ExistingModelFile model = new ModelFile.ExistingModelFile(PrimalMagick.resource("block/" + modelName), this.existingFileHelper);
        this.getSpecialBuilder(modelKey).setModels(new ConfiguredModel((ModelFile)model));
        this.itemModels().basicItem(item);
    }
}

