/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.books;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.verdantartifice.primalmagick.client.books.StyleGuide;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StyleGuideProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput packOutput;

    public StyleGuideProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        HashMap map = new HashMap();
        this.registerStyleGuides((langId, guide) -> {
            if (map.put(langId, guide) != null) {
                LOGGER.warn("Duplicate style guide in data generation: {}", (Object)langId.toString());
            }
        });
        map.entrySet().forEach(entry -> StyleGuide.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((StyleGuide)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(json -> futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)json, (Path)this.getPath(this.packOutput, (ResourceLocation)entry.getKey())))));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private Path getPath(PackOutput output, ResourceLocation entryLoc) {
        return output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(entryLoc.m_135827_()).resolve("style_guides").resolve(entryLoc.m_135815_() + ".json");
    }

    protected void registerStyleGuides(BiConsumer<ResourceLocation, StyleGuide> consumer) {
        StyleGuide.builder((BookLanguage)BookLanguagesPM.DEFAULT.get()).save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.GALACTIC.get()).save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.ILLAGER.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.EARTH.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.SEA.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.SKY.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.SUN.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.MOON.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.TRADE.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor()).m_178524_(Boolean.valueOf(true))).hoverText("tooltip.primalmagick.written_language.obfuscated_word").end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.FORBIDDEN.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor())).end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor())).end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor())).end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor()).m_178522_(Boolean.valueOf(true))).end().save(consumer);
        StyleGuide.builder((BookLanguage)BookLanguagesPM.HALLOWED.get()).entry(Source.EARTH.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.EARTH.getColor())).end().entry(Source.SEA.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SEA.getColor())).end().entry(Source.SKY.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SKY.getColor())).end().entry(Source.SUN.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.SUN.getColor())).end().entry(Source.MOON.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.MOON.getColor())).end().entry(Source.BLOOD.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.BLOOD.getColor())).end().entry(Source.INFERNAL.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.INFERNAL.getColor())).end().entry(Source.VOID.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.VOID.getColor())).end().entry(Source.HALLOWED.getNameTranslationKey()).setStyle(Style.f_131099_.m_178520_(Source.HALLOWED.getColor())).end().save(consumer);
    }

    public String m_6055_() {
        return "Primal Magick Style Guides";
    }
}

