/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.items;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelBuilderPM
extends ModelBuilder<ItemModelBuilderPM> {
    protected List<OverrideBuilder> overrides = new ArrayList<OverrideBuilder>();

    public ItemModelBuilderPM(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public ItemModelBuilderPM palattedTexture(String key, ResourceLocation baseTexture, String palatteSuffix) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)baseTexture, (Object)"Base texture must not be null");
        this.textures.put(key, baseTexture.m_266382_("_" + palatteSuffix).toString());
        return this;
    }

    public OverrideBuilder override() {
        OverrideBuilder ret = new OverrideBuilder();
        this.overrides.add(ret);
        return ret;
    }

    public JsonObject toJson() {
        JsonObject root = super.toJson();
        if (!this.overrides.isEmpty()) {
            JsonArray overridesJson = new JsonArray();
            this.overrides.stream().map(OverrideBuilder::toJson).forEach(arg_0 -> ((JsonArray)overridesJson).add(arg_0));
            root.add("overrides", (JsonElement)overridesJson);
        }
        return root;
    }

    public class OverrideBuilder {
        private ModelFile model;
        private final Map<ResourceLocation, Float> predicates = new LinkedHashMap<ResourceLocation, Float>();

        public OverrideBuilder model(ModelFile model) {
            this.model = model;
            model.assertExistence();
            return this;
        }

        public OverrideBuilder predicate(ResourceLocation key, float value) {
            this.predicates.put(key, Float.valueOf(value));
            return this;
        }

        public ItemModelBuilderPM end() {
            return ItemModelBuilderPM.this;
        }

        JsonObject toJson() {
            JsonObject ret = new JsonObject();
            JsonObject predicatesJson = new JsonObject();
            this.predicates.forEach((key, val) -> predicatesJson.addProperty(key.toString(), (Number)val));
            ret.add("predicate", (JsonElement)predicatesJson);
            ret.addProperty("model", this.model.getLocation().toString());
            return ret;
        }
    }
}

