/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.items;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.armor.RobeArmorItem;
import com.verdantartifice.primalmagick.common.items.entities.ManaArrowItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.food.AmbrosiaItem;
import com.verdantartifice.primalmagick.common.items.misc.AttunementShacklesItem;
import com.verdantartifice.primalmagick.common.items.misc.HummingArtifactItem;
import com.verdantartifice.primalmagick.common.items.misc.PixieItem;
import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.items.misc.SanguineCoreItem;
import com.verdantartifice.primalmagick.datagen.items.ItemModelBuilderPM;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelProviderPM
extends ModelProvider<ItemModelBuilderPM> {
    private static final List<ResourceKey<TrimMaterial>> SUPPORTED_TRIMS = ImmutableList.builder().add((Object[])new ResourceKey[]{TrimMaterials.f_265872_, TrimMaterials.f_265969_, TrimMaterials.f_266027_, TrimMaterials.f_266071_, TrimMaterials.f_265937_, TrimMaterials.f_266000_, TrimMaterials.f_265981_, TrimMaterials.f_265896_, TrimMaterials.f_265905_, TrimMaterials.f_265870_}).build();
    private final CompletableFuture<HolderLookup.Provider> lookupProviderFuture;

    public ItemModelProviderPM(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper exFileHelper) {
        super(output, "primalmagick", "item", ItemModelBuilderPM::new, exFileHelper);
        this.lookupProviderFuture = lookupProvider;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return ((CompletableFuture)this.lookupProviderFuture.thenApply(p -> {
            this.clear();
            this.registerModels((HolderLookup.Provider)p);
            return p;
        })).thenCompose(p -> this.generateAll(cache));
    }

    public void clear() {
        super.clear();
    }

    public CompletableFuture<?> generateAll(CachedOutput cache) {
        return super.generateAll(cache);
    }

    public String m_6055_() {
        return "Item Models: " + this.modid;
    }

    protected void registerModels() {
    }

    protected void registerModels(HolderLookup.Provider lookupProvider) {
        this.basicItem((Item)ItemsPM.HYDROMELON_SEEDS.get());
        this.basicItem((Item)ItemsPM.HYDROMELON_SLICE.get());
        this.itemWithParent((Item)ItemsPM.SALTED_BAKED_POTATO.get(), Items.f_42674_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_BEEF.get(), Items.f_42580_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_CHICKEN.get(), Items.f_42582_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_COD.get(), Items.f_42530_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_MUTTON.get(), Items.f_42659_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_PORKCHOP.get(), Items.f_42486_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_RABBIT.get(), Items.f_42698_);
        this.itemWithParent((Item)ItemsPM.SALTED_COOKED_SALMON.get(), Items.f_42531_);
        this.itemWithParent((Item)ItemsPM.SALTED_BEETROOT_SOUP.get(), Items.f_42734_);
        this.itemWithParent((Item)ItemsPM.SALTED_MUSHROOM_STEW.get(), Items.f_42400_);
        this.itemWithParent((Item)ItemsPM.SALTED_RABBIT_STEW.get(), Items.f_42699_);
        this.basicItem((Item)ItemsPM.IRON_GRIT.get());
        this.basicItem((Item)ItemsPM.GOLD_GRIT.get());
        this.basicItem((Item)ItemsPM.COPPER_GRIT.get());
        this.basicItem((Item)ItemsPM.PRIMALITE_INGOT.get());
        this.basicItem((Item)ItemsPM.HEXIUM_INGOT.get());
        this.basicItem((Item)ItemsPM.HALLOWSTEEL_INGOT.get());
        this.basicItem((Item)ItemsPM.PRIMALITE_NUGGET.get());
        this.basicItem((Item)ItemsPM.HEXIUM_NUGGET.get());
        this.basicItem((Item)ItemsPM.HALLOWSTEEL_NUGGET.get());
        this.basicItem((Item)ItemsPM.QUARTZ_NUGGET.get());
        this.itemWithParent((Item)ItemsPM.ENERGIZED_AMETHYST.get(), Items.f_151049_);
        this.itemWithParent((Item)ItemsPM.ENERGIZED_DIAMOND.get(), Items.f_42415_);
        this.itemWithParent((Item)ItemsPM.ENERGIZED_EMERALD.get(), Items.f_42616_);
        this.itemWithParent((Item)ItemsPM.ENERGIZED_QUARTZ.get(), Items.f_42692_);
        this.handheldItem((Item)ItemsPM.PRIMALITE_SWORD.get());
        this.tridentItem((TridentItem)ItemsPM.PRIMALITE_TRIDENT.get());
        this.bowItem((BowItem)ItemsPM.PRIMALITE_BOW.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_AXE.get());
        this.handheldItem((Item)ItemsPM.PRIMALITE_HOE.get());
        this.fishingRodItem((FishingRodItem)ItemsPM.PRIMALITE_FISHING_ROD.get());
        this.shieldItem((ShieldItem)ItemsPM.PRIMALITE_SHIELD.get(), this.blockTexture((Block)BlocksPM.PRIMALITE_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.HEXIUM_SWORD.get());
        this.tridentItem((TridentItem)ItemsPM.HEXIUM_TRIDENT.get());
        this.bowItem((BowItem)ItemsPM.HEXIUM_BOW.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_AXE.get());
        this.handheldItem((Item)ItemsPM.HEXIUM_HOE.get());
        this.fishingRodItem((FishingRodItem)ItemsPM.HEXIUM_FISHING_ROD.get());
        this.shieldItem((ShieldItem)ItemsPM.HEXIUM_SHIELD.get(), this.blockTexture((Block)BlocksPM.HEXIUM_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_SWORD.get());
        this.tridentItem((TridentItem)ItemsPM.HALLOWSTEEL_TRIDENT.get());
        this.bowItem((BowItem)ItemsPM.HALLOWSTEEL_BOW.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_AXE.get());
        this.handheldItem((Item)ItemsPM.HALLOWSTEEL_HOE.get());
        this.fishingRodItem((FishingRodItem)ItemsPM.HALLOWSTEEL_FISHING_ROD.get());
        this.shieldItem((ShieldItem)ItemsPM.HALLOWSTEEL_SHIELD.get(), this.blockTexture((Block)BlocksPM.HALLOWSTEEL_BLOCK.get()));
        this.handheldItem((Item)ItemsPM.FORBIDDEN_SWORD.get());
        this.tridentItem((TridentItem)ItemsPM.FORBIDDEN_TRIDENT.get());
        this.bowItem((BowItem)ItemsPM.FORBIDDEN_BOW.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_SHOVEL.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_PICKAXE.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_AXE.get());
        this.handheldItem((Item)ItemsPM.PRIMAL_HOE.get());
        this.fishingRodItem((FishingRodItem)ItemsPM.PRIMAL_FISHING_ROD.get());
        ManaArrowItem.getManaArrows().forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_mana_arrow")));
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.IMBUED_WOOL_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SPELLCLOTH_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXWEAVE_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.SAINTSWOOL_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.PRIMALITE_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.PRIMALITE_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.PRIMALITE_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.PRIMALITE_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXIUM_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXIUM_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXIUM_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HEXIUM_FEET.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HALLOWSTEEL_HEAD.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HALLOWSTEEL_CHEST.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HALLOWSTEEL_LEGS.get(), lookupProvider);
        this.armorItemWithTrims((ArmorItem)ItemsPM.HALLOWSTEEL_FEET.get(), lookupProvider);
        this.basicItem((Item)ItemsPM.GRIMOIRE.get());
        this.basicItem((Item)ItemsPM.CREATIVE_GRIMOIRE.get());
        this.basicItem((Item)ItemsPM.MAGNIFYING_GLASS.get());
        this.basicItem((Item)ItemsPM.ALCHEMICAL_WASTE.get());
        this.basicItem((Item)ItemsPM.BLOODY_FLESH.get());
        this.basicItem((Item)ItemsPM.HALLOWED_ORB.get());
        this.basicItem((Item)ItemsPM.HEARTWOOD.get());
        this.basicItem((Item)ItemsPM.ENCHANTED_INK.get());
        this.basicItem((Item)ItemsPM.ENCHANTED_INK_AND_QUILL.get());
        this.basicItem((Item)ItemsPM.SEASCRIBE_PEN.get());
        this.basicItem((Item)ItemsPM.ROCK_SALT.get());
        this.basicItem((Item)ItemsPM.EARTHSHATTER_HAMMER.get());
        this.basicItem((Item)ItemsPM.MANA_PRISM.get());
        this.basicItem((Item)ItemsPM.TALLOW.get());
        this.basicItem((Item)ItemsPM.BEESWAX.get());
        this.basicItem((Item)ItemsPM.MANA_SALTS.get());
        this.basicItem((Item)ItemsPM.MANAFRUIT.get());
        this.basicItem((Item)ItemsPM.INCENSE_STICK.get());
        this.basicItem((Item)ItemsPM.SOUL_GEM.get());
        this.basicItem((Item)ItemsPM.SOUL_GEM_SLIVER.get());
        this.basicItem((Item)ItemsPM.SPELLCLOTH.get());
        this.basicItem((Item)ItemsPM.HEXWEAVE.get());
        this.basicItem((Item)ItemsPM.SAINTSWOOL.get());
        this.basicItem((Item)ItemsPM.MAGITECH_PARTS_BASIC.get());
        this.basicItem((Item)ItemsPM.MAGITECH_PARTS_ENCHANTED.get());
        this.basicItem((Item)ItemsPM.MAGITECH_PARTS_FORBIDDEN.get());
        this.basicItem((Item)ItemsPM.MAGITECH_PARTS_HEAVENLY.get());
        this.dyeableItem((Item)ItemsPM.FLYING_CARPET.get(), DyeColor.WHITE);
        this.basicItem((Item)ItemsPM.DREAM_VISION_TALISMAN.get());
        this.basicItem((Item)ItemsPM.IGNYX.get());
        this.basicItem((Item)ItemsPM.DOWSING_ROD.get());
        this.basicItem((Item)ItemsPM.FOUR_LEAF_CLOVER.get());
        this.basicItem((Item)ItemsPM.RECALL_STONE.get());
        this.basicItem((Item)ItemsPM.RUNIC_ARMOR_TRIM_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ItemsPM.BASIC_WARDING_MODULE.get());
        this.basicItem((Item)ItemsPM.GREATER_WARDING_MODULE.get());
        this.basicItem((Item)ItemsPM.SUPREME_WARDING_MODULE.get());
        this.basicItem((Item)ItemsPM.OBSERVATION_NOTES.get());
        this.basicItem((Item)ItemsPM.THEORY_NOTES.get());
        this.basicItem((Item)ItemsPM.MYSTICAL_RELIC.get());
        this.basicItem((Item)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get());
        this.basicItem((Item)ItemsPM.BLOOD_NOTES.get());
        this.basicItem((Item)ItemsPM.SHEEP_TOME.get());
        EssenceItem.getAllEssences().forEach(this::basicItem);
        this.basicItem((Item)ItemsPM.RUNE_UNATTUNED.get());
        RuneItem.getAllRunes().forEach(this::basicItem);
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.BASIC).forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_ambrosia")));
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.GREATER).forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_ambrosia_greater")));
        AmbrosiaItem.getAllAmbrosiasOfType(AmbrosiaItem.Type.SUPREME).forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_ambrosia_supreme")));
        AttunementShacklesItem.getAllShackles().forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_attunement_shackles")));
        this.basicItem((Item)ItemsPM.HUMMING_ARTIFACT_UNATTUNED.get());
        HummingArtifactItem.getAllHummingArtifacts().forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_humming_artifact")));
        this.itemWithParent((Item)ItemsPM.SANGUINE_CORE_BLANK.get(), PrimalMagick.resource("item/template_sanguine_core"));
        SanguineCoreItem.getAllCores().forEach(item -> this.itemWithParent((Item)item, PrimalMagick.resource("item/template_sanguine_core")));
        this.basicItem((Item)ItemsPM.SKYGLASS_FLASK.get());
        this.itemWithOverlay((Item)ItemsPM.CONCOCTION.get());
        this.basicItem((Item)ItemsPM.BOMB_CASING.get());
        this.itemWithOverlay((Item)ItemsPM.ALCHEMICAL_BOMB.get());
        this.basicItem((Item)ItemsPM.SPELL_SCROLL_BLANK.get());
        this.basicItem((Item)ItemsPM.SPELL_SCROLL_FILLED.get());
        this.spawnEggItem((SpawnEggItem)ItemsPM.TREEFOLK_SPAWN_EGG.get());
        this.spawnEggItem((SpawnEggItem)ItemsPM.PRIMALITE_GOLEM_SPAWN_EGG.get());
        this.spawnEggItem((SpawnEggItem)ItemsPM.HEXIUM_GOLEM_SPAWN_EGG.get());
        this.spawnEggItem((SpawnEggItem)ItemsPM.HALLOWSTEEL_GOLEM_SPAWN_EGG.get());
        PixieItem.getAllPixies().forEach(this::pixieItem);
        this.basicItem((Item)ItemsPM.STATIC_BOOK.get());
        this.itemWithParent((Item)ItemsPM.STATIC_TABLET.get(), (Item)ItemsPM.MYSTICAL_RELIC.get());
        this.basicItem((Item)ItemsPM.CODEX.get());
        this.itemWithParent((Item)ItemsPM.CODEX_CREATIVE.get(), (Item)ItemsPM.CODEX.get());
        this.itemWithParent((Item)ItemsPM.LORE_TABLET_FRAGMENT.get(), (Item)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get());
        this.itemWithParent((Item)ItemsPM.LORE_TABLET_DIRTY.get(), (Item)ItemsPM.MYSTICAL_RELIC.get());
        this.itemWithParent((Item)ItemsPM.TICK_STICK.get(), Items.f_42398_);
    }

    private ResourceLocation key(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    private ResourceLocation key(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    private ItemModelBuilderPM builder(Item item) {
        return this.builder(this.key(item));
    }

    private ItemModelBuilderPM builder(ResourceLocation loc) {
        return (ItemModelBuilderPM)this.getBuilder(loc.toString());
    }

    private ResourceLocation defaultModelLoc(Item item) {
        return this.key(item).m_246208_("item/");
    }

    private ModelFile existingModel(ResourceLocation modelLoc) {
        return new ModelFile.ExistingModelFile(modelLoc, this.existingFileHelper);
    }

    private ModelFile uncheckedModel(ResourceLocation modelLoc) {
        return new ModelFile.UncheckedModelFile(modelLoc);
    }

    private ResourceLocation blockTexture(Block block) {
        return this.key(block).m_246208_("block/");
    }

    public ItemModelBuilderPM basicItem(Item item) {
        ResourceLocation key = this.key(item);
        return (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(key).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(key.m_135827_(), "item/" + key.m_135815_()));
    }

    private ItemModelBuilderPM itemWithParent(Item item, Item parent) {
        return this.itemWithParent(item, this.defaultModelLoc(parent));
    }

    private ItemModelBuilderPM itemWithParent(Item item, ResourceLocation parent) {
        return (ItemModelBuilderPM)this.builder(item).parent(this.existingModel(parent));
    }

    private ItemModelBuilderPM handheldItem(Item item) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(item).parent(this.existingModel(new ResourceLocation("item/handheld")))).texture("layer0", this.defaultModelLoc(item));
    }

    private ItemModelBuilderPM tridentItem(TridentItem item) {
        ItemModelBuilderPM throwingModel = this.tridentThrowingModel(item);
        ItemModelBuilderPM inHandModel = this.tridentInHandModel(item, (ModelFile)throwingModel);
        return this.basicItem((Item)item).override().predicate(new ResourceLocation("throwing"), 0.0f).model((ModelFile)inHandModel).end().override().predicate(new ResourceLocation("throwing"), 1.0f).model((ModelFile)throwingModel).end();
    }

    private ItemModelBuilderPM tridentInHandModel(TridentItem item, ModelFile throwingModel) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(this.key((Item)item).m_266382_("_in_hand")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", this.defaultModelLoc((Item)item))).override().predicate(new ResourceLocation("throwing"), 1.0f).model(throwingModel).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(11.0f, 17.0f, -2.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(3.0f, 17.0f, 12.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.GUI).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().end();
    }

    private ItemModelBuilderPM tridentThrowingModel(TridentItem item) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(this.key((Item)item).m_266382_("_throwing")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", this.defaultModelLoc((Item)item))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, 9.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, -7.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).scale(1.0f).end().transform(ItemDisplayContext.GUI).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(8.0f, 8.0f, 8.0f).scale(1.0f).end().end();
    }

    private ItemModelBuilderPM bowItem(BowItem item) {
        ResourceLocation pulling = new ResourceLocation("pulling");
        ResourceLocation pull = new ResourceLocation("pull");
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.defaultModelLoc((Item)item))).override().predicate(pulling, 1.0f).model((ModelFile)this.bowPullingModel(item, 0)).end().override().predicate(pulling, 1.0f).predicate(pull, 0.65f).model((ModelFile)this.bowPullingModel(item, 1)).end().override().predicate(pulling, 1.0f).predicate(pull, 0.9f).model((ModelFile)this.bowPullingModel(item, 2)).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().end();
    }

    private ItemModelBuilderPM bowPullingModel(BowItem item, int stage) {
        ResourceLocation stageKey = this.key((Item)item).m_266382_("_pulling_" + stage);
        return (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(stageKey).parent(this.uncheckedModel(this.defaultModelLoc((Item)item)))).texture("layer0", stageKey.m_246208_("item/"));
    }

    private ItemModelBuilderPM fishingRodItem(FishingRodItem item) {
        return ((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld_rod"))).texture("layer0", this.defaultModelLoc((Item)item))).override().predicate(new ResourceLocation("cast"), 1.0f).model((ModelFile)this.fishingRodCastModel(item)).end();
    }

    private ItemModelBuilderPM fishingRodCastModel(FishingRodItem item) {
        ResourceLocation castKey = this.key((Item)item).m_266382_("_cast");
        return (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(castKey).parent(this.uncheckedModel(this.defaultModelLoc((Item)item)))).texture("layer0", castKey.m_246208_("item/"));
    }

    private ItemModelBuilderPM shieldItem(ShieldItem item, ResourceLocation particleTexture) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder((Item)item).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", particleTexture)).override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)this.shieldBlockingModel(item, particleTexture)).end().transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(10.0f, 6.0f, -4.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 0.0f).translation(10.0f, 6.0f, 12.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, 5.0f).translation(-10.0f, 2.0f, -10.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 180.0f, 5.0f).translation(10.0f, 0.0f, -10.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 4.0f, 2.0f).scale(0.25f).end().end();
    }

    private ItemModelBuilderPM shieldBlockingModel(ShieldItem item, ResourceLocation particleTexture) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(this.key((Item)item).m_266382_("_blocking")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", particleTexture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(45.0f, 135.0f, 0.0f).translation(3.51f, 11.0f, -2.0f).scale(1.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(45.0f, 135.0f, 0.0f).translation(13.51f, 3.0f, 5.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, -5.0f).translation(-15.0f, 5.0f, -11.0f).scale(1.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 180.0f, -5.0f).translation(5.0f, 5.0f, -11.0f).scale(1.25f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().end();
    }

    private ItemModelBuilderPM armorItemWithTrims(ArmorItem item, HolderLookup.Provider lookupProvider) {
        return this.armorItemWithTrims(item, SUPPORTED_TRIMS, lookupProvider);
    }

    private ItemModelBuilderPM armorItemWithTrims(ArmorItem item, List<ResourceKey<TrimMaterial>> trimKeys, HolderLookup.Provider lookupProvider) {
        return this.armorItemWithTrims(item, trimKeys.stream().map(key -> this.getTrimMaterial((ResourceKey<TrimMaterial>)key, lookupProvider)).toList());
    }

    private ItemModelBuilderPM armorItemWithTrims(ArmorItem item, List<Holder<TrimMaterial>> trims) {
        return this.armorItemWithTrims(item, this.getArmorTrimOverlay(item), trims);
    }

    private ItemModelBuilderPM armorItemWithTrims(ArmorItem item, ResourceLocation trimOverlayLoc, List<Holder<TrimMaterial>> trims) {
        ResourceLocation trimType = new ResourceLocation("trim_type");
        ItemModelBuilderPM builder = this.basicItem((Item)item);
        List sortedTrims = trims.stream().sorted((m1, m2) -> Float.compare(((TrimMaterial)m1.m_203334_()).f_265933_(), ((TrimMaterial)m2.m_203334_()).f_265933_())).toList();
        for (Holder trim : sortedTrims) {
            builder = builder.override().predicate(trimType, ((TrimMaterial)trim.m_203334_()).f_265933_()).model((ModelFile)this.trimmedArmorModel(item, trimOverlayLoc, (Holder<TrimMaterial>)trim)).end();
        }
        return builder;
    }

    private ItemModelBuilderPM trimmedArmorModel(ArmorItem item, ResourceLocation trimOverlayLoc, Holder<TrimMaterial> trim) {
        String palatteSuffix = this.getArmorTrimColorPaletteSuffix(trim, item.m_40401_());
        return ((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(this.key((Item)item).m_266382_("_" + palatteSuffix + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.defaultModelLoc((Item)item))).palattedTexture("layer1", trimOverlayLoc, palatteSuffix);
    }

    private ResourceLocation getArmorTrimOverlay(ArmorItem item) {
        if (item instanceof RobeArmorItem) {
            return switch (item.m_40402_()) {
                case EquipmentSlot.HEAD -> PrimalMagick.resource("trims/items/robe_head_trim");
                case EquipmentSlot.CHEST -> PrimalMagick.resource("trims/items/robe_chest_trim");
                case EquipmentSlot.LEGS -> PrimalMagick.resource("trims/items/robe_legs_trim");
                case EquipmentSlot.FEET -> PrimalMagick.resource("trims/items/robe_feet_trim");
                default -> throw new IllegalArgumentException("Invalid armor type for trim overlay detection");
            };
        }
        return switch (item.m_40402_()) {
            case EquipmentSlot.HEAD -> new ResourceLocation("trims/items/helmet_trim");
            case EquipmentSlot.CHEST -> new ResourceLocation("trims/items/chestplate_trim");
            case EquipmentSlot.LEGS -> new ResourceLocation("trims/items/leggings_trim");
            case EquipmentSlot.FEET -> new ResourceLocation("trims/items/boots_trim");
            default -> throw new IllegalArgumentException("Invalid armor type for trim overlay detection");
        };
    }

    private Holder<TrimMaterial> getTrimMaterial(ResourceKey<TrimMaterial> key, HolderLookup.Provider lookupProvider) {
        return lookupProvider.m_255025_(Registries.f_266076_).m_255043_(key);
    }

    private String getArmorTrimColorPaletteSuffix(Holder<TrimMaterial> trimMaterial, ArmorMaterial armorMaterial) {
        Map map = ((TrimMaterial)trimMaterial.m_203334_()).f_267481_();
        return armorMaterial instanceof ArmorMaterials && map.containsKey(armorMaterial) ? (String)map.get(armorMaterial) : ((TrimMaterial)trimMaterial.m_203334_()).f_265854_();
    }

    private ItemModelBuilderPM itemWithOverlay(Item item) {
        ResourceLocation texture = this.defaultModelLoc(item);
        return (ItemModelBuilderPM)((ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(item).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture.m_266382_("_overlay"))).texture("layer1", texture);
    }

    private ItemModelBuilderPM spawnEggItem(SpawnEggItem item) {
        return this.itemWithParent((Item)item, new ResourceLocation("item/template_spawn_egg"));
    }

    private void pixieItem(PixieItem item) {
        this.itemWithParent((Item)item, PrimalMagick.resource("item/template_pixie"));
        ((ItemModelBuilderPM)this.getBuilder(this.key((Item)item).m_246208_("drained_").toString())).parent(this.existingModel(PrimalMagick.resource("item/template_drained_pixie")));
    }

    private ItemModelBuilderPM dyeableItem(Item item, DyeColor defaultColor) {
        ResourceLocation key = this.key(item);
        ItemModelBuilderPM builder = (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(key).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(key.m_135827_(), "item/" + key.m_135815_() + "_" + defaultColor.m_41065_()));
        List<DyeColor> sortedColors = Stream.of(DyeColor.values()).sorted((c1, c2) -> Integer.compare(c1.m_41060_(), c2.m_41060_())).toList();
        for (DyeColor color : sortedColors) {
            builder = builder.override().predicate(PrimalMagick.resource("color"), (float)color.m_41060_() / 16.0f).model((ModelFile)this.dyedItemModel(item, color)).end();
        }
        return builder;
    }

    private ItemModelBuilderPM dyedItemModel(Item item, DyeColor color) {
        return (ItemModelBuilderPM)((ItemModelBuilderPM)this.builder(this.key(item).m_266382_("_" + color.m_41065_())).parent(this.existingModel(this.defaultModelLoc(item)))).texture("layer0", this.defaultModelLoc(item).m_266382_("_" + color.m_41065_()));
    }
}

