/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang;

import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import com.verdantartifice.primalmagick.datagen.lang.builders.AttunementThresholdLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.AttunementTypeLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.BlockLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.CommandLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ConcoctionLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.DamageTypeLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.EnchantmentLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.EntityTypeLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.EventLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.GrimoireLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ItemLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.JeiLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.KeyMappingLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.KnowledgeTypeLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.LabelLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.MobEffectLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ResearchDisciplineLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ResearchEntryLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ResearchProjectLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ResearchRequirementLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.RitualLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.SourceLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.SpellModLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.SpellPayloadLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.SpellPropertyLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.SpellVehicleLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.StatLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.TipLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.TooltipLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.TrimMaterialLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.TrimMaterialSourceMultipliedLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.TrimPatternLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.WandComponentLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.WrittenBookLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.WrittenLanguageLanguageBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class AbstractLanguageProviderPM
extends LanguageProvider {
    protected final Map<String, ILanguageBuilder> tracking = new TreeMap<String, ILanguageBuilder>();
    protected final Map<Source, String> sourceNames = new HashMap<Source, String>();

    public AbstractLanguageProviderPM(PackOutput output, String locale) {
        super(output, "primalmagick", locale);
    }

    private void track(ILanguageBuilder builder) {
        String key = builder.getBuilderKey();
        if (this.tracking.containsKey(key)) {
            throw new IllegalStateException("Already tracking language builder for resource key " + key);
        }
        this.tracking.put(key, builder);
    }

    private void untrack(ILanguageBuilder builder) {
        this.tracking.remove(builder.getBuilderKey());
    }

    protected abstract void addLocalizations();

    protected void addTranslations() {
        this.addLocalizations();
        this.validate();
    }

    protected void validate() {
        MutableInt count = new MutableInt(0);
        this.tracking.forEach((key, builder) -> {
            if (builder.isEmpty()) {
                f_252483_.warn("Empty untracked language builder left over for " + key.toString());
            } else {
                f_252483_.error("Unbuilt language builder left over for " + key.toString());
                count.increment();
            }
        });
        if (count.intValue() > 0) {
            throw new IllegalStateException("Found " + count.intValue() + " unbuilt language builders for " + this.m_6055_());
        }
    }

    protected void saveSourceName(Source source, String name) {
        this.sourceNames.put(source, name);
    }

    protected String getSourceName(Source source) {
        if (this.sourceNames.containsKey(source)) {
            return this.sourceNames.get(source);
        }
        throw new IllegalStateException("No source name found for " + source.getTag());
    }

    private <T extends ILanguageBuilder> T createBuilder(Supplier<T> builderFactory) {
        ILanguageBuilder builder = (ILanguageBuilder)builderFactory.get();
        this.track(builder);
        return (T)builder;
    }

    public BlockLanguageBuilder block(Supplier<? extends Block> block) {
        return this.block(block.get());
    }

    public BlockLanguageBuilder block(Block block) {
        return this.createBuilder(() -> new BlockLanguageBuilder(block, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ItemLanguageBuilder item(Supplier<? extends Item> item) {
        return this.item(item.get());
    }

    public ItemLanguageBuilder item(Item item) {
        return this.createBuilder(() -> new ItemLanguageBuilder(item, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public TooltipLanguageBuilder tooltip(String id) {
        return this.createBuilder(() -> new TooltipLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public EntityTypeLanguageBuilder entity(Supplier<? extends EntityType<?>> entity) {
        return this.entity(entity.get());
    }

    public EntityTypeLanguageBuilder entity(EntityType<?> entity) {
        return this.createBuilder(() -> new EntityTypeLanguageBuilder(entity, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public MobEffectLanguageBuilder mobEffect(Supplier<? extends MobEffect> effect) {
        return this.mobEffect(effect.get());
    }

    public MobEffectLanguageBuilder mobEffect(MobEffect effect) {
        return this.createBuilder(() -> new MobEffectLanguageBuilder(effect, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public EnchantmentLanguageBuilder enchantment(Supplier<? extends Enchantment> ench) {
        return this.enchantment(ench.get());
    }

    public EnchantmentLanguageBuilder enchantment(Enchantment ench) {
        return this.createBuilder(() -> new EnchantmentLanguageBuilder(ench, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public SourceLanguageBuilder source(Source source) {
        return this.createBuilder(() -> new SourceLanguageBuilder(source, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1), this::saveSourceName));
    }

    public WandComponentLanguageBuilder wandComponent(IWandComponent component) {
        return this.createBuilder(() -> new WandComponentLanguageBuilder(component, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public KnowledgeTypeLanguageBuilder knowledgeType(KnowledgeType type) {
        return this.createBuilder(() -> new KnowledgeTypeLanguageBuilder(type, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public AttunementTypeLanguageBuilder attunementType(AttunementType type) {
        return this.createBuilder(() -> new AttunementTypeLanguageBuilder(type, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public AttunementThresholdLanguageBuilder attunementThreshold(AttunementThreshold threshold) {
        return this.createBuilder(() -> new AttunementThresholdLanguageBuilder(threshold, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ResearchDisciplineLanguageBuilder researchDiscipline(ResearchDiscipline disc) {
        return this.createBuilder(() -> new ResearchDisciplineLanguageBuilder(disc, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ResearchEntryLanguageBuilder researchEntry(String keyStr) {
        return this.researchEntry(ResearchNames.find(keyStr).orElseThrow());
    }

    public ResearchEntryLanguageBuilder researchEntry(ResearchName key) {
        return this.researchEntry(key.simpleKey());
    }

    public ResearchEntryLanguageBuilder researchEntry(SimpleResearchKey key) {
        return this.createBuilder(() -> new ResearchEntryLanguageBuilder(key, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ResearchRequirementLanguageBuilder researchRequirement(String keyStr) {
        return this.researchRequirement(ResearchNames.find(keyStr).orElseThrow());
    }

    public ResearchRequirementLanguageBuilder researchRequirement(ResearchName key) {
        return this.researchRequirement(key.simpleKey());
    }

    public ResearchRequirementLanguageBuilder researchRequirement(SimpleResearchKey key) {
        return this.createBuilder(() -> new ResearchRequirementLanguageBuilder(key, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ResearchProjectLanguageBuilder researchProject(String id) {
        return this.createBuilder(() -> new ResearchProjectLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public CommandLanguageBuilder command(String token) {
        return this.createBuilder(() -> new CommandLanguageBuilder(token, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public EventLanguageBuilder event(String token) {
        return this.createBuilder(() -> new EventLanguageBuilder(token, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public LabelLanguageBuilder label(String token) {
        return this.createBuilder(() -> new LabelLanguageBuilder(token, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public WrittenBookLanguageBuilder book(Supplier<? extends BookDefinition> book) {
        return this.book(book.get());
    }

    public WrittenBookLanguageBuilder book(BookDefinition book) {
        return this.createBuilder(() -> new WrittenBookLanguageBuilder(book, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public WrittenLanguageLanguageBuilder language(Supplier<? extends BookLanguage> lang) {
        return this.language(lang.get());
    }

    public WrittenLanguageLanguageBuilder language(BookLanguage lang) {
        return this.createBuilder(() -> new WrittenLanguageLanguageBuilder(lang, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public SpellVehicleLanguageBuilder spellVehicle(String id) {
        return this.createBuilder(() -> new SpellVehicleLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public SpellPayloadLanguageBuilder spellPayload(String id) {
        return this.createBuilder(() -> new SpellPayloadLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public SpellModLanguageBuilder spellMod(String id) {
        return this.createBuilder(() -> new SpellModLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public SpellPropertyLanguageBuilder spellProperty(String id) {
        return this.createBuilder(() -> new SpellPropertyLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public GrimoireLanguageBuilder grimoire(String id) {
        return this.createBuilder(() -> new GrimoireLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public KeyMappingLanguageBuilder keyMapping(KeyMapping mapping, String regName) {
        return this.createBuilder(() -> new KeyMappingLanguageBuilder(mapping, regName, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public StatLanguageBuilder stat(Stat stat) {
        return this.createBuilder(() -> new StatLanguageBuilder(stat, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public RitualLanguageBuilder ritual(String id) {
        return this.createBuilder(() -> new RitualLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public ConcoctionLanguageBuilder concoction(String id) {
        return this.createBuilder(() -> new ConcoctionLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public TrimMaterialLanguageBuilder trimMaterial(ResourceKey<TrimMaterial> key) {
        return this.createBuilder(() -> new TrimMaterialLanguageBuilder(key, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public TrimMaterialSourceMultipliedLanguageBuilder trimMaterial(String name, List<ResourceKey<TrimMaterial>> keys) {
        return this.createBuilder(() -> new TrimMaterialSourceMultipliedLanguageBuilder(name, keys, this::getSourceName, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public TrimPatternLanguageBuilder trimPattern(ResourceKey<TrimPattern> key) {
        return this.createBuilder(() -> new TrimPatternLanguageBuilder(key, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public DamageTypeLanguageBuilder deathMessage(ResourceKey<DamageType> key) {
        return this.createBuilder(() -> new DamageTypeLanguageBuilder(key, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public JeiLanguageBuilder jei(String id) {
        return this.createBuilder(() -> new JeiLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }

    public TipLanguageBuilder tip(String id) {
        return this.createBuilder(() -> new TipLanguageBuilder(id, this::untrack, (arg_0, arg_1) -> ((AbstractLanguageProviderPM)this).add(arg_0, arg_1)));
    }
}

