/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang.builders;

import com.google.common.base.Preconditions;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractLanguageBuilder<T, U extends AbstractLanguageBuilder<T, U>>
implements ILanguageBuilder {
    protected final T base;
    protected final Supplier<String> keyExtractor;
    protected final Consumer<ILanguageBuilder> untracker;
    protected final BiConsumer<String, String> adder;
    protected final Map<String, String> data = new TreeMap<String, String>();

    public AbstractLanguageBuilder(T base, Supplier<String> keyExtractor, Consumer<ILanguageBuilder> untracker, BiConsumer<String, String> adder) {
        this.base = Preconditions.checkNotNull(base);
        this.keyExtractor = (Supplier)Preconditions.checkNotNull(keyExtractor);
        this.untracker = (Consumer)Preconditions.checkNotNull(untracker);
        this.adder = (BiConsumer)Preconditions.checkNotNull(adder);
    }

    private U self() {
        return (U)this;
    }

    protected ResourceLocation getBaseRegistryKey() {
        return this.getBaseRegistryKey(this.base);
    }

    protected abstract ResourceLocation getBaseRegistryKey(T var1);

    protected void add(String key, String value) {
        if (this.data.containsKey(key)) {
            throw new IllegalStateException("Duplicate translation key " + key + " for registered entry " + this.getBaseRegistryKey());
        }
        this.data.put(key, value);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void build() {
        this.data.forEach((key, value) -> this.adder.accept((String)key, (String)value));
        this.untracker.accept(this);
    }

    protected String getKey() {
        return this.keyExtractor.get();
    }

    protected String getKey(String ... suffixes) {
        return this.getKey(List.of(suffixes));
    }

    protected String getKey(List<String> suffixes) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.keyExtractor.get());
        tokens.addAll(suffixes);
        return String.join((CharSequence)".", tokens);
    }

    public U name(String value) {
        this.add(this.getKey(), value);
        return this.self();
    }
}

