/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang.builders;

import com.google.common.base.Preconditions;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractSourceMultipliedLanguageBuilder<T, U extends AbstractSourceMultipliedLanguageBuilder<T, U>>
implements ILanguageBuilder {
    protected final String builderKey;
    protected final List<T> bases = new ArrayList<T>();
    protected final Function<T, String> keyExtractor;
    protected final Function<T, Source> sourceExtractor;
    protected final Function<Source, String> sourceNameMapper;
    protected final Consumer<ILanguageBuilder> untracker;
    protected final BiConsumer<String, String> adder;
    protected final Map<String, String> data = new TreeMap<String, String>();

    public AbstractSourceMultipliedLanguageBuilder(String builderKey, List<T> bases, Function<T, String> keyExtractor, Function<T, Source> sourceExtractor, Function<Source, String> sourceNameMapper, Consumer<ILanguageBuilder> untracker, BiConsumer<String, String> adder) {
        this.builderKey = (String)Preconditions.checkNotNull((Object)builderKey);
        this.bases.addAll((Collection)Preconditions.checkNotNull(bases));
        this.keyExtractor = (Function)Preconditions.checkNotNull(keyExtractor);
        this.sourceExtractor = (Function)Preconditions.checkNotNull(sourceExtractor);
        this.sourceNameMapper = (Function)Preconditions.checkNotNull(sourceNameMapper);
        this.untracker = (Consumer)Preconditions.checkNotNull(untracker);
        this.adder = (BiConsumer)Preconditions.checkNotNull(adder);
    }

    private U self() {
        return (U)this;
    }

    protected void add(String key, String value) {
        if (this.data.containsKey(key)) {
            throw new IllegalStateException("Duplicate translation key " + key + " for builder " + this.getBuilderKey());
        }
        this.data.put(key, value);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void build() {
        this.data.forEach((key, value) -> this.adder.accept((String)key, (String)value));
        this.untracker.accept(this);
    }

    protected String getKey(T item) {
        return this.keyExtractor.apply(item);
    }

    protected String getKey(T item, String ... suffixes) {
        return this.getKey(item, List.of(suffixes));
    }

    protected String getKey(T item, List<String> suffixes) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(this.keyExtractor.apply(item));
        tokens.addAll(suffixes);
        return String.join((CharSequence)".", tokens);
    }

    public U namePattern(String pattern) {
        this.bases.stream().forEach(base -> this.add(this.getKey(base), String.format(pattern, this.sourceNameMapper.apply(this.sourceExtractor.apply(base)))));
        return this.self();
    }
}

