/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.lang.builders;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.datagen.lang.builders.AbstractLanguageBuilder;
import com.verdantartifice.primalmagick.datagen.lang.builders.ILanguageBuilder;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemLanguageBuilder
extends AbstractLanguageBuilder<Item, ItemLanguageBuilder> {
    public ItemLanguageBuilder(Item item, Consumer<ILanguageBuilder> untracker, BiConsumer<String, String> adder) {
        super(item, () -> ((Item)item).m_5524_(), untracker, adder);
    }

    @Override
    public String getBuilderKey() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.getBaseRegistryKey()).toString();
    }

    @Override
    protected ResourceLocation getBaseRegistryKey(Item base) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)base));
    }

    public ItemLanguageBuilder tooltip(String value) {
        this.add(this.getKey("tooltip"), value);
        return this;
    }

    public ItemLanguageBuilder tooltip(String ... values) {
        int index = 1;
        for (String value : values) {
            this.add(this.getKey("tooltip", Integer.toString(index++)), value);
        }
        return this;
    }

    public ItemLanguageBuilder coloredName(DyeColor color, String value) {
        this.add(this.getKey(color.m_41065_()), value);
        return this;
    }

    public ItemLanguageBuilder concoctionName(ConcoctionType type, Potion potion, String name) {
        return this.concoctionName(type, ForgeRegistries.POTIONS.getKey((Object)potion).m_135815_(), name);
    }

    public ItemLanguageBuilder concoctionName(ConcoctionType type, String effectName, String name) {
        this.add(this.getKey(type.m_7912_(), "effect", effectName), name);
        return this;
    }
}

