/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import com.verdantartifice.primalmagick.common.blocks.trees.AbstractPhasingLogBlock;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.Collections;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBlockLootTableProvider
extends BlockLootSubProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Set<ResourceLocation> registeredBlocks = new HashSet<ResourceLocation>();

    public AbstractBlockLootTableProvider() {
        super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
    }

    protected abstract void m_245660_();

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> writer) {
        super.m_245126_(writer);
        this.checkExpectations();
    }

    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("primalmagick")).map(entry -> (Block)entry.getValue()).toList();
    }

    private void registerLootTableBuilder(Block block, LootTable.Builder builder) {
        this.registeredBlocks.add(ForgeRegistries.BLOCKS.getKey((Object)block));
        this.m_247577_(block, builder);
    }

    protected void registerLootTableBuilder(Block block, Function<Block, LootTable.Builder> builderGenerator) {
        this.registerLootTableBuilder(block, builderGenerator.apply(block));
    }

    protected void registerEmptyTable(Block block) {
        this.registeredBlocks.add(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    protected void registerBasicTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79080_(ExplosionCondition.m_81661_());
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerSlabTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()));
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerLeavesTable(Block leavesBlock, Block saplingBlock, float[] saplingFortuneChances) {
        float[] stickFortuneChances = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        AnyOfCondition.Builder shearsOrSilkTouch = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG).m_285888_(f_243678_);
        LootPoolEntryContainer.Builder saplingEntryBuilder = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)saplingBlock).m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])saplingFortuneChances));
        LootPoolEntryContainer.Builder leavesEntryBuilder = LootItem.m_79579_((ItemLike)leavesBlock).m_79080_((LootItemCondition.Builder)shearsOrSilkTouch);
        LootPool.Builder saplingAndLeavesPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)leavesEntryBuilder.m_7170_(saplingEntryBuilder));
        LootPoolEntryContainer.Builder stickEntryBuilder = LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])stickFortuneChances));
        LootPool.Builder stickPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(shearsOrSilkTouch.m_81807_()).m_79076_(stickEntryBuilder);
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(saplingAndLeavesPool).m_79161_(stickPool);
        this.registerLootTableBuilder(leavesBlock, tableBuilder);
    }

    protected void registerInfusedStoneTable(Block stoneBlock, Item dustItem) {
        LootPoolEntryContainer.Builder dustEntryBuilder = LootItem.m_79579_((ItemLike)dustItem).m_79080_(ExplosionCondition.m_81661_());
        LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)stoneBlock).m_79080_(f_243678_)).m_7170_(dustEntryBuilder));
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(poolBuilder);
        this.registerLootTableBuilder(stoneBlock, tableBuilder);
    }

    protected void registerGemOreTable(Block oreBlock, Item gemItem) {
        LootPoolSingletonContainer.Builder gemEntryBuilder = LootItem.m_79579_((ItemLike)gemItem).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)oreBlock).m_79080_(f_243678_)).m_7170_((LootPoolEntryContainer.Builder)gemEntryBuilder)));
        this.registerLootTableBuilder(oreBlock, tableBuilder);
    }

    protected void registerMultiGemOreTable(Block oreBlock, Item gemItem, float minGems, float maxGems) {
        LootPoolSingletonContainer.Builder gemEntryBuilder = LootItem.m_79579_((ItemLike)gemItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minGems, (float)maxGems))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)oreBlock).m_79080_(f_243678_)).m_7170_((LootPoolEntryContainer.Builder)gemEntryBuilder)));
        this.registerLootTableBuilder(oreBlock, tableBuilder);
    }

    protected void registerManaBearingDeviceTable(Block block) {
        LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("ManaStorage.Mana.Sources", "ManaContainerTag.Sources"))).m_79080_(ExplosionCondition.m_81661_());
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(poolBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerPulsingLogTable(Block block) {
        LootPool.Builder logBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79080_(ExplosionCondition.m_81661_());
        LootPool.Builder pulseBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.HEARTWOOD.get()))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)AbstractPhasingLogBlock.PULSING, true)));
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(logBuilder).m_79161_(pulseBuilder);
        this.registerLootTableBuilder(block, tableBuilder);
    }

    protected void registerSplittingTable(Block block, Item splitItem, NumberProvider splitCount, OptionalInt maxWithFortune) {
        LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)splitItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)splitCount));
        if (maxWithFortune.isPresent()) {
            builder = builder.m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165040_((int)maxWithFortune.getAsInt())));
        }
        builder = builder.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        LootTable.Builder tableBuilder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(f_243678_)).m_7170_((LootPoolEntryContainer.Builder)builder)));
        this.registerLootTableBuilder(block, tableBuilder);
    }

    private void checkExpectations() {
        Set<ResourceLocation> blocks = ForgeRegistries.BLOCKS.getKeys().stream().filter(loc -> loc.m_135827_().equals("primalmagick")).collect(Collectors.toSet());
        blocks.removeAll(this.registeredBlocks);
        blocks.forEach(key -> LOGGER.warn("Missing block loot table for {}", (Object)key.toString()));
    }
}

