/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import com.verdantartifice.primalmagick.common.loot.LootTablesPM;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGameplayLootTableSubProvider
implements LootTableSubProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    protected final Set<ResourceLocation> registeredLootTableTypes = new HashSet<ResourceLocation>();

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> writer) {
        this.addTables(writer);
        this.checkExpectations();
    }

    private void checkExpectations() {
        HashSet<ResourceLocation> types = new HashSet<ResourceLocation>(LootTablesPM.all());
        types.removeAll(this.registeredLootTableTypes);
        types.forEach(key -> LOGGER.warn("Missing gameplay loot table for {}", (Object)key.toString()));
    }

    protected void registerEmptyLootTable(ResourceLocation loc) {
        this.registeredLootTableTypes.add(loc);
    }

    protected void registerLootTable(BiConsumer<ResourceLocation, LootTable.Builder> writer, ResourceLocation loc, LootTable.Builder builder) {
        writer.accept(loc, builder);
        this.registeredLootTableTypes.add(loc);
    }

    protected abstract void addTables(BiConsumer<ResourceLocation, LootTable.Builder> var1);
}

