/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.loot_tables;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityLootTables
extends EntityLootSubProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Set<ResourceLocation> registeredEntities = new HashSet<ResourceLocation>();

    public EntityLootTables() {
        super(FeatureFlags.f_244280_.m_247355_());
    }

    private void checkExpectations() {
        Set<ResourceLocation> entityTypes = ForgeRegistries.ENTITY_TYPES.getKeys().stream().filter(loc -> loc.m_135827_().equals("primalmagick")).collect(Collectors.toSet());
        entityTypes.removeAll(this.registeredEntities);
        entityTypes.forEach(key -> LOGGER.warn("Missing entity loot table for {}", (Object)key.toString()));
    }

    private void registerEmptyLootTable(EntityType<?> type) {
        this.registeredEntities.add(ForgeRegistries.ENTITY_TYPES.getKey(type));
    }

    private void registerLootTable(EntityType<?> type, LootTable.Builder builder) {
        this.m_245309_(type, builder);
        this.registeredEntities.add(ForgeRegistries.ENTITY_TYPES.getKey(type));
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return ForgeRegistries.ENTITY_TYPES.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("primalmagick")).map(entry -> (EntityType)entry.getValue());
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> writer) {
        super.m_245126_(writer);
        this.checkExpectations();
    }

    public void m_246942_() {
        this.registerEmptyLootTable((EntityType)EntityTypesPM.SPELL_MINE.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.SPELL_PROJECTILE.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.APPLE.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.IGNYX.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.ALCHEMICAL_BOMB.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.MANA_ARROW.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.FISHING_HOOK.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.PRIMALITE_TRIDENT.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.HEXIUM_TRIDENT.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.HALLOWSTEEL_TRIDENT.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.FORBIDDEN_TRIDENT.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.SIN_CRASH.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.SIN_CRYSTAL.get());
        this.registerEmptyLootTable((EntityType)EntityTypesPM.FLYING_CARPET.get());
        this.registerLootTable((EntityType)EntityTypesPM.TREEFOLK.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.HEARTWOOD.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.INNER_DEMON.get(), LootTable.m_79147_());
        this.registerLootTable((EntityType)EntityTypesPM.FRIENDLY_WITCH.get(), LootTable.m_79147_());
        this.registerLootTable((EntityType)EntityTypesPM.PRIMALITE_GOLEM.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.PRIMALITE_INGOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.HEXIUM_GOLEM.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.HEXIUM_INGOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.HALLOWSTEEL_GOLEM.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.HALLOWSTEEL_INGOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_EARTH_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_EARTH_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_EARTH_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_EARTH_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_EARTH_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_EARTH_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_SEA_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_SEA_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_SEA_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_SEA_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_SEA_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_SEA_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_SKY_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_SKY_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_SKY_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_SKY_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_SKY_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_SKY_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_SUN_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_SUN_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_SUN_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_SUN_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_SUN_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_SUN_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_MOON_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_MOON_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_MOON_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_MOON_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_MOON_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_MOON_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_BLOOD_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_BLOOD_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_BLOOD_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_BLOOD_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_BLOOD_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_BLOOD_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_INFERNAL_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_INFERNAL_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_INFERNAL_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_INFERNAL_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_INFERNAL_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_INFERNAL_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_VOID_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_VOID_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_VOID_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_VOID_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_VOID_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_VOID_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.BASIC_HALLOWED_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_BASIC_HALLOWED_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.GRAND_HALLOWED_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_GRAND_HALLOWED_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
        this.registerLootTable((EntityType)EntityTypesPM.MAJESTIC_HALLOWED_PIXIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsPM.DRAINED_MAJESTIC_HALLOWED_PIXIE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))));
    }

    public static LootTableProvider.SubProviderEntry getSubProviderEntry() {
        return new LootTableProvider.SubProviderEntry(EntityLootTables::new, LootContextParamSets.f_81415_);
    }
}

