/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DissolutionRecipeBuilder {
    protected final ItemStack result;
    protected Ingredient ingredient;
    protected String group;
    protected SourceList manaCosts;

    protected DissolutionRecipeBuilder(ItemStack result) {
        this.result = result.m_41777_();
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemStack result) {
        return new DissolutionRecipeBuilder(result);
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemLike item, int count) {
        return DissolutionRecipeBuilder.dissolutionRecipe(new ItemStack((ItemLike)item.m_5456_(), count));
    }

    public static DissolutionRecipeBuilder dissolutionRecipe(ItemLike item) {
        return DissolutionRecipeBuilder.dissolutionRecipe(item, 1);
    }

    public DissolutionRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public DissolutionRecipeBuilder ingredient(ItemLike item) {
        return this.ingredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public DissolutionRecipeBuilder ingredient(TagKey<Item> tag) {
        return this.ingredient(Ingredient.m_204132_(tag));
    }

    public DissolutionRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public DissolutionRecipeBuilder manaCost(SourceList mana) {
        this.manaCosts = mana.copy();
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredient defined for dissolution recipe " + id + "!");
        }
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.ingredient, this.group, this.manaCosts));
    }

    public static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final ItemStack result;
        protected final Ingredient ingredient;
        protected final String group;
        protected final SourceList manaCosts;

        public Result(ResourceLocation id, ItemStack result, Ingredient ingredient, String group, SourceList manaCosts) {
            this.id = id;
            this.result = result;
            this.ingredient = ingredient;
            this.group = group;
            this.manaCosts = manaCosts;
        }

        public void m_7917_(JsonObject json) {
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.manaCosts != null && !this.manaCosts.isEmpty()) {
                JsonObject manaJson = new JsonObject();
                for (Source source : this.manaCosts.getSourcesSorted()) {
                    manaJson.addProperty(source.getTag(), (Number)this.manaCosts.getAmount(source));
                }
                json.add("mana", (JsonElement)manaJson);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
            resultJson.addProperty("count", (Number)this.result.m_41613_());
            if (this.result.m_41782_()) {
                resultJson.addProperty("nbt", this.result.m_41783_().toString());
            }
            json.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializersPM.DISSOLUTION.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return new ResourceLocation("");
        }
    }
}

