/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualRecipeBuilder {
    protected final ItemStack result;
    protected final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    protected final List<BlockIngredient> props = new ArrayList<BlockIngredient>();
    protected String group;
    protected CompoundResearchKey research;
    protected SourceList manaCosts;
    protected int instability = 0;

    protected RitualRecipeBuilder(ItemStack result) {
        this.result = result.m_41777_();
    }

    public static RitualRecipeBuilder ritualRecipe(ItemLike result, int count) {
        return new RitualRecipeBuilder(new ItemStack(result, count));
    }

    public static RitualRecipeBuilder ritualRecipe(ItemLike result) {
        return RitualRecipeBuilder.ritualRecipe(result, 1);
    }

    public static RitualRecipeBuilder ritualRecipe(ItemStack result) {
        return new RitualRecipeBuilder(result);
    }

    public RitualRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int index = 0; index < quantity; ++index) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public RitualRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public RitualRecipeBuilder addIngredient(ItemLike item, int quantity) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
    }

    public RitualRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public RitualRecipeBuilder addIngredient(TagKey<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.m_204132_(tag), quantity);
    }

    public RitualRecipeBuilder addIngredient(TagKey<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public RitualRecipeBuilder addIngredientNbtPartial(CompoundTag nbt, ItemLike ... items) {
        return this.addIngredient((Ingredient)PartialNBTIngredient.of((CompoundTag)nbt, (ItemLike[])items));
    }

    public RitualRecipeBuilder addProp(BlockIngredient ingredient, int quantity) {
        for (int index = 0; index < quantity; ++index) {
            this.props.add(ingredient);
        }
        return this;
    }

    public RitualRecipeBuilder addProp(BlockIngredient ingredient) {
        return this.addProp(ingredient, 1);
    }

    public RitualRecipeBuilder addProp(Block block, int quantity) {
        return this.addProp(BlockIngredient.fromBlocks(block), quantity);
    }

    public RitualRecipeBuilder addProp(Block block) {
        return this.addProp(block, 1);
    }

    public RitualRecipeBuilder addProp(TagKey<Block> tag, int quantity) {
        return this.addProp(BlockIngredient.fromTag(tag), quantity);
    }

    public RitualRecipeBuilder addProp(TagKey<Block> tag) {
        return this.addProp(tag, 1);
    }

    public RitualRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public RitualRecipeBuilder research(CompoundResearchKey research) {
        this.research = research.copy();
        return this;
    }

    public RitualRecipeBuilder research(Optional<CompoundResearchKey> researchOpt) {
        return this.research(researchOpt.orElseThrow());
    }

    public RitualRecipeBuilder manaCost(SourceList mana) {
        this.manaCosts = mana.copy();
        return this;
    }

    public RitualRecipeBuilder instability(int instability) {
        this.instability = instability;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.group == null ? "" : this.group, this.ingredients, this.props, this.research, this.manaCosts, this.instability));
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
        if (saveLoc.equals((Object)id)) {
            throw new IllegalStateException("Ritual Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumer, saveLoc);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()));
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for ritual recipe " + id + "!");
        }
        if (this.research == null) {
            throw new IllegalStateException("No research is defined for ritual recipe " + id + "!");
        }
        if (this.instability < 0 || this.instability > 10) {
            throw new IllegalStateException("Instability out of bounds for ritual recipe " + id + "!");
        }
    }

    public static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final ItemStack result;
        protected final String group;
        protected final List<Ingredient> ingredients;
        protected final List<BlockIngredient> props;
        protected final CompoundResearchKey research;
        protected final SourceList manaCosts;
        protected final int instability;

        public Result(ResourceLocation id, ItemStack result, String group, List<Ingredient> ingredients, List<BlockIngredient> props, CompoundResearchKey research, SourceList manaCosts, int instability) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.ingredients = ingredients;
            this.props = props;
            this.research = research;
            this.manaCosts = manaCosts;
            this.instability = instability;
        }

        public void m_7917_(JsonObject json) {
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.research != null) {
                json.addProperty("research", this.research.toString());
            }
            if (this.manaCosts != null && !this.manaCosts.isEmpty()) {
                JsonObject manaJson = new JsonObject();
                for (Source source : this.manaCosts.getSourcesSorted()) {
                    manaJson.addProperty(source.getTag(), (Number)this.manaCosts.getAmount(source));
                }
                json.add("mana", (JsonElement)manaJson);
            }
            json.addProperty("instability", (Number)this.instability);
            JsonArray ingredientsJson = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientsJson.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredientsJson);
            if (this.props != null && !this.props.isEmpty()) {
                JsonArray propsJson = new JsonArray();
                for (BlockIngredient prop : this.props) {
                    propsJson.add(prop.serialize());
                }
                json.add("props", (JsonElement)propsJson);
            }
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                resultJson.addProperty("count", (Number)this.result.m_41613_());
            }
            if (this.result.m_41782_()) {
                resultJson.addProperty("nbt", this.result.m_41783_().toString());
            }
            json.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializersPM.RITUAL.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return new ResourceLocation("");
        }
    }
}

