/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class RunecarvingRecipeBuilder {
    protected final Item result;
    protected final int count;
    protected Ingredient ingredient1;
    protected Ingredient ingredient2;
    protected String group;
    protected CompoundResearchKey research;

    protected RunecarvingRecipeBuilder(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
    }

    public static RunecarvingRecipeBuilder runecarvingRecipe(ItemLike item, int count) {
        return new RunecarvingRecipeBuilder(item, count);
    }

    public static RunecarvingRecipeBuilder runecarvingRecipe(ItemLike item) {
        return new RunecarvingRecipeBuilder(item, 1);
    }

    public RunecarvingRecipeBuilder firstIngredient(Ingredient ingredient) {
        this.ingredient1 = ingredient;
        return this;
    }

    public RunecarvingRecipeBuilder firstIngredient(ItemLike item) {
        return this.firstIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RunecarvingRecipeBuilder firstIngredient(TagKey<Item> tag) {
        return this.firstIngredient(Ingredient.m_204132_(tag));
    }

    public RunecarvingRecipeBuilder secondIngredient(Ingredient ingredient) {
        this.ingredient2 = ingredient;
        return this;
    }

    public RunecarvingRecipeBuilder secondIngredient(ItemLike item) {
        return this.secondIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RunecarvingRecipeBuilder secondIngredient(TagKey<Item> tag) {
        return this.secondIngredient(Ingredient.m_204132_(tag));
    }

    public RunecarvingRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public RunecarvingRecipeBuilder research(CompoundResearchKey research) {
        this.research = research.copy();
        return this;
    }

    public RunecarvingRecipeBuilder research(Optional<CompoundResearchKey> researchOpt) {
        return this.research(researchOpt.orElseThrow());
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredient1, this.ingredient2, this.research));
    }

    public void build(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)this.result);
        if (saveLoc.equals((Object)id)) {
            throw new IllegalStateException("Runecarving Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumer, saveLoc);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result));
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredient1 == null || this.ingredient1.m_43947_() || this.ingredient2 == null || this.ingredient2.m_43947_()) {
            throw new IllegalStateException("Missing ingredient for runecarving recipe " + id + "!");
        }
        if (this.research == null) {
            throw new IllegalStateException("No research is defined for runecarving recipe " + id + "!");
        }
    }

    public static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final Item result;
        protected final int count;
        protected final String group;
        protected final Ingredient ingredient1;
        protected final Ingredient ingredient2;
        protected final CompoundResearchKey research;

        public Result(ResourceLocation id, Item result, int count, String group, Ingredient ing1, Ingredient ing2, CompoundResearchKey research) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.ingredient1 = ing1;
            this.ingredient2 = ing2;
            this.research = research;
        }

        public void m_7917_(JsonObject json) {
            if (this.group != null && !this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.research != null) {
                json.addProperty("research", this.research.toString());
            }
            json.add("ingredient1", this.ingredient1.m_43942_());
            json.add("ingredient2", this.ingredient2.m_43942_());
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RecipeSerializersPM.RUNECARVING.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return new ResourceLocation("");
        }
    }
}

