/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.runes;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.datagen.runes.IFinishedRuneEnchantment;
import com.verdantartifice.primalmagick.datagen.runes.RuneEnchantmentBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuneEnchantmentProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput packOutput;
    protected final Set<ResourceLocation> registeredEnchantments = new HashSet<ResourceLocation>();

    public RuneEnchantmentProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        HashMap map = new HashMap();
        this.registerEnchantments(enchantment -> {
            if (map.put(enchantment.getId(), enchantment) != null) {
                LOGGER.debug("Duplicate rune enchantment definition in data generation: {}", (Object)enchantment.getId().toString());
            }
            this.registeredEnchantments.add(enchantment.getId());
        });
        map.entrySet().forEach(entry -> futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((IFinishedRuneEnchantment)entry.getValue()).getEnchantmentJson(), (Path)this.getPath(this.packOutput, (ResourceLocation)entry.getKey()))));
        this.checkExpectations();
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private Path getPath(PackOutput output, ResourceLocation entryLoc) {
        return output.m_247566_(PackOutput.Target.DATA_PACK).resolve(entryLoc.m_135827_()).resolve("rune_enchantments").resolve(entryLoc.m_135815_() + ".json");
    }

    private void registerEmptyEnchantment(Enchantment ench) {
        this.registeredEnchantments.add(ForgeRegistries.ENCHANTMENTS.getKey((Object)ench));
    }

    private void checkExpectations() {
        HashSet enchantments = new HashSet(ForgeRegistries.ENCHANTMENTS.getKeys());
        enchantments.removeAll(this.registeredEnchantments);
        enchantments.forEach(key -> LOGGER.warn("Missing enchantment rune combination for {}", (Object)key.toString()));
    }

    protected void registerEnchantments(Consumer<IFinishedRuneEnchantment> consumer) {
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44965_).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44966_).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.INFERNAL).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44967_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44968_).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.MOON).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44969_).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44970_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44971_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44972_).verb(Rune.PROJECT).noun(Rune.CREATURE).source(Rune.BLOOD).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44973_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44974_).verb(Rune.PROJECT).noun(Rune.AREA).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44977_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44980_).verb(Rune.PROJECT).noun(Rune.CREATURE).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44981_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.INFERNAL).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44982_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.MOON).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44983_).verb(Rune.PROJECT).noun(Rune.AREA).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44984_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44985_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44986_).verb(Rune.PROTECT).noun(Rune.ITEM).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44987_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.MOON).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44988_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44989_).verb(Rune.PROJECT).noun(Rune.CREATURE).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44990_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.INFERNAL).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44952_).verb(Rune.SUMMON).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44953_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.MOON).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44954_).verb(Rune.SUMMON).noun(Rune.CREATURE).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44955_).verb(Rune.SUMMON).noun(Rune.ITEM).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44956_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44957_).verb(Rune.SUMMON).noun(Rune.SELF).source(Rune.SEA).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44958_).verb(Rune.SUMMON).noun(Rune.AREA).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44959_).verb(Rune.SUMMON).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44960_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44961_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44962_).verb(Rune.ABSORB).noun(Rune.ITEM).source(Rune.SUN).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44979_).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.BLOOD).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44978_).verb(Rune.PROJECT).noun(Rune.CREATURE).source(Rune.SUN).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_44976_).verb(Rune.PROJECT).noun(Rune.SELF).source(Rune.INFERNAL).build(consumer);
        RuneEnchantmentBuilder.enchantment(Enchantments.f_220304_).verb(Rune.PROJECT).noun(Rune.SELF).source(Rune.SKY).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.LIFESTEAL.get()).verb(Rune.ABSORB).noun(Rune.SELF).source(Rune.BLOOD).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.ENDERLOCK.get()).verb(Rune.DISPEL).noun(Rune.CREATURE).source(Rune.VOID).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.JUDGMENT.get()).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.HALLOWED).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.ENDERPORT.get()).verb(Rune.SUMMON).noun(Rune.SELF).source(Rune.VOID).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.REGROWTH.get()).verb(Rune.ABSORB).noun(Rune.ITEM).source(Rune.HALLOWED).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.AEGIS.get()).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.HALLOWED).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.MANA_EFFICIENCY.get()).verb(Rune.DISPEL).noun(Rune.ITEM).source(Rune.VOID).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.SPELL_POWER.get()).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.VOID).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.TREASURE.get()).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.MOON).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.BLUDGEONING.get()).verb(Rune.PROJECT).noun(Rune.ITEM).source(Rune.EARTH).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.REVERBERATION.get()).verb(Rune.PROJECT).noun(Rune.AREA).source(Rune.EARTH).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "PRIMAL_SHOVEL", "RUNE_PROJECT", "RUNE_AREA", "RUNE_EARTH")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.BOUNTY.get()).verb(Rune.SUMMON).noun(Rune.AREA).source(Rune.SEA).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "PRIMAL_FISHING_ROD", "RUNE_SUMMON", "RUNE_AREA", "RUNE_SEA")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.DISINTEGRATION.get()).verb(Rune.PROJECT).noun(Rune.AREA).source(Rune.SKY).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "PRIMAL_AXE", "RUNE_PROJECT", "RUNE_AREA", "RUNE_SKY")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.VERDANT.get()).verb(Rune.SUMMON).noun(Rune.CREATURE).source(Rune.SUN).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "PRIMAL_HOE", "RUNE_SUMMON", "RUNE_CREATURE", "RUNE_SUN")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.LUCKY_STRIKE.get()).verb(Rune.SUMMON).noun(Rune.ITEM).source(Rune.MOON).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "PRIMAL_PICKAXE", "RUNE_SUMMON", "RUNE_ITEM", "RUNE_MOON")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.RENDING.get()).verb(Rune.PROJECT).noun(Rune.CREATURE).source(Rune.BLOOD).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "FORBIDDEN_TRIDENT", "RUNE_PROJECT", "RUNE_CREATURE", "RUNE_BLOOD")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.SOULPIERCING.get()).verb(Rune.ABSORB).noun(Rune.CREATURE).source(Rune.INFERNAL).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "FORBIDDEN_BOW", "RUNE_ABSORB", "RUNE_CREATURE", "RUNE_INFERNAL")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.ESSENCE_THIEF.get()).verb(Rune.SUMMON).noun(Rune.ITEM).source(Rune.VOID).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "FORBIDDEN_SWORD", "RUNE_SUMMON", "RUNE_ITEM", "RUNE_VOID")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.BULWARK.get()).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.HALLOWED).requiredResearch(CompoundResearchKey.from(true, "MASTER_RUNEWORKING", "SACRED_SHIELD", "RUNE_PROTECT", "RUNE_SELF", "RUNE_HALLOWED")).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.MAGICK_PROTECTION.get()).verb(Rune.PROTECT).noun(Rune.SELF).source(Rune.VOID).build(consumer);
        RuneEnchantmentBuilder.enchantment((Enchantment)EnchantmentsPM.GUILLOTINE.get()).verb(Rune.DISPEL).noun(Rune.CREATURE).source(Rune.BLOOD).build(consumer);
        this.registerEmptyEnchantment(Enchantments.f_44975_);
        this.registerEmptyEnchantment(Enchantments.f_44963_);
    }

    public String m_6055_() {
        return "Primal Magick Rune Enchantment Definitions";
    }
}

