/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.sounds;

import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundDefinitionsProviderPM
extends SoundDefinitionsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ResourceLocation> generatedSounds = new ArrayList<ResourceLocation>();

    public SoundDefinitionsProviderPM(PackOutput output, ExistingFileHelper helper) {
        super(output, "primalmagick", helper);
    }

    public void registerSounds() {
        this.addSingle(SoundsPM.PAGE);
        this.addSingle(SoundsPM.POOF);
        this.addSingle(SoundsPM.SCAN);
        this.addMultiple(SoundsPM.ROCKSLIDE, 3);
        this.addMultiple(SoundsPM.ICE, 3);
        this.addSingle(SoundsPM.ELECTRIC);
        this.addMultiple(SoundsPM.SUNBEAM, 3);
        this.addSingle(SoundsPM.MOONBEAM);
        this.addSingle(SoundsPM.BLOOD);
        this.addSingle(SoundsPM.WHISPERS);
        this.addSingle(SoundsPM.ANGELS);
        this.addSingle(SoundsPM.HEAL);
        this.addSingle(SoundsPM.WINGFLAP);
        this.addMultiple(SoundsPM.COINS, 3);
        this.addSingle(SoundsPM.EGG_CRACK);
        this.addSingle(SoundsPM.SHIMMER);
        this.addSingle(SoundsPM.WRITING);
        this.addMultiple(SoundsPM.TREEFOLK_HURT, 3);
        this.addMultiple(SoundsPM.TREEFOLK_DEATH, 2);
        this.addMultiple(SoundsPM.CLANK, 3);
        this.addSingle(SoundsPM.HARP);
        this.addSingle(SoundsPM.RITUAL);
        this.verifyComplete();
    }

    private void addSingle(RegistryObject<SoundEvent> eventSupplier) {
        this.add((Supplier)eventSupplier, SoundDefinitionsProviderPM.definition().with(SoundDefinitionsProviderPM.sound((ResourceLocation)eventSupplier.getId())));
    }

    private void addMultiple(RegistryObject<SoundEvent> eventSupplier, int count) {
        SoundDefinition def = SoundDefinitionsProviderPM.definition();
        IntStream.rangeClosed(1, count).forEach(val -> def.with(SoundDefinitionsProviderPM.sound((ResourceLocation)eventSupplier.getId().m_266382_(Integer.toString(val)))));
        this.add((Supplier)eventSupplier, def);
    }

    protected void add(ResourceLocation soundEvent, SoundDefinition definition) {
        super.add(soundEvent, definition);
        this.generatedSounds.add(soundEvent);
    }

    protected void verifyComplete() {
        ArrayList<ResourceLocation> registeredSounds = new ArrayList<ResourceLocation>(ForgeRegistries.SOUND_EVENTS.getKeys().stream().filter(loc -> loc.m_135827_().equals("primalmagick")).toList());
        registeredSounds.removeAll(this.generatedSounds);
        if (!registeredSounds.isEmpty()) {
            registeredSounds.forEach(loc -> LOGGER.warn("No sound definition generated for sound {}", (Object)loc.toString()));
            throw new IllegalStateException("Missing sound definitions for primalmagick");
        }
    }
}

