/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.theorycrafting;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.datagen.theorycrafting.IFinishedProjectMaterial;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemMaterialBuilder {
    protected final ItemStack stack;
    protected final boolean consumed;
    protected boolean matchNBT = false;
    protected double weight = 1.0;
    protected int afterCrafting = 0;
    protected double bonusReward = 0.0;
    protected CompoundResearchKey requiredResearch;

    protected ItemMaterialBuilder(@Nonnull ItemStack stack, boolean consumed) {
        this.stack = stack.m_41777_();
        this.consumed = consumed;
    }

    public static ItemMaterialBuilder item(@Nonnull ItemLike item, boolean consumed) {
        return ItemMaterialBuilder.item(item, 1, null, consumed);
    }

    public static ItemMaterialBuilder item(@Nonnull ItemLike item, int count, boolean consumed) {
        return ItemMaterialBuilder.item(item, count, null, consumed);
    }

    public static ItemMaterialBuilder item(@Nonnull ItemLike item, int count, @Nullable CompoundTag nbt, boolean consumed) {
        ItemStack stack = new ItemStack(item, count);
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return ItemMaterialBuilder.item(stack, consumed);
    }

    public static ItemMaterialBuilder item(@Nonnull ItemStack stack, boolean consumed) {
        return new ItemMaterialBuilder(stack, consumed);
    }

    public ItemMaterialBuilder weight(double weight) {
        this.weight = weight;
        return this;
    }

    public ItemMaterialBuilder matchNbt() {
        this.matchNBT = true;
        return this;
    }

    public ItemMaterialBuilder requiredResearch(@Nullable CompoundResearchKey key) {
        this.requiredResearch = key.copy();
        return this;
    }

    public ItemMaterialBuilder requiredResearch(@Nullable SimpleResearchKey key) {
        return this.requiredResearch(CompoundResearchKey.from(key));
    }

    public ItemMaterialBuilder requiredResearch(@Nullable String keyStr) {
        return this.requiredResearch(CompoundResearchKey.parse(keyStr));
    }

    public ItemMaterialBuilder afterCrafting(int after) {
        this.afterCrafting = after;
        return this;
    }

    public ItemMaterialBuilder bonusReward(double bonus) {
        this.bonusReward = bonus;
        return this;
    }

    private void validate() {
        if (this.stack == null || this.stack == ItemStack.f_41583_) {
            throw new IllegalStateException("No item stack for item project material");
        }
        if (this.weight <= 0.0) {
            throw new IllegalStateException("Invalid weight for item project material");
        }
        if (this.afterCrafting < 0) {
            throw new IllegalStateException("Invalid minimum craft count value for item project material");
        }
        if (this.bonusReward < 0.0) {
            throw new IllegalStateException("Invalid bonus reward for item project material");
        }
    }

    public IFinishedProjectMaterial build() {
        this.validate();
        return new Result(this.stack, this.consumed, this.matchNBT, this.weight, this.afterCrafting, this.bonusReward, this.requiredResearch);
    }

    public static class Result
    implements IFinishedProjectMaterial {
        protected final ItemStack stack;
        protected final boolean consumed;
        protected final boolean matchNBT;
        protected final double weight;
        protected final int afterCrafting;
        protected final double bonusReward;
        protected final CompoundResearchKey requiredResearch;

        public Result(@Nonnull ItemStack stack, boolean consumed, boolean matchNBT, double weight, int afterCrafting, double bonusReward, @Nullable CompoundResearchKey requiredResearch) {
            this.stack = stack.m_41777_();
            this.consumed = consumed;
            this.matchNBT = matchNBT;
            this.weight = weight;
            this.afterCrafting = afterCrafting;
            this.bonusReward = bonusReward;
            this.requiredResearch = requiredResearch == null ? null : requiredResearch.copy();
        }

        @Override
        public void serialize(JsonObject json) {
            json.addProperty("type", "item");
            json.addProperty("stack", ItemUtils.serializeItemStack(this.stack));
            json.addProperty("consumed", Boolean.valueOf(this.consumed));
            json.addProperty("match_nbt", Boolean.valueOf(this.matchNBT));
            json.addProperty("weight", (Number)this.weight);
            if (this.afterCrafting > 0) {
                json.addProperty("after_crafting", (Number)this.afterCrafting);
            }
            if (this.bonusReward > 0.0) {
                json.addProperty("bonus_reward", (Number)this.bonusReward);
            }
            if (this.requiredResearch != null) {
                json.addProperty("required_research", this.requiredResearch.toString());
            }
        }
    }
}

