/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.theorycrafting;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.datagen.theorycrafting.IFinishedProjectReward;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemRewardBuilder {
    protected final ItemStack stack;

    protected ItemRewardBuilder(@Nonnull ItemStack stack) {
        this.stack = stack.m_41777_();
    }

    public static ItemRewardBuilder item(@Nonnull ItemStack stack) {
        return new ItemRewardBuilder(stack);
    }

    public static ItemRewardBuilder item(@Nonnull ItemLike item, int count) {
        return ItemRewardBuilder.item(new ItemStack((ItemLike)item.m_5456_(), count));
    }

    public static ItemRewardBuilder item(@Nonnull ItemLike item) {
        return ItemRewardBuilder.item(item, 1);
    }

    private void validate() {
        if (this.stack == null || this.stack == ItemStack.f_41583_) {
            throw new IllegalStateException("No item stack for item project reward");
        }
    }

    public IFinishedProjectReward build() {
        this.validate();
        return new Result(this.stack);
    }

    public static class Result
    implements IFinishedProjectReward {
        protected final ItemStack stack;

        public Result(@Nonnull ItemStack stack) {
            this.stack = stack.m_41777_();
        }

        @Override
        public void serialize(JsonObject json) {
            json.addProperty("type", "item");
            json.addProperty("stack", ItemUtils.serializeItemStack(this.stack));
        }
    }
}

