/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.theorycrafting;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.datagen.theorycrafting.IFinishedProjectMaterial;
import javax.annotation.Nullable;

public class ObservationMaterialBuilder {
    protected final int count;
    protected final boolean consumed;
    protected double weight = 1.0;
    protected double bonusReward = 0.0;
    protected CompoundResearchKey requiredResearch;

    protected ObservationMaterialBuilder(int count, boolean consumed) {
        this.count = count;
        this.consumed = consumed;
    }

    public static ObservationMaterialBuilder observation(int count, boolean consumed) {
        return new ObservationMaterialBuilder(count, consumed);
    }

    public ObservationMaterialBuilder weight(double weight) {
        this.weight = weight;
        return this;
    }

    public ObservationMaterialBuilder requiredResearch(@Nullable CompoundResearchKey key) {
        this.requiredResearch = key;
        return this;
    }

    public ObservationMaterialBuilder requiredResearch(@Nullable SimpleResearchKey key) {
        return this.requiredResearch(CompoundResearchKey.from(key));
    }

    public ObservationMaterialBuilder requiredResearch(@Nullable String keyStr) {
        return this.requiredResearch(CompoundResearchKey.parse(keyStr));
    }

    public ObservationMaterialBuilder bonusReward(double bonus) {
        this.bonusReward = bonus;
        return this;
    }

    private void validate() {
        if (this.count <= 0) {
            throw new IllegalStateException("Invalid observation count for observation project material");
        }
        if (this.weight <= 0.0) {
            throw new IllegalStateException("Invalid weight for observation project material");
        }
        if (this.bonusReward < 0.0) {
            throw new IllegalStateException("Invalid bonus reward for observation project material");
        }
    }

    public IFinishedProjectMaterial build() {
        this.validate();
        return new Result(this.count, this.consumed, this.weight, this.bonusReward, this.requiredResearch);
    }

    public static class Result
    implements IFinishedProjectMaterial {
        protected final int count;
        protected final boolean consumed;
        protected final double weight;
        protected final double bonusReward;
        protected final CompoundResearchKey requiredResearch;

        public Result(int count, boolean consumed, double weight, double bonusReward, @Nullable CompoundResearchKey requiredResearch) {
            this.count = count;
            this.consumed = consumed;
            this.weight = weight;
            this.bonusReward = bonusReward;
            this.requiredResearch = requiredResearch == null ? null : requiredResearch.copy();
        }

        @Override
        public void serialize(JsonObject json) {
            json.addProperty("type", "observation");
            json.addProperty("count", (Number)this.count);
            json.addProperty("consumed", Boolean.valueOf(this.consumed));
            json.addProperty("weight", (Number)this.weight);
            if (this.bonusReward > 0.0) {
                json.addProperty("bonus_reward", (Number)this.bonusReward);
            }
            if (this.requiredResearch != null) {
                json.addProperty("required_research", this.requiredResearch.toString());
            }
        }
    }
}

