/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.datagen.theorycrafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.QuorumResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tags.ItemTagsForgeExt;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ConstantWeightFunctionBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ExperienceMaterialBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ExperienceRewardBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.IFinishedProject;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ItemMaterialBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ItemRewardBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ItemTagMaterialBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.LootTableRewardBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ObservationMaterialBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ProgressiveWeightFunctionBuilder;
import com.verdantartifice.primalmagick.datagen.theorycrafting.ProjectBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final PackOutput packOutput;

    public ProjectProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        HashMap map = new HashMap();
        this.registerProjects(project -> {
            if (map.put(project.getId(), project) != null) {
                LOGGER.debug("Duplicate theorycrafting project in data generation: {}", (Object)project.getId().toString());
            }
        });
        map.entrySet().forEach(entry -> futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((IFinishedProject)entry.getValue()).getProjectJson(), (Path)this.getPath(this.packOutput, (ResourceLocation)entry.getKey()))));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private Path getPath(PackOutput output, ResourceLocation entryLoc) {
        return output.m_247566_(PackOutput.Target.DATA_PACK).resolve(entryLoc.m_135827_()).resolve("theorycrafting").resolve(entryLoc.m_135815_() + ".json");
    }

    protected void registerProjects(Consumer<IFinishedProject> consumer) {
        SimpleResearchKey shardSynthesis = ((ResearchName)ResearchNames.SHARD_SYNTHESIS.get()).simpleKey();
        ProjectBuilder.project("advanced_enchanting_studies").rewardMultiplier(0.5).requiredResearch(CompoundResearchKey.from(true, "EXPERT_MANAWEAVING", "PRIMALITE")).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("MASTER_MANAWEAVING", -1.0).modifier("SUPREME_MANAWEAVING", -1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.ENCHANTING_TABLES, false).weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, 2, true).weight(5.0).build()).material(ExperienceMaterialBuilder.experience(2, true).bonusReward(0.25).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_SWORD.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_PICKAXE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_SHOVEL.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_AXE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_HOE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_HEAD.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_CHEST.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_LEGS.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_FEET.get(), false).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("advanced_essence_analysis").requiredResearch("CRYSTAL_SYNTHESIS").rewardMultiplier(0.5).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("CLUSTER_SYNTHESIS", -2.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_EARTH.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SEA.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SKY.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SUN.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_MOON.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_HALLOWED.get(), true).requiredResearch(Source.HALLOWED.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_EARTH.get(), true).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SEA.get(), true).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SKY.get(), true).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SUN.get(), true).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_MOON.get(), true).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get(), true).requiredResearch(Source.HALLOWED.getDiscoverKey()).afterCrafting(5).bonusReward(0.25).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("advanced_ritual_practice").rewardMultiplier(0.5).requiredResearch(QuorumResearchKey.builder(2).add("RITUAL_LECTERN", "RITUAL_BELL", "PRIMAL_SHOVEL", "PRIMAL_FISHING_ROD", "PRIMAL_AXE", "PRIMAL_HOE", "PRIMAL_PICKAXE").build()).weightFunction(ProgressiveWeightFunctionBuilder.start(3.0).modifier("BASIC_RITUAL", 1.0).modifier("EXPERT_RITUAL", 1.0).modifier("MASTER_RITUAL", -1.0).modifier("SUPREME_RITUAL", -1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RITUAL_ALTAR.get(), false).weight(10.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.OFFERING_PEDESTAL.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.REFINED_SALT.get(), 2, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RITUAL_LECTERN.get(), false).requiredResearch("RITUAL_LECTERN").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42690_, false).requiredResearch("RITUAL_LECTERN").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RITUAL_BELL.get(), false).requiredResearch("RITUAL_BELL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_SHOVEL.get(), true).requiredResearch("PRIMAL_SHOVEL").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_EARTH.get(), true).requiredResearch("PRIMAL_SHOVEL").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_FISHING_ROD.get(), true).requiredResearch("PRIMAL_FISHING_ROD").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SEA.get(), true).requiredResearch("PRIMAL_FISHING_ROD").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_AXE.get(), true).requiredResearch("PRIMAL_AXE").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SKY.get(), true).requiredResearch("PRIMAL_AXE").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_HOE.get(), true).requiredResearch("PRIMAL_HOE").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SUN.get(), true).requiredResearch("PRIMAL_HOE").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.PRIMALITE_PICKAXE.get(), true).requiredResearch("PRIMAL_PICKAXE").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_MOON.get(), true).requiredResearch("PRIMAL_PICKAXE").bonusReward(0.25).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("advanced_runework").rewardMultiplier(0.5).requiredResearch(QuorumResearchKey.builder(3).add("RUNE_BLOOD", "RUNE_INFERNAL", "RUNE_VOID", "RUNE_ABSORB", "RUNE_DISPEL", "RUNE_SUMMON", "RUNE_AREA", "RUNE_CREATURE", "RUNE_INSIGHT").build()).weightFunction(ProgressiveWeightFunctionBuilder.start(3.0).modifier("BASIC_RUNEWORKING", 1.0).modifier("EXPERT_RUNEWORKING", 1.0).modifier("MASTER_RUNEWORKING", -1.0).modifier("SUPREME_RUNEWORKING", -1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNECARVING_TABLE.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41922_, 2, true).weight(3.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, 2, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42388_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_BLOOD.get(), true).requiredResearch("RUNE_BLOOD").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_INFERNAL.get(), true).requiredResearch("RUNE_INFERNAL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_VOID.get(), true).requiredResearch("RUNE_VOID").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_INSIGHT.get(), true).requiredResearch("RUNE_INSIGHT").bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_ABSORB.get(), true).requiredResearch("RUNE_ABSORB").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_DISPEL.get(), true).requiredResearch("RUNE_DISPEL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SUMMON.get(), true).requiredResearch("RUNE_SUMMON").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_AREA.get(), true).requiredResearch("RUNE_AREA").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_CREATURE.get(), true).requiredResearch("RUNE_CREATURE").weight(1.0).build()).build(consumer);
        ProjectBuilder.project("advanced_spellwork").rewardMultiplier(0.5).requiredResearch(CompoundResearchKey.from(true, "EXPERT_SORCERY", "SHARD_SYNTHESIS")).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("MASTER_SORCERY", -1.0).modifier("SUPREME_SORCERY", -1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELLCRAFTING_ALTAR.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_INSCRIPTION_TABLE.get(), false).requiredResearch("WAND_INSCRIPTION").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.AUTO_CHARGER.get(), false).requiredResearch("AUTO_CHARGER").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MUNDANE_WAND.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELL_SCROLL_BLANK.get(), 2, true).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_EARTH.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SEA.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SKY.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SUN.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_MOON.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("advanced_wand_tinkering").rewardMultiplier(0.5).requiredResearch("MASTER_MANAWEAVING").weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_ASSEMBLY_TABLE.get(), false).requiredResearch("ADVANCED_WANDMAKING").weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_GLAMOUR_TABLE.get(), false).requiredResearch("WAND_GLAMOUR_TABLE").weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEARTWOOD.get(), 2, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.BONES, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.RODS_BLAZE, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42004_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.INGOTS_PRIMALITE, true).requiredResearch("PRIMALITE").weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.INGOTS_HEXIUM, true).requiredResearch("HEXIUM").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("apiamancy").aid(Blocks.f_50718_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13145_, true).weight(1.0).build()).otherReward(ItemRewardBuilder.item((ItemLike)Items.f_42784_, 3).build()).build(consumer);
        ProjectBuilder.project("beacon_emanations").aid(Blocks.f_50273_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13164_, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("brewing_experiments").rewardMultiplier(0.5).requiredResearch(Source.INFERNAL.getDiscoverKey()).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42543_, false).weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_NETHER_WART, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42592_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42501_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42648_, true).bonusReward(0.25).weight(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42593_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42546_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42591_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42586_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42542_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42529_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42677_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42354_, true).bonusReward(0.25).weight(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42714_, true).bonusReward(0.25).weight(0.5).build()).material(ObservationMaterialBuilder.observation(1, true).weight(3.0).build()).build(consumer);
        ProjectBuilder.project("conduit_forces").aid(Blocks.f_50569_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_PRISMARINE, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("draconic_energies").aid(Blocks.f_50260_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(1.0).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.ENDER_PEARLS, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("draconic_memories").aid(Blocks.f_50320_).aid(Blocks.f_50321_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ExperienceMaterialBuilder.experience(3, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("enchanting_studies").requiredResearch("BASIC_MANAWEAVING").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("EXPERT_MANAWEAVING", -1.0).modifier("MASTER_MANAWEAVING", -1.0).modifier("SUPREME_MANAWEAVING", -2.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.ENCHANTING_TABLES, false).weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, true).weight(5.0).build()).material(ExperienceMaterialBuilder.experience(1, true).bonusReward(0.125).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42430_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42432_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42431_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42433_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42434_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42476_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42477_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42478_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42479_, false).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("end_expedition").requiredResearch(Source.VOID.getDiscoverKey()).rewardMultiplier(1.0).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42393_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42717_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42412_, 32, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42481_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42676_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42771_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42000_, 32, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42406_, 8, true).weight(1.0).build()).material(ItemMaterialBuilder.item(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43596_), true).bonusReward(0.5).weight(1.0).matchNbt().build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.ENDER_PEARLS, 4, true).bonusReward(0.5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42545_, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("essence_analysis").requiredResearch("BASIC_ALCHEMY").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("CRYSTAL_SYNTHESIS", -2.0).modifier("CLUSTER_SYNTHESIS", -2.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_EARTH.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SEA.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SKY.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SUN.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_MOON.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_HALLOWED.get(), true).requiredResearch(Source.HALLOWED.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_EARTH.get(), true).requiredResearch(shardSynthesis).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SEA.get(), true).requiredResearch(shardSynthesis).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SKY.get(), true).requiredResearch(shardSynthesis).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_SUN.get(), true).requiredResearch(shardSynthesis).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_MOON.get(), true).requiredResearch(shardSynthesis).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_BLOOD.get(), true).requiredResearch(CompoundResearchKey.from(true, shardSynthesis, Source.BLOOD.getDiscoverKey())).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_INFERNAL.get(), true).requiredResearch(CompoundResearchKey.from(true, shardSynthesis, Source.INFERNAL.getDiscoverKey())).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_VOID.get(), true).requiredResearch(CompoundResearchKey.from(true, shardSynthesis, Source.VOID.getDiscoverKey())).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_HALLOWED.get(), true).requiredResearch(CompoundResearchKey.from(true, shardSynthesis, Source.HALLOWED.getDiscoverKey())).afterCrafting(5).bonusReward(0.125).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("expedition").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier(Source.INFERNAL.getDiscoverKey(), -2.0).modifier(Source.VOID.getDiscoverKey(), -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42383_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42411_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42412_, 4, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42469_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42676_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42522_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42524_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42771_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42781_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42000_, 4, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42406_, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("hit_the_books").aid(Blocks.f_50078_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, false).weight(1.0).build()).otherReward(ExperienceRewardBuilder.points(5).build()).build(consumer);
        ProjectBuilder.project("magitech_tinkering").rewardMultiplier(0.5).requiredResearch(QuorumResearchKey.builder(3).add("ARCANOMETER", "CONCOCTING_TINCTURES", "ENTROPY_SINK", "AUTO_CHARGER", "ESSENCE_TRANSMUTER", "DISSOLUTION_CHAMBER", "INFERNAL_FURNACE").build()).weightFunction(ProgressiveWeightFunctionBuilder.start(3.0).modifier("MASTER_MAGITECH", 2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MAGITECH_PARTS_BASIC.get(), true).bonusReward(0.125).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MAGITECH_PARTS_ENCHANTED.get(), true).requiredResearch("EXPERT_MAGITECH").bonusReward(0.25).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MAGITECH_PARTS_FORBIDDEN.get(), true).requiredResearch("MASTER_MAGITECH").bonusReward(0.5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HONEY_EXTRACTOR.get(), false).requiredResearch("HONEY_EXTRACTOR").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ARCANOMETER.get(), false).requiredResearch("ARCANOMETER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.CONCOCTER.get(), false).requiredResearch("CONCOCTING_TINCTURES").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ENTROPY_SINK.get(), false).requiredResearch("ENTROPY_SINK").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.AUTO_CHARGER.get(), false).requiredResearch("AUTO_CHARGER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_TRANSMUTER.get(), false).requiredResearch("ESSENCE_TRANSMUTER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.DISSOLUTION_CHAMBER.get(), false).requiredResearch("DISSOLUTION_CHAMBER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.INFERNAL_FURNACE.get(), false).requiredResearch("INFERNAL_FURNACE").weight(1.0).build()).build(consumer);
        ProjectBuilder.project("master_enchanting_studies").rewardMultiplier(1.0).requiredResearch(CompoundResearchKey.from(true, "MASTER_MANAWEAVING", "HEXIUM")).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.ENCHANTING_TABLES, false).weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, 3, true).weight(5.0).build()).material(ExperienceMaterialBuilder.experience(3, true).bonusReward(0.5).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_SWORD.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_PICKAXE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_SHOVEL.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_AXE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_HOE.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_HEAD.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_CHEST.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_LEGS.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_FEET.get(), false).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("master_essence_analysis").requiredResearch("CLUSTER_SYNTHESIS").rewardMultiplier(1.0).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_EARTH.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SEA.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SKY.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SUN.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_MOON.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get(), true).requiredResearch(Source.HALLOWED.getDiscoverKey()).afterCrafting(5).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_EARTH.get(), true).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_SEA.get(), true).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_SKY.get(), true).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_SUN.get(), true).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_MOON.get(), true).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).afterCrafting(5).weight(1.0).bonusReward(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CLUSTER_HALLOWED.get(), true).requiredResearch(Source.HALLOWED.getDiscoverKey()).afterCrafting(5).bonusReward(0.5).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("master_ritual_practice").rewardMultiplier(1.0).requiredResearch(QuorumResearchKey.builder(2).add("BLOODLETTER", "SOUL_ANVIL", "FORBIDDEN_TRIDENT", "FORBIDDEN_SWORD", "FORBIDDEN_BOW").build()).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RITUAL_ALTAR.get(), false).weight(10.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.OFFERING_PEDESTAL.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.REFINED_SALT.get(), 4, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.BLOODLETTER.get(), false).requiredResearch("BLOODLETTER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42447_, true).requiredResearch("BLOODLETTER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SOUL_ANVIL.get(), false).requiredResearch("SOUL_ANVIL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELLCLOTH.get(), false).requiredResearch("SOUL_ANVIL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_TRIDENT.get(), true).requiredResearch("FORBIDDEN_TRIDENT").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_BLOOD.get(), true).requiredResearch("FORBIDDEN_TRIDENT").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_BOW.get(), true).requiredResearch("FORBIDDEN_BOW").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_INFERNAL.get(), true).requiredResearch("FORBIDDEN_BOW").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEXIUM_SWORD.get(), true).requiredResearch("FORBIDDEN_SWORD").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_SHARD_VOID.get(), true).requiredResearch("FORBIDDEN_SWORD").bonusReward(0.5).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("master_runework").rewardMultiplier(1.0).requiredResearch("RUNE_HALLOWED").weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNECARVING_TABLE.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41922_, 4, true).weight(3.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, 4, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42388_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_HALLOWED.get(), true).requiredResearch("RUNE_HALLOWED").weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_POWER.get(), true).requiredResearch("RUNE_POWER").bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_PROJECT.get(), 2, true).requiredResearch("RUNE_PROJECT").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_PROTECT.get(), 2, true).requiredResearch("RUNE_PROTECT").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_ITEM.get(), 2, true).requiredResearch("RUNE_ITEM").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SELF.get(), 2, true).requiredResearch("RUNE_SELF").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_ABSORB.get(), 2, true).requiredResearch("RUNE_ABSORB").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_DISPEL.get(), 2, true).requiredResearch("RUNE_DISPEL").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SUMMON.get(), 2, true).requiredResearch("RUNE_SUMMON").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_AREA.get(), 2, true).requiredResearch("RUNE_AREA").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_CREATURE.get(), 2, true).requiredResearch("RUNE_CREATURE").weight(1.0).build()).build(consumer);
        ProjectBuilder.project("master_spellwork").rewardMultiplier(1.0).requiredResearch(CompoundResearchKey.from(true, "MASTER_SORCERY", "CRYSTAL_SYNTHESIS")).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELLCRAFTING_ALTAR.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_INSCRIPTION_TABLE.get(), false).requiredResearch("WAND_INSCRIPTION").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MANA_NEXUS.get(), false).requiredResearch("MANA_NEXUS").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELL_SCROLL_BLANK.get(), 4, true).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_EARTH.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SEA.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SKY.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_SUN.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_MOON.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_BLOOD.get(), true).requiredResearch(Source.BLOOD.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get(), true).requiredResearch(Source.INFERNAL.getDiscoverKey()).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_CRYSTAL_VOID.get(), true).requiredResearch(Source.VOID.getDiscoverKey()).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("mundane_tinkering").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("BASIC_MAGITECH", -1.0).modifier("EXPERT_MAGITECH", -1.0).modifier("MASTER_MAGITECH", -1.0).modifier("SUPREME_MAGITECH", -1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41960_, false).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13141_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41962_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42770_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42719_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42769_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42775_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42776_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42773_, false).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("nether_expedition").requiredResearch(Source.INFERNAL.getDiscoverKey()).rewardMultiplier(0.5).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier(Source.VOID.getDiscoverKey(), -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42388_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42717_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42412_, 16, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42473_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42676_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42771_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42000_, 16, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42406_, 4, true).weight(1.0).build()).material(ItemMaterialBuilder.item(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43610_), true).bonusReward(0.25).weight(4.0).matchNbt().build()).material(ItemTagMaterialBuilder.tag(ItemTagsForgeExt.MILK, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.OBSIDIAN, 10, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42409_, false).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("observation_analysis").aid((Block)BlocksPM.ANALYSIS_TABLE.get()).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("piglin_barter").requiredResearch(Source.INFERNAL.getDiscoverKey()).rewardMultiplier(1.0).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42777_, true).weight(0.5).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD, true).bonusReward(0.5).weight(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_150997_, true).bonusReward(0.5).weight(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42524_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42758_, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42546_, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_151053_, true).weight(2.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.INGOTS_GOLD, true).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42436_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42433_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42479_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42677_, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42477_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42476_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42434_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42652_, true).bonusReward(0.5).weight(0.5).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42478_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42432_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42431_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42430_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42150_, true).weight(1.0).build()).otherReward(LootTableRewardBuilder.table(new ResourceLocation("gameplay/piglin_bartering"), "label.primalmagick.loot_table.piglin_bartering.desc").build()).build(consumer);
        ProjectBuilder.project("portal_detritus").aid(Blocks.f_50142_).materialCountOverride(1).baseSuccessChanceOverride(0.5).rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MAGNIFYING_GLASS.get(), false).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("prosperous_trade").rewardMultiplier(0.5).requiredResearch(Source.INFERNAL.getDiscoverKey()).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier(Source.VOID.getDiscoverKey(), -2.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_EMERALD, 2, true).bonusReward(0.5).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42448_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_DIAMOND, true).bonusReward(0.25).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42413_, 2, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42658_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42579_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42522_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.INGOTS_GOLD, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42054_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42028_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42502_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42527_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42528_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42484_, 3, true).weight(3.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.FEATHERS, 3, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42649_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42532_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42614_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41958_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42170_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42064_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42574_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13146_, true).weight(1.0).build()).otherReward(LootTableRewardBuilder.table(PrimalMagick.resource("gameplay/theorycrafting/prosperous_trade"), "label.primalmagick.loot_table.prosperous_trade.desc").build()).build(consumer);
        ProjectBuilder.project("raiding_the_raiders").rewardMultiplier(0.5).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemMaterialBuilder.item(Raid.m_37779_(), true).matchNbt().bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.BLOODY_FLESH.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42717_, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42383_, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42386_, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42412_, 4, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42590_, 3, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41842_, 16, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42047_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_EMERALD, true).bonusReward(0.25).weight(1.0).build()).build(consumer);
        ProjectBuilder.project("recuperation").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier(Source.INFERNAL.getDiscoverKey(), -2.0).modifier(Source.VOID.getDiscoverKey(), -2.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13146_, false).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41984_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, false).weight(2.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.FOOD_COOKED_BEEF, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.FOOD_BAKED_POTATO, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsForgeExt.MILK, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42502_, true).bonusReward(0.125).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42208_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41996_, true).bonusReward(0.125).weight(0.5).build()).build(consumer);
        ProjectBuilder.project("redstone_tinkering").requiredResearch("BASIC_MAGITECH").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("BASIC_MAGITECH", -1.0).modifier("EXPERT_MAGITECH", -1.0).modifier("MASTER_MAGITECH", -1.0).modifier("SUPREME_MAGITECH", -1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41861_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42161_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41855_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42162_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42152_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41869_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42155_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42105_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41862_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42351_, false).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.DUSTS_REDSTONE, 4, true).weight(3.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("rich_trade").rewardMultiplier(1.0).requiredResearch(Source.VOID.getDiscoverKey()).weightFunction(ConstantWeightFunctionBuilder.weight(5.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_EMERALD, 4, true).bonusReward(1.0).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42740_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42473_, true).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42515_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42780_, 4, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42617_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13191_, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42590_, 3, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_NETHER_WART, 4, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42677_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42546_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42529_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13155_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42109_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42717_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42654_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42450_, true).bonusReward(0.5).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42524_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42656_, true).bonusReward(0.5).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_QUARTZ, 2, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_198161_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42487_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42391_, true).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42390_, true).bonusReward(0.25).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42388_, true).bonusReward(0.25).weight(1.0).build()).otherReward(LootTableRewardBuilder.table(PrimalMagick.resource("gameplay/theorycrafting/rich_trade"), "label.primalmagick.loot_table.rich_trade.desc").build()).build(consumer);
        ProjectBuilder.project("ritual_practice").requiredResearch(QuorumResearchKey.builder(2).add("MANAFRUIT", "RITUAL_CANDLES", "INCENSE_BRAZIER", "DOWSING_ROD").build()).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("EXPERT_RITUAL", -1.0).modifier("MASTER_RITUAL", -1.0).modifier("SUPREME_RITUAL", -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RITUAL_ALTAR.get(), false).weight(10.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.OFFERING_PEDESTAL.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.REFINED_SALT.get(), true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42410_, true).requiredResearch("MANAFRUIT").weight(1.0).bonusReward(0.125).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42787_, true).requiredResearch("MANAFRUIT").weight(1.0).bonusReward(0.125).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MANA_SALTS.get(), true).requiredResearch("MANAFRUIT").weight(1.0).bonusReward(0.125).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.RITUAL_CANDLES, false).requiredResearch("RITUAL_CANDLES").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42409_, false).requiredResearch("RITUAL_CANDLES").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.INCENSE_BRAZIER.get(), false).requiredResearch("INCENSE_BRAZIER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.INCENSE_STICK.get(), true).requiredResearch("INCENSE_BRAZIER").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.DOWSING_ROD.get(), false).requiredResearch("DOWSING_ROD").weight(1.0).build()).build(consumer);
        ProjectBuilder.project("runework").requiredResearch(QuorumResearchKey.builder(3).add("RUNE_EARTH", "RUNE_SEA", "RUNE_SKY", "RUNE_SUN", "RUNE_MOON", "RUNE_PROJECT", "RUNE_PROTECT", "RUNE_ITEM", "RUNE_SELF").build()).weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("EXPERT_RUNEWORKING", -1.0).modifier("MASTER_RUNEWORKING", -1.0).modifier("SUPREME_RUNEWORKING", -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNECARVING_TABLE.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41922_, true).weight(3.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_LAPIS, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42388_, false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_EARTH.get(), true).requiredResearch("RUNE_EARTH").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SEA.get(), true).requiredResearch("RUNE_SEA").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SKY.get(), true).requiredResearch("RUNE_SKY").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SUN.get(), true).requiredResearch("RUNE_SUN").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_MOON.get(), true).requiredResearch("RUNE_MOON").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_PROJECT.get(), true).requiredResearch("RUNE_PROJECT").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_PROTECT.get(), true).requiredResearch("RUNE_PROTECT").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_ITEM.get(), true).requiredResearch("RUNE_ITEM").weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.RUNE_SELF.get(), true).requiredResearch("RUNE_SELF").weight(1.0).build()).build(consumer);
        ProjectBuilder.project("spellwork").requiredResearch("BASIC_SORCERY").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("EXPERT_SORCERY", -1.0).modifier("MASTER_SORCERY", -1.0).modifier("SUPREME_SORCERY", -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELLCRAFTING_ALTAR.get(), false).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_INSCRIPTION_TABLE.get(), false).requiredResearch("WAND_INSCRIPTION").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_CHARGER.get(), false).requiredResearch("WAND_CHARGER").weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.MUNDANE_WAND.get(), false).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.SPELL_SCROLL_BLANK.get(), true).weight(5.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_EARTH.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SEA.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SKY.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_SUN.get(), true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.ESSENCE_DUST_MOON.get(), true).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
        ProjectBuilder.project("trade").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier(Source.INFERNAL.getDiscoverKey(), -2.0).modifier(Source.VOID.getDiscoverKey(), -2.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_EMERALD, true).bonusReward(0.25).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42413_, 2, true).weight(3.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.INGOTS_IRON, true).weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42581_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42485_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42516_, 4, true).weight(2.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GLASS_PANES, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42583_, 4, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_WHEAT, 3, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_POTATO, 3, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_CARROT, 3, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.CROPS_BEETROOT, 3, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.STRING, 3, true).weight(2.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42526_, 2, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.RODS_WOODEN, 4, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.LEATHER, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42517_, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_42461_, 2, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41905_, 2, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)ItemTags.f_13167_, 2, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.DYES, 2, true).weight(1.0).build()).otherReward(LootTableRewardBuilder.table(PrimalMagick.resource("gameplay/theorycrafting/trade"), "label.primalmagick.loot_table.trade.desc").build()).build(consumer);
        ProjectBuilder.project("wand_tinkering").requiredResearch("BASIC_MANAWEAVING").weightFunction(ProgressiveWeightFunctionBuilder.start(5.0).modifier("MASTER_MANAWEAVING", -2.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.WAND_ASSEMBLY_TABLE.get(), false).requiredResearch("ADVANCED_WANDMAKING").weight(3.0).build()).material(ItemMaterialBuilder.item((ItemLike)ItemsPM.HEARTWOOD.get(), true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.OBSIDIAN, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.CORAL_BLOCKS, true).weight(1.0).build()).material(ItemMaterialBuilder.item((ItemLike)Items.f_41911_, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.SUNWOOD_LOGS, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.MOONWOOD_LOGS, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.INGOTS_IRON, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.INGOTS_GOLD, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag((TagKey<Item>)Tags.Items.GEMS_DIAMOND, true).weight(1.0).build()).material(ItemTagMaterialBuilder.tag(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS, true).weight(1.0).build()).material(ObservationMaterialBuilder.observation(1, true).weight(5.0).build()).build(consumer);
    }

    public String m_6055_() {
        return "Primal Magick Theorycrafting Projects";
    }
}

