/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLParser;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLParsingException;
import site.siredvin.peripheralium.extra.dsl.rml1.RenderInstruction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0002Rf\u0010\u0003\u001aZ\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*,\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lsite/siredvin/turtlematic/client/RenderUtil;", "", "()V", "cache", "Lcom/google/common/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RenderInstruction;", "parser", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser;", "parseRML", "string", "parseRMLRaw", "parseRMLRawProtected", "turtlematic-forge-1.20.1"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    @NotNull
    private static final RMLParser parser = new RMLParser();
    private static final LoadingCache<String, List<RenderInstruction>> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).maximumSize(3000L).build(CacheLoader.from(INSTANCE::parseRMLRawProtected));

    private RenderUtil() {
    }

    @NotNull
    public final List<RenderInstruction> parseRMLRaw(@NotNull String string) throws RMLParsingException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return parser.parse(string);
    }

    private final List<RenderInstruction> parseRMLRawProtected(String string) {
        List<RenderInstruction> list;
        try {
            list = this.parseRMLRaw(string);
        }
        catch (RMLParsingException ignored) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<RenderInstruction> parseRML(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Object object = cache.get((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache.get(string)");
        return (List)object;
    }

    static {
        parser.injectDefault();
    }
}

