/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.common.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.turtlematic.common.items.AutomataCore;
import site.siredvin.turtlematic.common.items.ForgedAutomataCore;
import site.siredvin.turtlematic.common.items.RecipeAutomataCore;
import site.siredvin.turtlematic.common.recipe.SimpleSoulHarvestIngredient;
import site.siredvin.turtlematic.common.recipe.SoulHarvestRecipe;
import site.siredvin.turtlematic.common.recipe.VillagerSoulHarvestIngredient;
import site.siredvin.turtlematic.common.setup.Items;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fJ\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\u0013J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/turtlematic/common/recipe/SoulHarvestRecipeRegistry;", "", "()V", "CONSUMED_ENTITY_COUNT", "", "getCONSUMED_ENTITY_COUNT", "()Ljava/lang/String;", "CONSUMED_ENTITY_NAME", "getCONSUMED_ENTITY_NAME", "CONSUMER_ENTITY_COMPOUND", "getCONSUMER_ENTITY_COMPOUND", "RECIPE_REGISTRY", "", "Lnet/minecraft/world/item/Item;", "", "Lsite/siredvin/turtlematic/common/recipe/SoulHarvestRecipe;", "REVERSE_RECIPE_REGISTRY", "Lkotlin/Pair;", "addRecipe", "", "targetItem", "recipe", "get", "item", "injectAutomataCoreRecipes", "injectForgedAutomataCoreRecipes", "searchRecipe", "name", "entity", "Lnet/minecraft/world/entity/Entity;", "turtlematic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nSoulHarvestRecipeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulHarvestRecipeRegistry.kt\nsite/siredvin/turtlematic/common/recipe/SoulHarvestRecipeRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class SoulHarvestRecipeRegistry {
    @NotNull
    public static final SoulHarvestRecipeRegistry INSTANCE = new SoulHarvestRecipeRegistry();
    @NotNull
    private static final String CONSUMED_ENTITY_COUNT = "consumed_entity_count";
    @NotNull
    private static final String CONSUMED_ENTITY_NAME = "consumed_entity_name";
    @NotNull
    private static final String CONSUMER_ENTITY_COMPOUND = "consumed_entity_compound";
    @NotNull
    private static final Map<Item, List<SoulHarvestRecipe>> RECIPE_REGISTRY = new HashMap();
    @NotNull
    private static final Map<Item, Pair<SoulHarvestRecipe, Item>> REVERSE_RECIPE_REGISTRY = new HashMap();

    private SoulHarvestRecipeRegistry() {
    }

    @NotNull
    public final String getCONSUMED_ENTITY_COUNT() {
        return CONSUMED_ENTITY_COUNT;
    }

    @NotNull
    public final String getCONSUMED_ENTITY_NAME() {
        return CONSUMED_ENTITY_NAME;
    }

    @NotNull
    public final String getCONSUMER_ENTITY_COMPOUND() {
        return CONSUMER_ENTITY_COMPOUND;
    }

    public final void addRecipe(@NotNull Item targetItem, @NotNull SoulHarvestRecipe recipe2) {
        Intrinsics.checkNotNullParameter((Object)targetItem, (String)"targetItem");
        Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
        if (!RECIPE_REGISTRY.containsKey(targetItem)) {
            RECIPE_REGISTRY.put(targetItem, new ArrayList());
        }
        List<SoulHarvestRecipe> list = RECIPE_REGISTRY.get(targetItem);
        Intrinsics.checkNotNull(list);
        list.add(recipe2);
        REVERSE_RECIPE_REGISTRY.put(recipe2.getResultSoul(), (Pair<SoulHarvestRecipe, Item>)new Pair((Object)recipe2, (Object)targetItem));
    }

    @Nullable
    public final Pair<SoulHarvestRecipe, Item> get(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return REVERSE_RECIPE_REGISTRY.get(item);
    }

    @Nullable
    public final SoulHarvestRecipe searchRecipe(@NotNull Item targetItem, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)targetItem, (String)"targetItem");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!RECIPE_REGISTRY.containsKey(targetItem)) {
            return null;
        }
        List<SoulHarvestRecipe> list = RECIPE_REGISTRY.get(targetItem);
        Intrinsics.checkNotNull(list);
        Optional<Object> recipe2 = list.stream().filter(arg_0 -> SoulHarvestRecipeRegistry.searchRecipe$lambda$0((Function1)new Function1<SoulHarvestRecipe, Boolean>(entity){
            final /* synthetic */ Entity $entity;
            {
                this.$entity = $entity;
                super(1);
            }

            @NotNull
            public final Boolean invoke(SoulHarvestRecipe it) {
                return it.isSuitable(this.$entity);
            }
        }, arg_0)).findAny();
        if (recipe2.isEmpty()) {
            return null;
        }
        return (SoulHarvestRecipe)recipe2.get();
    }

    @Nullable
    public final SoulHarvestRecipe searchRecipe(@NotNull Item targetItem, @NotNull String name) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)targetItem, (String)"targetItem");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!RECIPE_REGISTRY.containsKey(targetItem)) {
                return null;
            }
            List<SoulHarvestRecipe> list = RECIPE_REGISTRY.get(targetItem);
            Intrinsics.checkNotNull(list);
            Iterable iterable = list;
            for (Object t : iterable) {
                SoulHarvestRecipe it = (SoulHarvestRecipe)t;
                boolean bl = false;
                if (!it.isSuitable(name)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    public final void injectAutomataCoreRecipes() {
        EntityType entityType = EntityType.f_20566_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"ENDERMAN");
        List list = CollectionsKt.listOf((Object)new SimpleSoulHarvestIngredient(entityType, 3));
        RecipeAutomataCore recipeAutomataCore = Items.INSTANCE.getEND_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore), (String)"Items.END_AUTOMATA_CORE.get()");
        SoulHarvestRecipe endSoulRecord = new SoulHarvestRecipe(list, (Item)recipeAutomataCore);
        Object[] objectArray = new SimpleSoulHarvestIngredient[4];
        EntityType entityType2 = EntityType.f_20510_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType2, (String)"PIG");
        objectArray[0] = new SimpleSoulHarvestIngredient(entityType2, 1);
        EntityType entityType3 = EntityType.f_20520_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType3, (String)"SHEEP");
        objectArray[1] = new SimpleSoulHarvestIngredient(entityType3, 1);
        EntityType entityType4 = EntityType.f_20557_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType4, (String)"COW");
        objectArray[2] = new SimpleSoulHarvestIngredient(entityType4, 1);
        EntityType entityType5 = EntityType.f_20555_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType5, (String)"CHICKEN");
        objectArray[3] = new SimpleSoulHarvestIngredient(entityType5, 1);
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        RecipeAutomataCore recipeAutomataCore2 = Items.INSTANCE.getHUSBANDRY_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore2), (String)"Items.HUSBANDRY_AUTOMATA_CORE.get()");
        SoulHarvestRecipe husbandrySoulRecord = new SoulHarvestRecipe(list2, (Item)recipeAutomataCore2);
        EntityType entityType6 = EntityType.f_20460_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType6, (String)"IRON_GOLEM");
        List list3 = CollectionsKt.listOf((Object)new SimpleSoulHarvestIngredient(entityType6, 1));
        RecipeAutomataCore recipeAutomataCore3 = Items.INSTANCE.getPROTECTIVE_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore3), (String)"Items.PROTECTIVE_AUTOMATA_CORE.get()");
        SoulHarvestRecipe protectiveSoulRecord = new SoulHarvestRecipe(list3, (Item)recipeAutomataCore3);
        AutomataCore automataCore = Items.INSTANCE.getAUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)automataCore, (String)"Items.AUTOMATA_CORE.get()");
        this.addRecipe((Item)automataCore, endSoulRecord);
        AutomataCore automataCore2 = Items.INSTANCE.getAUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)automataCore2, (String)"Items.AUTOMATA_CORE.get()");
        this.addRecipe((Item)automataCore2, husbandrySoulRecord);
        AutomataCore automataCore3 = Items.INSTANCE.getAUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)automataCore3, (String)"Items.AUTOMATA_CORE.get()");
        this.addRecipe((Item)automataCore3, protectiveSoulRecord);
    }

    public final void injectForgedAutomataCoreRecipes() {
        VillagerProfession villagerProfession = VillagerProfession.f_35589_;
        Intrinsics.checkNotNullExpressionValue((Object)villagerProfession, (String)"CLERIC");
        List list = CollectionsKt.listOf((Object)new VillagerSoulHarvestIngredient(villagerProfession));
        RecipeAutomataCore recipeAutomataCore = Items.INSTANCE.getBREWING_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore), (String)"Items.BREWING_AUTOMATA_CORE.get()");
        SoulHarvestRecipe brewingAutomataRecord = new SoulHarvestRecipe(list, (Item)recipeAutomataCore);
        VillagerProfession villagerProfession2 = VillagerProfession.f_35595_;
        Intrinsics.checkNotNullExpressionValue((Object)villagerProfession2, (String)"MASON");
        List list2 = CollectionsKt.listOf((Object)new VillagerSoulHarvestIngredient(villagerProfession2));
        RecipeAutomataCore recipeAutomataCore2 = Items.INSTANCE.getMASON_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore2), (String)"Items.MASON_AUTOMATA_CORE.get()");
        SoulHarvestRecipe masonAutomataRecipe = new SoulHarvestRecipe(list2, (Item)recipeAutomataCore2);
        VillagerProfession villagerProfession3 = VillagerProfession.f_35594_;
        Intrinsics.checkNotNullExpressionValue((Object)villagerProfession3, (String)"LIBRARIAN");
        List list3 = CollectionsKt.listOf((Object)new VillagerSoulHarvestIngredient(villagerProfession3));
        RecipeAutomataCore recipeAutomataCore3 = Items.INSTANCE.getENCHANTING_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore3), (String)"Items.ENCHANTING_AUTOMATA_CORE.get()");
        SoulHarvestRecipe enchantingAutomataRecord = new SoulHarvestRecipe(list3, (Item)recipeAutomataCore3);
        VillagerProfession villagerProfession4 = VillagerProfession.f_35598_;
        Intrinsics.checkNotNullExpressionValue((Object)villagerProfession4, (String)"TOOLSMITH");
        List list4 = CollectionsKt.listOf((Object)new VillagerSoulHarvestIngredient(villagerProfession4));
        RecipeAutomataCore recipeAutomataCore4 = Items.INSTANCE.getSMITHING_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore4), (String)"Items.SMITHING_AUTOMATA_CORE.get()");
        SoulHarvestRecipe smithingAutomataRecord = new SoulHarvestRecipe(list4, (Item)recipeAutomataCore4);
        EntityType entityType = EntityType.f_20494_;
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"WANDERING_TRADER");
        List list5 = CollectionsKt.listOf((Object)new SimpleSoulHarvestIngredient(entityType, 1));
        RecipeAutomataCore recipeAutomataCore5 = Items.INSTANCE.getMERCANTILE_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeAutomataCore5), (String)"Items.MERCANTILE_AUTOMATA_CORE.get()");
        SoulHarvestRecipe mercantileSoulRecord = new SoulHarvestRecipe(list5, (Item)recipeAutomataCore5);
        ForgedAutomataCore forgedAutomataCore = Items.INSTANCE.getFORGED_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)forgedAutomataCore, (String)"Items.FORGED_AUTOMATA_CORE.get()");
        this.addRecipe((Item)forgedAutomataCore, brewingAutomataRecord);
        ForgedAutomataCore forgedAutomataCore2 = Items.INSTANCE.getFORGED_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)forgedAutomataCore2, (String)"Items.FORGED_AUTOMATA_CORE.get()");
        this.addRecipe((Item)forgedAutomataCore2, enchantingAutomataRecord);
        ForgedAutomataCore forgedAutomataCore3 = Items.INSTANCE.getFORGED_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)forgedAutomataCore3, (String)"Items.FORGED_AUTOMATA_CORE.get()");
        this.addRecipe((Item)forgedAutomataCore3, smithingAutomataRecord);
        ForgedAutomataCore forgedAutomataCore4 = Items.INSTANCE.getFORGED_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)forgedAutomataCore4, (String)"Items.FORGED_AUTOMATA_CORE.get()");
        this.addRecipe((Item)forgedAutomataCore4, mercantileSoulRecord);
        ForgedAutomataCore forgedAutomataCore5 = Items.INSTANCE.getFORGED_AUTOMATA_CORE().get();
        Intrinsics.checkNotNullExpressionValue((Object)forgedAutomataCore5, (String)"Items.FORGED_AUTOMATA_CORE.get()");
        this.addRecipe((Item)forgedAutomataCore5, masonAutomataRecipe);
    }

    private static final boolean searchRecipe$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

