/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.forged;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.Util;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.datatypes.InteractionMode;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.ExperienceAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.ScanningAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.util.representation.EnrichersKt;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.PowerOperation;
import site.siredvin.turtlematic.computercraft.operations.PowerOperationContext;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.operations.SphereOperation;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.ExperienceAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.plugins.AutomataInteractionPlugin;
import site.siredvin.turtlematic.computercraft.plugins.AutomataLookPlugin;
import site.siredvin.turtlematic.util.TurtleDispenseBehavior;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0007R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/ExperienceAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "dispenseBehavior", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "getDispenseBehavior", "()Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "dispenseBehavior$delegate", "Lkotlin/Lazy;", "isEnabled", "", "()Z", "brew", "Ldan200/computercraft/api/lua/MethodResult;", "possibleOperations", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "throwPotion", "power", "", "angle", "Companion", "TurtlePotionDispenseBehavior", "turtlematic-forge-1.20.1"})
public final class BrewingAutomataCorePeripheral
extends ExperienceAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy dispenseBehavior$delegate;
    @NotNull
    private static final String TYPE = "brewingAutomata";
    @NotNull
    private static final Predicate<Entity> suitableEntity = BrewingAutomataCorePeripheral::suitableEntity$lambda$4;

    public BrewingAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(TYPE, turtle, side, tier);
        this.addPlugin(new AutomataLookPlugin(this, CollectionsKt.listOf((Object)EnrichersKt.getEffectsData()), null, null, null, 28, null));
        BiConsumer[] biConsumerArray = ArraysKt.toSet((Object[])InteractionMode.values());
        Predicate<Entity> predicate = suitableEntity;
        this.addPlugin(new AutomataInteractionPlugin(this, predicate, (Set<? extends InteractionMode>)biConsumerArray));
        biConsumerArray = new BiConsumer[]{BrewingAutomataCorePeripheral::_init_$lambda$1};
        ((TurtlePeripheralOwner)this.getPeripheralOwner()).attachAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getSCANNING(), (IOwnerAbility)new ScanningAbility(this.getPeripheralOwner(), tier.getInteractionRadius()).attachItemScan((IPeripheralOperation)SphereOperation.SCAN_ITEMS, new BiConsumer[0]).attachLivingEntityScan((IPeripheralOperation)SphereOperation.SCAN_ENTITIES, BrewingAutomataCorePeripheral::_init_$lambda$0, biConsumerArray));
        this.dispenseBehavior$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TurtlePotionDispenseBehavior>(this){
            final /* synthetic */ BrewingAutomataCorePeripheral this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TurtlePotionDispenseBehavior invoke() {
                return new TurtlePotionDispenseBehavior(this.this$0.getPeripheralOwner());
            }
        }));
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableBrewingAutomataCore();
    }

    private final TurtlePotionDispenseBehavior getDispenseBehavior() {
        Lazy lazy = this.dispenseBehavior$delegate;
        return (TurtlePotionDispenseBehavior)lazy.getValue();
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> operations = super.possibleOperations();
        operations.add(SingleOperation.BREW);
        operations.add(PowerOperation.THROW_POTION);
        return operations;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult brew() throws LuaException {
        return this.withOperation(SingleOperation.BREW, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> BrewingAutomataCorePeripheral.brew$lambda$2(this, arg_0)));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult throwPotion(double power, double angle) throws LuaException {
        if (power <= 0.0) {
            throw new LuaException("Power cannot be 0");
        }
        double limitedPower = RangesKt.coerceAtLeast((double)power, (double)TurtlematicConfig.INSTANCE.getBrewingPowerLimit());
        return BaseAutomataCorePeripheral.withOperation$default(this, PowerOperation.THROW_POTION, new PowerOperationContext(limitedPower), arg_0 -> BrewingAutomataCorePeripheral.throwPotion$lambda$3(this, limitedPower, angle, arg_0), null, 8, null);
    }

    private static final boolean _init_$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return suitableEntity.test((Entity)it);
    }

    private static final void _init_$lambda$1(LivingEntity it1, Map it2) {
        Intrinsics.checkNotNullParameter((Object)it1, (String)"it1");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it2");
        EnrichersKt.getEffectsData().accept(it1, it2);
    }

    private static final MethodResult brew$lambda$2(BrewingAutomataCorePeripheral this$0, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"peripheralOwner.turtle.inventory");
        Container turtleInventory = container;
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"turtleInventory.getItem(selectedSlot)");
        ItemStack component = itemStack;
        if (!PotionBrewing.m_43506_((ItemStack)component)) {
            Object[] objectArray = new Object[]{null, "Selected component is not an ingredient for brewing!"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n                    \u2026wing!\",\n                )");
            return methodResult;
        }
        boolean usedForBrewing = false;
        int n = turtleInventory.m_6643_();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack slotStack;
            if (slot == selectedSlot) continue;
            Intrinsics.checkNotNullExpressionValue((Object)turtleInventory.m_8020_(slot), (String)"turtleInventory.getItem(slot)");
            if (slotStack.m_41619_() || !PotionBrewing.m_43508_((ItemStack)slotStack, (ItemStack)component)) continue;
            turtleInventory.m_6836_(slot, PotionBrewing.m_43529_((ItemStack)component, (ItemStack)slotStack));
            usedForBrewing = true;
            ExperienceAbility experienceAbility = (ExperienceAbility)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getEXPERIENCE());
            if (experienceAbility == null) continue;
            experienceAbility.adjustStoredXP(TurtlematicConfig.INSTANCE.getBrewingXPReward());
        }
        if (usedForBrewing) {
            if (component.m_41613_() == 1) {
                turtleInventory.m_6836_(selectedSlot, ItemStack.f_41583_);
            } else {
                component.m_41774_(1);
            }
        }
        MethodResult methodResult = MethodResult.of((Object)usedForBrewing);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(usedForBrewing)");
        return methodResult;
    }

    private static final MethodResult throwPotion$lambda$3(BrewingAutomataCorePeripheral this$0, double $limitedPower, double $angle, PowerOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"peripheralOwner.turtle.inventory");
        Container turtleInventory = container;
        ItemStack itemStack = turtleInventory.m_8020_(selectedSlot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"turtleInventory.getItem(selectedSlot)");
        ItemStack selectedStack = itemStack;
        Item item = selectedStack.m_41720_();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"selectedStack.item");
        Item selectedItem = item;
        if (selectedItem != Items.f_42736_ && selectedItem != Items.f_42739_) {
            Object[] objectArray = new Object[]{null, "Selected item should be splash or lingering potion"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n                    \u2026otion\",\n                )");
            return methodResult;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)selectedStack);
        Intrinsics.checkNotNullExpressionValue((Object)potion, (String)"getPotion(selectedStack)");
        Potion potion2 = potion;
        if (potion2 == Potions.f_43598_) {
            Object[] objectArray = new Object[]{null, "Selected item is not potion"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Selected item is not potion\")");
            return methodResult;
        }
        TurtlePotionDispenseBehavior turtlePotionDispenseBehavior = this$0.getDispenseBehavior();
        Level level = this$0.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        turtleInventory.m_6836_(selectedSlot, turtlePotionDispenseBehavior.dispense((BlockSource)new BlockSourceImpl((ServerLevel)level, this$0.getPos()), selectedStack, $limitedPower, $angle));
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    private static final boolean suitableEntity$lambda$4(Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity instanceof ZombieVillager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "suitableEntity", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public ResourceLocation getUPGRADE_ID() {
            return PeripheralConfiguration.DefaultImpls.getUPGRADE_ID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/BrewingAutomataCorePeripheral$TurtlePotionDispenseBehavior;", "Lsite/siredvin/turtlematic/util/TurtleDispenseBehavior;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)V", "getProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "level", "Lnet/minecraft/world/level/Level;", "targetPosition", "Lnet/minecraft/core/Position;", "stack", "Lnet/minecraft/world/item/ItemStack;", "turtlematic-forge-1.20.1"})
    public static final class TurtlePotionDispenseBehavior
    extends TurtleDispenseBehavior {
        public TurtlePotionDispenseBehavior(@NotNull IPeripheralOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner);
        }

        @Override
        @NotNull
        public Projectile getProjectile(@NotNull Level level, @NotNull Position targetPosition, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            stack.m_41774_(1);
            Object object = Util.m_137469_((Object)new ThrownPotion(level, targetPosition.m_7096_(), targetPosition.m_7098_(), targetPosition.m_7094_()), arg_0 -> TurtlePotionDispenseBehavior.getProjectile$lambda$0(stack, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"make(\n                Th\u2026_218413_1_.item = stack }");
            return (Projectile)object;
        }

        private static final void getProjectile$lambda$0(ItemStack $stack, ThrownPotion p_218413_1_) {
            Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
            p_218413_1_.m_37446_($stack);
        }
    }
}

