/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.forged;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.datatypes.TransformInteractionMode;
import site.siredvin.peripheralium.api.datatypes.VerticalDirection;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.ExperienceAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.storages.FakeItemContainer;
import site.siredvin.peripheralium.storages.LimitedInventory;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.turtlematic.api.IAutomataCoreTier;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.CountOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.ExperienceAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.peripheral.forged.SmithingAutomataCorePeripheral;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\f\u001a\u001e\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006 "}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/SmithingAutomataCorePeripheral;", "Lsite/siredvin/turtlematic/computercraft/peripheral/forged/ExperienceAutomataCorePeripheral;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "tier", "Lsite/siredvin/turtlematic/api/IAutomataCoreTier;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/turtlematic/api/IAutomataCoreTier;)V", "isEnabled", "", "()Z", "findBlock", "Lsite/siredvin/peripheralium/util/Pair;", "Lnet/minecraft/world/phys/BlockHitResult;", "Lnet/minecraft/world/level/block/state/BlockState;", "Ldan200/computercraft/api/lua/MethodResult;", "overwrittenDirection", "Lsite/siredvin/peripheralium/api/datatypes/VerticalDirection;", "isEditable", "pos", "Lnet/minecraft/core/BlockPos;", "possibleOperations", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "smelt", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "smeltBlock", "smeltItem", "smith", "Companion", "turtlematic-forge-1.20.1"})
public final class SmithingAutomataCorePeripheral
extends ExperienceAutomataCorePeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE = "smithingAutomata";

    public SmithingAutomataCorePeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side, @NotNull IAutomataCoreTier tier) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        super(TYPE, turtle, side, tier);
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableSmithingAutomataCore();
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> possibleOperations() {
        List<IPeripheralOperation<?>> base = super.possibleOperations();
        base.add(SingleOperation.SMITH);
        base.add(CountOperation.SMELT);
        return base;
    }

    private final boolean isEditable(BlockPos pos) {
        return (Boolean)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), (Function1)((Function1)new Function1<FakePlayerProxy, Boolean>(pos){
            final /* synthetic */ BlockPos $pos;
            {
                this.$pos = $pos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FakePlayerProxy it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BlockState blockState2 = it.getFakePlayer().m_9236_().m_8055_(this.$pos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"it.fakePlayer.level().getBlockState(pos)");
                return PeripheraliumPlatform.Companion.isBlockProtected(this.$pos, blockState2, it.getFakePlayer());
            }
        }), null, (boolean)false, (int)6, null) == false;
    }

    private final Pair<Pair<BlockHitResult, BlockState>, MethodResult> findBlock(VerticalDirection overwrittenDirection) {
        VerticalDirection verticalDirection = overwrittenDirection;
        BlockHitResult blockHitResult = (BlockHitResult)IPeripheralOwner.DefaultImpls.withPlayer$default((IPeripheralOwner)this.getPeripheralOwner(), (Function1)findBlock.hit.1.INSTANCE, (Direction)(verticalDirection != null ? verticalDirection.getMinecraftDirection() : null), (boolean)false, (int)4, null);
        if (blockHitResult == null) {
            Object[] objectArray = new Object[]{null, "There is nothing to work with"};
            return Pair.Companion.onlyRight((Object)MethodResult.of((Object[])objectArray));
        }
        BlockHitResult hit2 = blockHitResult;
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        BlockState blockState2 = level.m_8055_(hit2.m_82425_());
        if (blockState2.m_60795_()) {
            Object[] objectArray = new Object[]{null, "There is nothing to work with"};
            return Pair.Companion.onlyRight((Object)MethodResult.of((Object[])objectArray));
        }
        BlockPos blockPos = hit2.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"hit.blockPos");
        if (!this.isEditable(blockPos)) {
            Object[] objectArray = new Object[]{null, "This block is protected"};
            return Pair.Companion.onlyRight((Object)MethodResult.of((Object[])objectArray));
        }
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"blockState");
        return Pair.Companion.onlyLeft((Object)new Pair((Object)hit2, (Object)blockState2));
    }

    private final MethodResult smeltItem(IArguments arguments) {
        MethodResult methodResult;
        Container container = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"peripheralOwner.turtle.inventory");
        Container turtleInventory = container;
        int[] nArray = new int[]{((TurtlePeripheralOwner)this.getPeripheralOwner()).getTurtle().getSelectedSlot()};
        LimitedInventory limitedInventory = new LimitedInventory(turtleInventory, nArray);
        int limit = arguments.optInt(1, Integer.MAX_VALUE);
        int smeltCount = Math.min(limit, limitedInventory.m_8020_(0).m_41613_());
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        Optional optional = level2.m_7465_().m_44015_(RecipeType.f_44108_, (Container)limitedInventory, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"level.recipeManager.getR\u2026 limitedInventory, level)");
        Optional optRecipe = optional;
        if (!optRecipe.isPresent()) {
            Object[] objectArray = new Object[]{null, "Cannot find smelting recipe"};
            MethodResult methodResult2 = MethodResult.of((Object[])objectArray);
            methodResult = methodResult2;
            Intrinsics.checkNotNullExpressionValue((Object)methodResult2, (String)"{\n            MethodResu\u2026,\n            )\n        }");
        } else {
            methodResult = this.withOperation(CountOperation.SMELT, smeltCount, arg_0 -> SmithingAutomataCorePeripheral.smeltItem$lambda$0(this, smeltCount, optRecipe, limitedInventory, turtleInventory, level2, arg_0), null);
        }
        return methodResult;
    }

    private final MethodResult smeltBlock(IArguments arguments) {
        VerticalDirection verticalDirection;
        Optional directionArgument = arguments.optString(1);
        if (directionArgument.isEmpty()) {
            verticalDirection = null;
        } else {
            Object t = directionArgument.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"directionArgument.get()");
            verticalDirection = VerticalDirection.Companion.luaValueOf((String)t);
        }
        VerticalDirection overwrittenDirection = verticalDirection;
        Pair<Pair<BlockHitResult, BlockState>, MethodResult> blockSearchResult = this.findBlock(overwrittenDirection);
        if (blockSearchResult.rightPresent()) {
            Object object = blockSearchResult.getRight();
            Intrinsics.checkNotNull((Object)object);
            return (MethodResult)object;
        }
        Object object = blockSearchResult.getLeft();
        Intrinsics.checkNotNull((Object)object);
        BlockState blockState2 = (BlockState)((Pair)object).getRight();
        Object object2 = blockSearchResult.getLeft();
        Intrinsics.checkNotNull((Object)object2);
        BlockHitResult hit2 = (BlockHitResult)((Pair)object2).getLeft();
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        ItemStack itemStack = blockState2.m_60734_().m_5456_().m_7968_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"blockState.block.asItem().defaultInstance");
        FakeItemContainer fakeContainer2 = new FakeItemContainer(itemStack);
        Optional optRecipe = level2.m_7465_().m_44015_(RecipeType.f_44108_, (Container)fakeContainer2, level2);
        if (optRecipe.isEmpty()) {
            Object[] objectArray = new Object[]{null, "Cannot perform in-place smelting for this block"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot perform\u2026smelting for this block\")");
            return methodResult;
        }
        return BaseAutomataCorePeripheral.withOperation$default(this, CountOperation.SMELT, 1, arg_0 -> SmithingAutomataCorePeripheral.smeltBlock$lambda$1(optRecipe, level2, hit2, this, arg_0), null, 8, null);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult smith() throws LuaException {
        return this.withOperation(SingleOperation.SMITH, (IPeripheralFunction<SingleOperationContext, MethodResult>)((IPeripheralFunction)arg_0 -> SmithingAutomataCorePeripheral.smith$lambda$2(this, arg_0)));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult smelt(@NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = arguments.getString(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arguments.getString(0)");
        return switch (WhenMappings.$EnumSwitchMapping$0[TransformInteractionMode.Companion.luaValueOf(string).ordinal()]) {
            case 1 -> this.smeltBlock(arguments);
            case 2 -> this.smeltItem(arguments);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final MethodResult smeltItem$lambda$0(SmithingAutomataCorePeripheral this$0, int $smeltCount, Optional $optRecipe, LimitedInventory $limitedInventory, Container $turtleInventory, Level $level, int it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$optRecipe, (String)"$optRecipe");
        Intrinsics.checkNotNullParameter((Object)$limitedInventory, (String)"$limitedInventory");
        Intrinsics.checkNotNullParameter((Object)$turtleInventory, (String)"$turtleInventory");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        this$0.addRotationCycle($smeltCount / 2);
        Object t = $optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"optRecipe.get()");
        SmeltingRecipe recipe2 = (SmeltingRecipe)t;
        ItemStack itemStack = recipe2.m_5874_((Container)$limitedInventory, (RegistryAccess)RegistryAccess.f_243945_);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"recipe.assemble(limitedI\u2026ry, RegistryAccess.EMPTY)");
        ItemStack result2 = itemStack;
        result2.m_41764_(result2.m_41613_() * $smeltCount);
        $limitedInventory.reduceCount(0, $smeltCount);
        int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        BlockPos blockPos = this$0.getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos.relative(peripheralOwner.facing)");
        ContainerUtils.INSTANCE.toInventoryOrToWorld(result2, $turtleInventory, n, blockPos, $level);
        ExperienceAbility experienceAbility = (ExperienceAbility)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getEXPERIENCE());
        if (experienceAbility != null) {
            experienceAbility.adjustStoredXP((double)((float)$smeltCount * recipe2.m_43750_()));
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    private static final MethodResult smeltBlock$lambda$1(Optional $optRecipe, Level $level, BlockHitResult $hit, SmithingAutomataCorePeripheral this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$hit, (String)"$hit");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object t = $optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"optRecipe.get()");
        SmeltingRecipe recipe2 = (SmeltingRecipe)t;
        ItemStack recipeResult = recipe2.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        if (recipeResult.m_41720_() instanceof BlockItem && recipeResult.m_41613_() == 1) {
            Item item = recipeResult.m_41720_();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            BlockState targetBlockState = ((BlockItem)item).m_40614_().m_49966_();
            $level.m_46597_($hit.m_82425_(), targetBlockState);
        } else {
            $level.m_46597_($hit.m_82425_(), Blocks.f_50016_.m_49966_());
            ItemStack itemStack = recipeResult.m_41777_();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"recipeResult.copy()");
            Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"peripheralOwner.turtle.inventory");
            int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
            BlockPos blockPos = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"peripheralOwner.pos.rela\u2026e(peripheralOwner.facing)");
            ContainerUtils.INSTANCE.toInventoryOrToWorld(itemStack, container, n, blockPos, $level);
        }
        ExperienceAbility experienceAbility = (ExperienceAbility)((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getEXPERIENCE());
        if (experienceAbility != null) {
            experienceAbility.adjustStoredXP((double)recipe2.m_43750_());
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    private static final MethodResult smith$lambda$2(SmithingAutomataCorePeripheral this$0, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Container container = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"peripheralOwner.turtle.inventory");
        Container turtleInventory = container;
        int selectedSlot = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        if (selectedSlot + 2 >= turtleInventory.m_6643_()) {
            Object[] objectArray = new Object[]{null, "Cannot use last and pre-last slot as first for smith operation"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot use las\u2026rst for smith operation\")");
            return methodResult;
        }
        int[] nArray = new int[]{selectedSlot, selectedSlot + 1, selectedSlot + 2};
        LimitedInventory limitedInventory = new LimitedInventory(turtleInventory, nArray);
        Level level = this$0.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        Optional optional = level2.m_7465_().m_44015_(RecipeType.f_44113_, (Container)limitedInventory, level2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"level.recipeManager.getR\u2026 limitedInventory, level)");
        Optional optRecipe = optional;
        if (!optRecipe.isPresent()) {
            Object[] objectArray = new Object[]{null, "Cannot find smithing recipe"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find smithing recipe\")");
            return methodResult;
        }
        Object t = optRecipe.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"optRecipe.get()");
        SmithingRecipe recipe2 = (SmithingRecipe)t;
        ItemStack itemStack = recipe2.m_5874_((Container)limitedInventory, (RegistryAccess)RegistryAccess.f_243945_);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"recipe.assemble(limitedI\u2026ry, RegistryAccess.EMPTY)");
        ItemStack result2 = itemStack;
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)0, (int)0, (int)2, null);
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)1, (int)0, (int)2, null);
        LimitedInventory.reduceCount$default((LimitedInventory)limitedInventory, (int)2, (int)0, (int)2, null);
        int n = ((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getTurtle().getSelectedSlot();
        BlockPos blockPos = this$0.getPos().m_121945_(((TurtlePeripheralOwner)this$0.getPeripheralOwner()).getFacing());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos.relative(peripheralOwner.facing)");
        ContainerUtils.INSTANCE.toInventoryOrToWorld(result2, turtleInventory, n, blockPos, level2);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/forged/SmithingAutomataCorePeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public ResourceLocation getUPGRADE_ID() {
            return PeripheralConfiguration.DefaultImpls.getUPGRADE_ID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransformInteractionMode.values().length];
            try {
                nArray[TransformInteractionMode.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformInteractionMode.INVENTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

