/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.misc;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.ChunkManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0012R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/ChunkVialPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "peripheralOwner", "(Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;)V", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "getChunkPos", "()Lnet/minecraft/world/level/ChunkPos;", "isEnabled", "", "()Z", "loadedChunk", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "detach", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "setLoadedChunk", "newChunk", "manager", "Lsite/siredvin/turtlematic/util/ChunkManager;", "level", "Lnet/minecraft/server/level/ServerLevel;", "updateChunkState", "Companion", "turtlematic-forge-1.20.1"})
public final class ChunkVialPeripheral
extends OwnedPeripheral<TurtlePeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ChunkPos loadedChunk;
    @NotNull
    private static final String TYPE = "chunk_vial";
    @NotNull
    private static final String UUID_TAG = "uuid";

    public ChunkVialPeripheral(@NotNull TurtlePeripheralOwner peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)peripheralOwner, (String)"peripheralOwner");
        super(TYPE, (IPeripheralOwner)peripheralOwner);
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableChunkVial();
    }

    private final UUID getUuid() {
        CompoundTag storage = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getDataStorage();
        if (!storage.m_128441_(UUID_TAG)) {
            storage.m_128362_(UUID_TAG, UUID.randomUUID());
            ((TurtlePeripheralOwner)this.getPeripheralOwner()).markDataStorageDirty();
        }
        UUID uUID = storage.m_128342_(UUID_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"storage.getUUID(UUID_TAG)");
        return uUID;
    }

    private final ChunkPos getChunkPos() {
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        ChunkPos chunkPos = level.m_46865_(((TurtlePeripheralOwner)this.getPeripheralOwner()).getPos()).m_7697_();
        Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"peripheralOwner.level!!.\u2026(peripheralOwner.pos).pos");
        return chunkPos;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void updateChunkState() {
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        ChunkManager manager = ChunkManager.Companion.get(level2);
        if (this.loadedChunk != null) {
            ChunkPos chunkPos = this.loadedChunk;
            Intrinsics.checkNotNull((Object)chunkPos);
            if (Intrinsics.areEqual((Object)chunkPos, (Object)this.getChunkPos())) {
                manager.touch(this.getUuid());
                return;
            }
        }
        this.setLoadedChunk(this.getChunkPos(), manager, level2);
    }

    private final void setLoadedChunk(ChunkPos newChunk, ChunkManager manager, ServerLevel level) {
        if (this.loadedChunk != null) {
            ChunkManager.removeForceChunk$default(manager, level, this.getUuid(), null, 4, null);
            this.loadedChunk = null;
        }
        if (newChunk != null) {
            this.loadedChunk = newChunk;
            UUID uUID = this.getUuid();
            ChunkPos chunkPos = this.loadedChunk;
            Intrinsics.checkNotNull((Object)chunkPos);
            manager.addForceChunk(level, uUID, chunkPos);
        }
    }

    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        super.detach(computer);
        Level level = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        ChunkManager manager = ChunkManager.Companion.get(level2);
        this.setLoadedChunk(null, manager, level2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/ChunkVialPeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "UUID_TAG", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public ResourceLocation getUPGRADE_ID() {
            return PeripheralConfiguration.DefaultImpls.getUPGRADE_ID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

