/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.misc;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.ext.IArgumentsKt;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLParsingException;
import site.siredvin.peripheralium.extra.dsl.rml1.RenderInstruction;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.client.RenderUtil;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.tags.BlockTags;
import site.siredvin.turtlematic.util.DataStorageObjects;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000eH\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/MimicPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)V", "isEnabled", "", "()Z", "getMimic", "Ldan200/computercraft/api/lua/MethodResult;", "getTransformation", "", "reset", "setMimic", "", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "setTransformation", "rml", "Companion", "turtlematic-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nMimicPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MimicPeripheral.kt\nsite/siredvin/turtlematic/computercraft/peripheral/misc/MimicPeripheral\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class MimicPeripheral
extends OwnedPeripheral<TurtlePeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE = "mimic";

    public MimicPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        super(TYPE, (IPeripheralOwner)new TurtlePeripheralOwner(turtle, side));
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnableMimicGadget();
    }

    @LuaFunction(mainThread=true)
    public final void setTransformation(@NotNull String rml) {
        Intrinsics.checkNotNullParameter((Object)rml, (String)"rml");
        try {
            List<RenderInstruction> instructions = RenderUtil.INSTANCE.parseRML(rml);
            if (instructions.size() > TurtlematicConfig.INSTANCE.getMimicGadgetRMLLimit()) {
                throw new LuaException("You can use up to " + TurtlematicConfig.INSTANCE.getMimicGadgetRMLLimit() + " instructions");
            }
        }
        catch (RMLParsingException exception) {
            throw new LuaException("Unable to parse rml: " + exception.getMessage());
        }
        DataStorageObjects.RMLInstructions.INSTANCE.set(this.getPeripheralOwner(), rml);
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getTransformation() {
        return (String)DataStorageObjects.RMLInstructions.INSTANCE.get(this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    public final void setMimic(@NotNull IArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        BlockState mimic = IArgumentsKt.getBlockState((IArguments)arguments, (int)0);
        if (mimic.m_204336_(BlockTags.INSTANCE.getMIMIC_BLOCKLIST())) {
            throw new LuaException("You cannot mimic this block, he is in blocklist");
        }
        DataStorageObjects.Mimic.INSTANCE.set(this.getPeripheralOwner(), mimic);
        Optional extraData = arguments.optString(1);
        if (extraData.isPresent()) {
            DataStorageObjects.MimicExtraData.INSTANCE.set(this.getPeripheralOwner(), TagParser.m_129359_((String)((String)extraData.get())));
        }
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getMimic() {
        Object object;
        CompoundTag nbtData;
        Map map;
        BlockState blockState2;
        BlockState blockState3 = blockState2 = (BlockState)DataStorageObjects.Mimic.INSTANCE.get(this.getPeripheralOwner());
        if (blockState3 != null) {
            BlockState it = blockState3;
            boolean bl = false;
            map = LuaRepresentation.INSTANCE.forBlockState(it);
        } else {
            map = null;
        }
        Map blockStateData = map;
        CompoundTag compoundTag = nbtData = (CompoundTag)DataStorageObjects.MimicExtraData.INSTANCE.get(this.getPeripheralOwner());
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            object = PeripheraliumPlatform.Companion.nbtToLua((Tag)it);
        } else {
            object = null;
        }
        Object nbtDataRepresentation = object;
        Object[] objectArray = new Object[]{blockStateData, nbtDataRepresentation};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(blockStateData, nbtDataRepresentation)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult reset() {
        DataStorageObjects.Mimic.INSTANCE.set(this.getPeripheralOwner(), null);
        DataStorageObjects.MimicExtraData.INSTANCE.set(this.getPeripheralOwner(), null);
        DataStorageObjects.RMLInstructions.INSTANCE.set(this.getPeripheralOwner(), null);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/MimicPeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public ResourceLocation getUPGRADE_ID() {
            return PeripheralConfiguration.DefaultImpls.getUPGRADE_ID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

