/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.peripheral.misc;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.datatypes.VerticalDirection;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.computercraft.peripheral.OwnedPeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.util.world.PistonSimulation;
import site.siredvin.turtlematic.api.PeripheralConfiguration;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.util.DataStorageObjects;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/PistonPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/OwnedPeripheral;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)V", "isEnabled", "", "()Z", "isSilent", "push", "Ldan200/computercraft/api/lua/MethodResult;", "arguments", "Ldan200/computercraft/api/lua/IArguments;", "setSilent", "", "value", "Companion", "turtlematic-forge-1.20.1"})
public final class PistonPeripheral
extends OwnedPeripheral<TurtlePeripheralOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE = "piston";

    public PistonPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        super(TYPE, (IPeripheralOwner)new TurtlePeripheralOwner(turtle, side));
    }

    public boolean isEnabled() {
        return TurtlematicConfig.INSTANCE.getEnablePistonTurtle();
    }

    @LuaFunction(mainThread=true)
    public final boolean isSilent() {
        return (Boolean)DataStorageObjects.Silent.INSTANCE.get(this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    public final void setSilent(boolean value) {
        DataStorageObjects.Silent.INSTANCE.set(this.getPeripheralOwner(), Boolean.valueOf(value));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult push(@NotNull IArguments arguments) {
        MethodResult methodResult;
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Optional directionArgument = arguments.optString(0);
        if (directionArgument.isEmpty()) {
            direction = ((TurtlePeripheralOwner)this.getPeripheralOwner()).getFacing();
        } else {
            Object t = directionArgument.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"directionArgument.get()");
            direction = VerticalDirection.Companion.luaValueOf((String)t).getMinecraftDirection();
        }
        Direction direction2 = direction;
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        PistonStructureResolver resolver = new PistonStructureResolver(level2, this.getPos(), direction2, true);
        if (!resolver.m_60422_()) {
            Object[] objectArray = new Object[]{null, "Cannot resolve piston structure"};
            MethodResult methodResult2 = MethodResult.of((Object[])objectArray);
            methodResult = methodResult2;
            Intrinsics.checkNotNullExpressionValue((Object)methodResult2, (String)"{\n            MethodResu\u2026ton structure\")\n        }");
        } else {
            PistonSimulation.INSTANCE.move(level2, resolver, direction2, true);
            if (!((Boolean)DataStorageObjects.Silent.INSTANCE.get(this.getPeripheralOwner())).booleanValue()) {
                level2.m_5594_(((TurtlePeripheralOwner)this.getPeripheralOwner()).getOwner(), ((TurtlePeripheralOwner)this.getPeripheralOwner()).getPos(), SoundEvents.f_12311_, SoundSource.BLOCKS, (float)TurtlematicConfig.INSTANCE.getPistonVolumeLevel(), (float)TurtlematicConfig.INSTANCE.getPistonPitchLevel());
            }
            MethodResult methodResult3 = MethodResult.of((Object)true);
            methodResult = methodResult3;
            Intrinsics.checkNotNullExpressionValue((Object)methodResult3, (String)"{\n            PistonSimu\u2026Result.of(true)\n        }");
        }
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/turtlematic/computercraft/peripheral/misc/PistonPeripheral$Companion;", "Lsite/siredvin/turtlematic/api/PeripheralConfiguration;", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "turtlematic-forge-1.20.1"})
    public static final class Companion
    implements PeripheralConfiguration {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public ResourceLocation getUPGRADE_ID() {
            return PeripheralConfiguration.DefaultImpls.getUPGRADE_ID(this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

