/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.util.DataStorageUtil;
import site.siredvin.peripheralium.xplat.XplatRegistries;
import site.siredvin.turtlematic.tags.BlockTags;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0003\u0004\u0005\u0006\u0007\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\f"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects;", "", "()V", "AbstractDataObject", "AbstractNotNullDataObject", "Angle", "Mimic", "MimicExtraData", "RMLInstructions", "RotationCharge", "Silent", "TurtleChat", "turtlematic-forge-1.20.1"})
public final class DataStorageObjects {
    @NotNull
    public static final DataStorageObjects INSTANCE = new DataStorageObjects();

    private DataStorageObjects() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0002\u0010\u000bJ \u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\"R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractDataObject;", "T", "", "()V", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "get", "access", "Ldan200/computercraft/api/pocket/IPocketAccess;", "(Ldan200/computercraft/api/pocket/IPocketAccess;)Ljava/lang/Object;", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)Ljava/lang/Object;", "storage", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Object;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)Ljava/lang/Object;", "read", "data", "set", "", "blockState", "(Ldan200/computercraft/api/pocket/IPocketAccess;Ljava/lang/Object;)V", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Ljava/lang/Object;)V", "value", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/Object;)V", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;Ljava/lang/Object;)V", "write", "", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/Object;)Z", "turtlematic-forge-1.20.1"})
    public static abstract class AbstractDataObject<T> {
        @NotNull
        public abstract String getNbtTag();

        @Nullable
        public abstract T read(@NotNull CompoundTag var1);

        public abstract boolean write(@NotNull CompoundTag var1, T var2);

        @Nullable
        public final T get(@NotNull CompoundTag storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            if (!storage.m_128441_(this.getNbtTag())) {
                return null;
            }
            T value = this.read(storage);
            if (value == null) {
                storage.m_128473_(this.getNbtTag());
                return null;
            }
            return value;
        }

        @Nullable
        public final T get(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return this.get(DataStorageUtil.INSTANCE.getDataStorage(access, side));
        }

        @Nullable
        public final T get(@NotNull IPocketAccess access) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            return this.get(DataStorageUtil.INSTANCE.getDataStorage(access));
        }

        @Nullable
        public final T get(@NotNull IPeripheralOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return this.get(owner.getDataStorage());
        }

        public final void set(@NotNull CompoundTag storage, @Nullable T value) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            if (value == null) {
                storage.m_128473_(this.getNbtTag());
            } else {
                boolean writeResult = this.write(storage, value);
                if (!writeResult) {
                    storage.m_128473_(this.getNbtTag());
                }
            }
        }

        public final void set(@NotNull IPeripheralOwner owner, @Nullable T blockState2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.set(owner.getDataStorage(), blockState2);
            owner.markDataStorageDirty();
        }

        public final void set(@NotNull IPocketAccess access, @Nullable T blockState2) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            this.set(DataStorageUtil.INSTANCE.getDataStorage(access), blockState2);
            access.updateUpgradeNBTData();
        }

        public final void set(@NotNull ITurtleAccess access, @NotNull TurtleSide side, @Nullable T blockState2) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.set(DataStorageUtil.INSTANCE.getDataStorage(access, side), blockState2);
            access.updateUpgradeNBTData(side);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010!J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010 \u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010%R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractNotNullDataObject;", "T", "", "()V", "default", "getDefault", "()Ljava/lang/Object;", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "get", "access", "Ldan200/computercraft/api/pocket/IPocketAccess;", "(Ldan200/computercraft/api/pocket/IPocketAccess;)Ljava/lang/Object;", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)Ljava/lang/Object;", "storage", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Object;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)Ljava/lang/Object;", "read", "data", "set", "", "blockState", "(Ldan200/computercraft/api/pocket/IPocketAccess;Ljava/lang/Object;)V", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Ljava/lang/Object;)V", "value", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/Object;)V", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;Ljava/lang/Object;)V", "write", "", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/Object;)Z", "turtlematic-forge-1.20.1"})
    public static abstract class AbstractNotNullDataObject<T> {
        @NotNull
        public abstract String getNbtTag();

        public abstract T getDefault();

        public abstract T read(@NotNull CompoundTag var1);

        public abstract boolean write(@NotNull CompoundTag var1, T var2);

        public final T get(@NotNull CompoundTag storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            if (!storage.m_128441_(this.getNbtTag())) {
                return this.getDefault();
            }
            T value = this.read(storage);
            if (value == null) {
                storage.m_128473_(this.getNbtTag());
                return this.getDefault();
            }
            return value;
        }

        public final T get(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return this.get(DataStorageUtil.INSTANCE.getDataStorage(access, side));
        }

        public final T get(@NotNull IPocketAccess access) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            return this.get(DataStorageUtil.INSTANCE.getDataStorage(access));
        }

        public final T get(@NotNull IPeripheralOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return this.get(owner.getDataStorage());
        }

        public final void set(@NotNull CompoundTag storage, T value) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            boolean writeResult = this.write(storage, value);
            if (!writeResult) {
                storage.m_128473_(this.getNbtTag());
            }
        }

        public final void set(@NotNull IPeripheralOwner owner, T blockState2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.set(owner.getDataStorage(), blockState2);
            owner.markDataStorageDirty();
        }

        public final void set(@NotNull IPocketAccess access, T blockState2) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            this.set(DataStorageUtil.INSTANCE.getDataStorage(access), blockState2);
            access.updateUpgradeNBTData();
        }

        public final void set(@NotNull ITurtleAccess access, @NotNull TurtleSide side, T blockState2) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.set(DataStorageUtil.INSTANCE.getDataStorage(access, side), blockState2);
            access.updateUpgradeNBTData(side);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$Angle;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractNotNullDataObject;", "", "()V", "default", "getDefault", "()Ljava/lang/Double;", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Double;", "write", "", "value", "turtlematic-forge-1.20.1"})
    public static final class Angle
    extends AbstractNotNullDataObject<Double> {
        @NotNull
        public static final Angle INSTANCE = new Angle();

        private Angle() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "angle";
        }

        @Override
        @NotNull
        public Double getDefault() {
            return 0.0;
        }

        @Override
        @NotNull
        public Double read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.m_128459_(this.getNbtTag());
        }

        @Override
        public boolean write(@NotNull CompoundTag data, double value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.m_128347_(this.getNbtTag(), value);
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$Mimic;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractDataObject;", "Lnet/minecraft/world/level/block/state/BlockState;", "()V", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "write", "", "value", "turtlematic-forge-1.20.1"})
    public static final class Mimic
    extends AbstractDataObject<BlockState> {
        @NotNull
        public static final Mimic INSTANCE = new Mimic();

        private Mimic() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "mimic";
        }

        @Override
        @Nullable
        public BlockState read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            BlockState blockState2 = NbtUtils.m_247651_((HolderGetter)((HolderGetter)XplatRegistries.INSTANCE.getBLOCKS()), (CompoundTag)data.m_128469_(this.getNbtTag()));
            if (blockState2.m_204336_(BlockTags.INSTANCE.getMIMIC_BLOCKLIST())) {
                return null;
            }
            return blockState2;
        }

        @Override
        public boolean write(@NotNull CompoundTag data, @NotNull BlockState value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.m_204336_(BlockTags.INSTANCE.getMIMIC_BLOCKLIST())) {
                return false;
            }
            data.m_128365_(this.getNbtTag(), (Tag)NbtUtils.m_129202_((BlockState)value));
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$MimicExtraData;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractDataObject;", "Lnet/minecraft/nbt/CompoundTag;", "()V", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "read", "data", "write", "", "value", "turtlematic-forge-1.20.1"})
    public static final class MimicExtraData
    extends AbstractDataObject<CompoundTag> {
        @NotNull
        public static final MimicExtraData INSTANCE = new MimicExtraData();

        private MimicExtraData() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "mimicNBTData";
        }

        @Override
        @Nullable
        public CompoundTag read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!data.m_128441_(this.getNbtTag())) {
                return null;
            }
            return data.m_128469_(this.getNbtTag());
        }

        @Override
        public boolean write(@NotNull CompoundTag data, @NotNull CompoundTag value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            data.m_128365_(this.getNbtTag(), (Tag)value);
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$RMLInstructions;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractDataObject;", "", "()V", "nbtTag", "getNbtTag", "()Ljava/lang/String;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "write", "", "value", "turtlematic-forge-1.20.1"})
    public static final class RMLInstructions
    extends AbstractDataObject<String> {
        @NotNull
        public static final RMLInstructions INSTANCE = new RMLInstructions();

        private RMLInstructions() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "rml";
        }

        @Override
        @Nullable
        public String read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!data.m_128441_(this.getNbtTag())) {
                return null;
            }
            return data.m_128461_(this.getNbtTag());
        }

        @Override
        public boolean write(@NotNull CompoundTag data, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            data.m_128359_(this.getNbtTag(), value);
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$RotationCharge;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractNotNullDataObject;", "", "()V", "MAX_ROTATION_CHARGE", "ROTATION_STEPS", "default", "getDefault", "()Ljava/lang/Integer;", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "addCycles", "", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "count", "consume", "", "access", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Integer;", "write", "value", "turtlematic-forge-1.20.1"})
    public static final class RotationCharge
    extends AbstractNotNullDataObject<Integer> {
        @NotNull
        public static final RotationCharge INSTANCE = new RotationCharge();
        public static final int ROTATION_STEPS = 36;
        public static final int MAX_ROTATION_CHARGE = 108;

        private RotationCharge() {
        }

        @Override
        @NotNull
        public Integer getDefault() {
            return 0;
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "rotationCharge";
        }

        @Override
        @NotNull
        public Integer read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.m_128451_(this.getNbtTag());
        }

        @Override
        public boolean write(@NotNull CompoundTag data, int value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.m_128405_(this.getNbtTag(), value);
            return true;
        }

        public final boolean consume(@NotNull ITurtleAccess access, @NotNull TurtleSide side) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            int currentCharge = ((Number)this.get(access, side)).intValue();
            if (currentCharge > 0) {
                this.set(access, side, Math.max(0, currentCharge - 1));
                return true;
            }
            return false;
        }

        public final void addCycles(@NotNull IPeripheralOwner owner, int count) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            int currentRotationCharge = ((Number)this.get(owner)).intValue();
            if (currentRotationCharge < 108) {
                this.set(owner, Integer.valueOf(Math.max(0, currentRotationCharge) + count * 36));
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$Silent;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractNotNullDataObject;", "", "()V", "default", "getDefault", "()Ljava/lang/Boolean;", "nbtTag", "", "getNbtTag", "()Ljava/lang/String;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/Boolean;", "write", "value", "turtlematic-forge-1.20.1"})
    public static final class Silent
    extends AbstractNotNullDataObject<Boolean> {
        @NotNull
        public static final Silent INSTANCE = new Silent();

        private Silent() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "silent";
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            return false;
        }

        @Override
        @NotNull
        public Boolean read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.m_128471_(this.getNbtTag());
        }

        @Override
        public boolean write(@NotNull CompoundTag data, boolean value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            data.m_128379_(this.getNbtTag(), value);
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lsite/siredvin/turtlematic/util/DataStorageObjects$TurtleChat;", "Lsite/siredvin/turtlematic/util/DataStorageObjects$AbstractDataObject;", "", "()V", "nbtTag", "getNbtTag", "()Ljava/lang/String;", "read", "data", "Lnet/minecraft/nbt/CompoundTag;", "write", "", "value", "turtlematic-forge-1.20.1"})
    public static final class TurtleChat
    extends AbstractDataObject<String> {
        @NotNull
        public static final TurtleChat INSTANCE = new TurtleChat();

        private TurtleChat() {
        }

        @Override
        @NotNull
        public String getNbtTag() {
            return "chatMessage";
        }

        @Override
        @Nullable
        public String read(@NotNull CompoundTag data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (data.m_128441_(this.getNbtTag())) {
                return data.m_128461_(this.getNbtTag());
            }
            return null;
        }

        @Override
        public boolean write(@NotNull CompoundTag data, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            data.m_128359_(this.getNbtTag(), value);
            return true;
        }
    }
}

