/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.turtlematic.util.ExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\bH&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lsite/siredvin/turtlematic/util/TurtleDispenseBehavior;", "", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;)V", "getOwner", "()Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "dispense", "Lnet/minecraft/world/item/ItemStack;", "turtleBlockSource", "Lnet/minecraft/core/BlockSource;", "stack", "power", "", "angle", "execute", "getDispensePosition", "Lnet/minecraft/core/Position;", "direction", "Lnet/minecraft/core/Direction;", "getProjectile", "Lnet/minecraft/world/entity/projectile/Projectile;", "level", "Lnet/minecraft/world/level/Level;", "targetPosition", "playSound", "", "turtlematic-forge-1.20.1"})
public abstract class TurtleDispenseBehavior {
    @NotNull
    private final IPeripheralOwner owner;

    public TurtleDispenseBehavior(@NotNull IPeripheralOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
    }

    @NotNull
    protected final IPeripheralOwner getOwner() {
        return this.owner;
    }

    @NotNull
    public final Position getDispensePosition(@NotNull Direction direction, @NotNull BlockSource turtleBlockSource) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)turtleBlockSource, (String)"turtleBlockSource");
        double x = turtleBlockSource.m_7096_() + 0.7 * (double)direction.m_122429_();
        double y = turtleBlockSource.m_7098_() + 0.7 * (double)direction.m_122430_();
        double z = turtleBlockSource.m_7094_() + 0.7 * (double)direction.m_122431_();
        return (Position)new PositionImpl(x, y, z);
    }

    @NotNull
    public final ItemStack dispense(@NotNull BlockSource turtleBlockSource, @NotNull ItemStack stack, double power, double angle) {
        Intrinsics.checkNotNullParameter((Object)turtleBlockSource, (String)"turtleBlockSource");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack resultStack = this.execute(turtleBlockSource, stack, power, angle);
        this.playSound(turtleBlockSource);
        return resultStack;
    }

    @NotNull
    public ItemStack execute(@NotNull BlockSource turtleBlockSource, @NotNull ItemStack stack, double power, double angle) {
        Intrinsics.checkNotNullParameter((Object)turtleBlockSource, (String)"turtleBlockSource");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ServerLevel serverLevel = turtleBlockSource.m_7727_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"turtleBlockSource.level");
        Level level = (Level)serverLevel;
        Direction currentDirection = this.owner.getFacing();
        Position targetPosition = this.getDispensePosition(currentDirection, turtleBlockSource);
        Projectile entity = this.getProjectile(level, targetPosition, stack);
        double directionalMovement = power * Math.cos(angle);
        double verticalMovement = power * Math.sin(angle);
        ExtensionsKt.advancedShoot(entity, new Vec3((double)currentDirection.m_122429_() * directionalMovement, (double)currentDirection.m_122430_() + verticalMovement, (double)currentDirection.m_122431_() * directionalMovement));
        level.m_7967_((Entity)entity);
        return stack;
    }

    protected final void playSound(@NotNull BlockSource turtleBlockSource) {
        Intrinsics.checkNotNullParameter((Object)turtleBlockSource, (String)"turtleBlockSource");
        turtleBlockSource.m_7727_().m_46796_(1002, turtleBlockSource.m_7961_(), 0);
    }

    @NotNull
    public abstract Projectile getProjectile(@NotNull Level var1, @NotNull Position var2, @NotNull ItemStack var3);
}

